#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 VA
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Little Inferno
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251110.4

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='little-inferno'
GAME_NAME='Little Inferno'

ARCHIVE_BASE_LINUX_0_NAME='LittleInferno_Linux_v2.0.3.sh'
ARCHIVE_BASE_LINUX_0_MD5='2d104de7966405f905d36bfbc7722808'
ARCHIVE_BASE_LINUX_0_SIZE='274737'
ARCHIVE_BASE_LINUX_0_VERSION='2.0.3-humble.2022.12.08'
ARCHIVE_BASE_LINUX_0_URL='https://www.humblebundle.com/store/little-inferno'

## Support for the Windows build is provided as a workaround for the following Mesa bug:
## https://gitlab.freedesktop.org/mesa/mesa/-/issues/7903
ARCHIVE_BASE_WINDOWS_0_NAME='LittleInferno_Windows_2.0.3.msi'
ARCHIVE_BASE_WINDOWS_0_MD5='09c79a41f0796642cc2c3e87d99b131e'
ARCHIVE_BASE_WINDOWS_0_SIZE='320837'
ARCHIVE_BASE_WINDOWS_0_VERSION='2.0.3-humble.2022.12.08'
ARCHIVE_BASE_WINDOWS_0_URL='https://www.humblebundle.com/store/little-inferno'

CONTENT_PATH_DEFAULT_LINUX='data'
CONTENT_PATH_DEFAULT_WINDOWS='program files/little inferno'
CONTENT_GAME_BIN_RELATIVE_PATH_LINUX='x86_64'
CONTENT_GAME_BIN_FILES_LINUX='
LittleInferno.bin.x86_64'
CONTENT_GAME_BIN_FILES_WINDOWS='
Little Inferno.exe'
CONTENT_GAME_DATA_RELATIVE_PATH_LINUX='noarch'
CONTENT_GAME_DATA_FILES_LINUX='
shaders
.tc-edition
icon.png
*.pak'
CONTENT_DOC_DATA_RELATIVE_PATH_LINUX='noarch'
CONTENT_DOC_DATA_FILES_LINUX='
LICENSE.txt
README.linux'
CONTENT_DOC_DATA_FILES_WINDOWS='
readme.html'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Little Inferno'

## When playing the Linux native build with Mesa, the game might be shown as a black screen or be full of black artifacts.
## Switching out of fullscreen then back to it with the F key might help in mitigating the rendering issues.
## A bug report has been sent to Mesa developers: https://gitlab.freedesktop.org/mesa/mesa/-/issues/7903
APP_MAIN_EXE_LINUX='LittleInferno.bin.x86_64'
APP_MAIN_EXE_WINDOWS='little inferno.exe'
APP_MAIN_ICON_LINUX='noarch/icon.png'

PACKAGES_LIST_LINUX='
PKG_BIN
PKG_DATA'
PACKAGES_LIST_WINDOWS='
PKG_BIN'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_LINUX="${PKG_BIN_ID}-linux"
PKG_BIN_ID_WINDOWS="${PKG_BIN_ID}-windows"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_ARCH_LINUX='64'
PKG_BIN_ARCH_WINDOWS='32'
PKG_BIN_DEPENDENCIES_SIBLINGS_LINUX='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES_LINUX='
libc.so.6
libgcc_s.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_LINUX="${PKG_DATA_ID}-linux"
PKG_DATA_PROVIDES="
$PKG_DATA_ID"
PKG_DATA_DESCRIPTION='data'
## The Windows build is handled as a single package.
PKG_BIN_PROVIDES_WINDOWS="$PKG_BIN_PROVIDES
$PKG_DATA_ID"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

case "$(current_archive)" in
	('ARCHIVE_BASE_LINUX_'*)
		content_inclusion_icons 'PKG_DATA'
	;;
	('ARCHIVE_BASE_WINDOWS_'*)
		content_inclusion_icons
	;;
esac
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
