(*Generated by Lem from string_extra.lem.*)
(******************************************************************************)
(* String functions                                                           *)
(******************************************************************************)

open Lem_basic_classes
open Lem_num
open Lem_list
open Lem_string
open Lem_list_extra


(******************************************************************************)
(* Character's to numbers                                                     *)
(******************************************************************************)

(*val ord : char -> nat*)

(*val chr : nat -> char*)

(******************************************************************************)
(* Converting to strings                                                      *)
(******************************************************************************)

type 'a show_class={
  show_method : 'a -> string
}

(*val natToStringHelper : nat -> list char -> list char*)
let rec natToStringHelper n acc =  
(if n = 0 then
    acc
  else
    natToStringHelper (n / 10) (Char.chr ((n mod  10) + 48) :: acc))

(*val natToString : nat -> string*)
let natToString n = (Xstring.implode (natToStringHelper n []))

let instance_String_extra_Show_nat_dict =({

  show_method = natToString})

(*val naturalToStringHelper : natural -> list char -> list char*)
let rec naturalToStringHelper n acc =  
(if Big_int.eq_big_int n(Big_int.big_int_of_int 0) then
    acc
  else
    naturalToStringHelper ( Big_int.div_big_int n(Big_int.big_int_of_int 10)) (Char.chr (Big_int.int_of_big_int ( Big_int.add_big_int (Big_int.mod_big_int n(Big_int.big_int_of_int 10))(Big_int.big_int_of_int 48))) :: acc))

(*val naturalToString : natural -> string*)
let naturalToString n = (Xstring.implode (naturalToStringHelper n []))

let instance_String_extra_Show_Num_natural_dict =({

  show_method = naturalToString})


(******************************************************************************)
(* List-like operations                                                       *)
(******************************************************************************)

(*val nth : string -> nat -> char*)
(*let nth s n = List_extra.nth (toCharList s) n*)

(*val stringConcat : list string -> string*)
(*let stringConcat s =
  List.foldr (^) "" s*)

(******************************************************************************)
(* String comparison                                                          *)
(******************************************************************************)

(*val stringCompare : string -> string -> ordering*)

let stringLess x y = (Lem.orderingIsLess (compare x y))
let stringLessEq x y = (not (Lem.orderingIsGreater (compare x y)))
let stringGreater x y = (stringLess y x)
let stringGreaterEq x y = (stringLessEq y x)

let instance_Basic_classes_Ord_string_dict =({

  compare_method = compare;

  isLess_method = stringLess;

  isLessEqual_method = stringLessEq;

  isGreater_method = stringGreater;

  isGreaterEqual_method = stringGreaterEq})
 
