
(* The type of tokens. *)

type token = 
  | YIELDS
  | WHILE
  | VARLPAR of (string)
  | VARLBRA of (string)
  | VAR of (string)
  | UNDERSCORE
  | UMINUS
  | TRY
  | TO
  | TIMES
  | TIME of (int option list)
  | TILD
  | THEN
  | STRING of (string )
  | SLASH
  | SET
  | SEQSEQ
  | SEQ
  | RPAR
  | REPLACES
  | REGEXP of (string * char list )
  | RCUR
  | RBRA
  | QUESTION
  | PP_STRING of (string * Pos.t)
  | PP_REGEXP of (string * char list * Pos.t)
  | PP_INT_DOT_LCUR of (int)
  | PP_INCLUDE of (string)
  | PP_IFVERSION of ([ `Eq | `Geq | `Leq | `Gt | `Lt] * string)
  | PP_IFNENCODER
  | PP_IFNDEF of (string)
  | PP_IFENCODER
  | PP_IFDEF of (string)
  | PP_ENDL
  | PP_ENDIF
  | PP_ELSE
  | PP_DEFINE
  | PP_DEF of (Parser_helper.lexer_let_decoration)
  | PP_COMMENT of (string list)
  | OPEN
  | NOT
  | MINUS
  | LPAR
  | LETLBRA of (Parser_helper.lexer_let_decoration)
  | LET of (Parser_helper.lexer_let_decoration)
  | LCUR
  | LBRA
  | INTERVAL of (int option list * int option list)
  | INT of (int)
  | IF
  | GETS
  | GET
  | FUN
  | FOR
  | FLOAT of (float)
  | EOF
  | END
  | ENCODER of (string)
  | ELSIF
  | ELSE
  | DOTVAR of (string)
  | DOTDOTDOT
  | DOT
  | DO
  | DEF of ((Doc.item * (string*string) list * (string*string) list)*Parser_helper.let_decoration)
  | COMMA
  | COLONCOLON
  | COLON
  | COALESCE
  | CATCH
  | BOOL of (bool)
  | BINB of (string)
  | BIN3 of (string)
  | BIN2 of (string)
  | BIN1 of (string)
  | BEGIN
  | ARGS_OF

(* This exception is raised by the monolithic API functions. *)

exception Error

(* The monolithic API. *)

val time_predicate: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Term.t)

val program: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Term.t)

val interactive: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Term.t)

val annotate_metadata_entry: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (string * string)

val annotate: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> ((string * string) list)
