/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import java.util.StringTokenizer;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.graphics.PolygonFiller;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.CurveEditDialog;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class FunctionObject
extends ConstructionObject
implements PointonObject {
    Expression EX = null;
    Expression EY = null;
    Expression VarMin = null;
    Expression VarMax = null;
    Expression DVar = null;
    double[] X = new double[]{0.0};
    String[] Var = new String[]{"x"};
    boolean Filled = false;
    Expression Center = null;
    protected int Type = 0;
    public static final int SQUARE = 0;
    public static final int DIAMOND = 1;
    public static final int CIRCLE = 2;
    public static final int DOT = 3;
    public static final int CROSS = 4;
    public static final int DCROSS = 5;
    protected boolean Special = false;
    PolygonFiller PF = null;
    double C1;
    double C2;
    int C;
    int R;
    int W;
    int H;
    static double[] x = new double[4];
    static double[] y = new double[4];
    public boolean EditAborted;

    public FunctionObject(Construction construction) {
        super(construction);
        this.VarMin = new Expression("-10", construction, this);
        this.VarMax = new Expression("10", construction, this);
        this.DVar = new Expression("0.1", construction, this);
        this.validate();
        this.updateText();
    }

    public void setFilled(boolean bl) {
        this.Filled = bl;
    }

    public boolean isFilled() {
        return this.Filled;
    }

    public String getTag() {
        return "Function";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (this.EX != null && this.EY != null) {
            this.setText(FunctionObject.text2(Zirkel.name("text.function"), this.EX.toString(), this.EY.toString()));
        } else {
            this.setText(FunctionObject.text2(Zirkel.name("text.function"), "", ""));
        }
    }

    public void validate() {
        this.Valid = this.EX != null && this.EY != null ? this.EX.isValid() && this.EY.isValid() && this.VarMin.isValid() && this.VarMax.isValid() && this.DVar.isValid() : false;
    }

    public void setExpressions(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.Var = new String[stringTokenizer.countTokens()];
        this.X = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.Var[n++] = stringTokenizer.nextToken();
        }
        if (string2.equals("")) {
            string2 = this.Var[0];
        }
        this.EX = new Expression(string2, this.getConstruction(), this, this.Var);
        this.EY = new Expression(string3, this.getConstruction(), this, this.Var);
        this.validate();
    }

    public void setRange(String string, String string2, String string3) {
        this.VarMin = new Expression(string, this.getConstruction(), this);
        this.VarMax = new Expression(string2, this.getConstruction(), this);
        this.DVar = new Expression(string3, this.getConstruction(), this);
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return this.Var[0];
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        boolean bl = this.Special;
        boolean bl2 = false;
        try {
            d6 = this.VarMin.getValue();
            d5 = this.VarMax.getValue();
            d4 = this.DVar.getValue();
            if (d6 > d5) {
                double d7 = d6;
                d6 = d5;
                d5 = d7;
                bl2 = true;
            }
            if (d4 < 0.0) {
                d4 = -d4;
            }
            if (d4 < (d5 - d6) / 1000.0) {
                d4 = (d5 - d6) / 1000.0;
            }
        }
        catch (Exception exception) {
            this.Valid = false;
            return;
        }
        this.X[0] = d6;
        if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
            PolygonDrawer polygonDrawer = new PolygonDrawer(myGraphics, this);
            polygonDrawer.useAsMarker();
            d3 = 0.0;
            d2 = 0.0;
            while (true) {
                try {
                    d3 = this.EX.getValue();
                    d2 = this.EY.getValue();
                    if (Math.abs(zirkelCanvas.col(d3)) + Math.abs(zirkelCanvas.col(d2)) > 100000.0) {
                        this.finish(myGraphics, zirkelCanvas);
                        this.C1 = this.X[0];
                        if (polygonDrawer != null) {
                            polygonDrawer.finishPolygon();
                        }
                    } else {
                        if (!bl || this.isFilled()) {
                            if (bl && this.isFilled() && polygonDrawer.hasStarted()) {
                                if (bl2) {
                                    polygonDrawer.drawTo(polygonDrawer.c(), zirkelCanvas.row(d2));
                                    polygonDrawer.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                                } else {
                                    polygonDrawer.drawTo(zirkelCanvas.col(d3), polygonDrawer.r());
                                    polygonDrawer.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                                }
                            }
                            polygonDrawer.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                        } else {
                            ((MyGraphics13)myGraphics).drawMarkerLine(zirkelCanvas.col(d3), zirkelCanvas.row(d2), zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                        }
                        this.C2 = this.X[0];
                    }
                }
                catch (Exception exception) {
                    this.finish(myGraphics, zirkelCanvas);
                    this.C1 = this.X[0];
                    polygonDrawer.finishPolygon();
                }
                if (this.X[0] >= d5) break;
                this.X[0] = this.X[0] + d4;
                if (!(this.X[0] > d5)) continue;
                this.X[0] = d5;
            }
            polygonDrawer.finishPolygon();
        }
        this.X[0] = d6;
        myGraphics.setColor(this);
        PolygonDrawer polygonDrawer = null;
        if (!bl || this.isFilled()) {
            polygonDrawer = new PolygonDrawer(myGraphics, this);
        }
        if (this.isFilled()) {
            if (this.PF == null) {
                this.PF = new PolygonFiller(myGraphics, this);
            }
            this.PF.start();
            this.PF.setGraphics(myGraphics);
        }
        this.C1 = this.X[0];
        d3 = 0.0;
        d2 = 0.0;
        while (true) {
            try {
                d3 = this.EX.getValue();
                d2 = this.EY.getValue();
                if (Math.abs(zirkelCanvas.col(d3)) + Math.abs(zirkelCanvas.col(d2)) > 100000.0) {
                    this.finish(myGraphics, zirkelCanvas);
                    this.C1 = this.X[0];
                    if (polygonDrawer != null) {
                        polygonDrawer.finishPolygon();
                    }
                } else {
                    if (this.isFilled()) {
                        if (this.PF.length() == 0) {
                            this.C1 = this.X[0];
                        }
                        if (bl) {
                            if (polygonDrawer.hasStarted()) {
                                if (bl2) {
                                    this.PF.drawTo(polygonDrawer.c(), zirkelCanvas.row(d2));
                                    this.PF.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                                } else {
                                    this.PF.drawTo(zirkelCanvas.col(d3), polygonDrawer.r());
                                    this.PF.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                                }
                            } else {
                                this.PF.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                            }
                        } else {
                            this.PF.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2), this.X[0] < d5);
                        }
                    }
                    if (polygonDrawer != null) {
                        if (bl && this.isFilled() && polygonDrawer.hasStarted()) {
                            if (bl2) {
                                polygonDrawer.drawTo(polygonDrawer.c(), zirkelCanvas.row(d2));
                                polygonDrawer.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                            } else {
                                polygonDrawer.drawTo(zirkelCanvas.col(d3), polygonDrawer.r());
                                polygonDrawer.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                            }
                        }
                        polygonDrawer.drawTo(zirkelCanvas.col(d3), zirkelCanvas.row(d2));
                    } else {
                        PointObject.drawPoint(myGraphics, zirkelCanvas, this, d3, d2, this.Type);
                    }
                    this.C2 = this.X[0];
                }
            }
            catch (Exception exception) {
                this.finish(myGraphics, zirkelCanvas);
                this.C1 = this.X[0];
                polygonDrawer.finishPolygon();
            }
            if (this.X[0] >= d5) break;
            this.X[0] = this.X[0] + d4;
            if (!(this.X[0] > d5)) continue;
            this.X[0] = d5;
        }
        this.finish(myGraphics, zirkelCanvas);
        if (polygonDrawer != null) {
            polygonDrawer.finishPolygon();
        }
    }

    public void finish(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        if (this.isFilled()) {
            if (this.getEX().equals(this.getVar())) {
                System.out.println(this.C1 + " " + this.C2);
                this.PF.drawTo(zirkelCanvas.col(this.C2), zirkelCanvas.row(0.0));
                this.PF.drawTo(zirkelCanvas.col(this.C1), zirkelCanvas.row(0.0));
            } else if (this.getCenter() != null) {
                this.PF.drawTo(zirkelCanvas.col(this.getCenter().getX()), zirkelCanvas.row(this.getCenter().getY()));
            } else {
                this.PF.drawTo(zirkelCanvas.col(0.0), zirkelCanvas.row(0.0));
            }
            this.PF.finishPolygon();
        }
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.X[0];
    }

    public double getValue(String string) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        for (int i = 0; i < this.Var.length; ++i) {
            if (!string.equals(this.Var[i])) continue;
            return this.X[i];
        }
        return this.X[0];
    }

    public double getIntegral() throws ConstructionException {
        return this.getSum();
    }

    public String getDisplayValue() {
        if (this.getEX().equals(this.getVar())) {
            return this.EY.toString();
        }
        return "(" + this.EX.toString() + "," + this.EY.toString() + ")";
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        int n3 = (int)zirkelCanvas.selectionSize();
        try {
            d5 = this.VarMin.getValue();
            d4 = this.VarMax.getValue();
            d3 = this.DVar.getValue();
            if (d5 > d4) {
                d2 = d5;
                d5 = d4;
                d4 = d2;
            }
            if (d3 < 0.0) {
                d3 = -d3;
            }
            if (d3 < (d4 - d5) / 1000.0) {
                d3 = (d4 - d5) / 1000.0;
            }
        }
        catch (Exception exception) {
            this.Valid = false;
            return false;
        }
        this.X[0] = d5;
        d2 = zirkelCanvas.x(n);
        double d6 = zirkelCanvas.y(n2);
        boolean bl = false;
        double d7 = 0.0;
        double d8 = 0.0;
        while (this.X[0] < d4) {
            this.X[0] = this.X[0] + d3;
            if (this.X[0] > d4) {
                this.X[0] = d4;
            }
            try {
                double d9 = this.EX.getValue();
                double d10 = this.EY.getValue();
                if (Math.abs(zirkelCanvas.col(d9)) + Math.abs(zirkelCanvas.col(d10)) > 100000.0) {
                    throw new Exception("");
                }
                if (bl) {
                    double d11;
                    this.Value = Math.abs((double)n - zirkelCanvas.col(d9)) + Math.abs((double)n2 - zirkelCanvas.row(d10));
                    if (this.Value <= (double)n3) {
                        return true;
                    }
                    double d12 = Math.sqrt(Math.abs(d9 - d7) * Math.abs(d9 - d7) + Math.abs(d10 - d8) * Math.abs(d10 - d8));
                    if (d12 > 1.0E-5 && (d11 = ((d2 - d7) * (d9 - d7) + (d6 - d8) * (d10 - d8)) / d12) >= 0.0 && d11 <= d12) {
                        this.Value = Math.abs(((d2 - d7) * (d10 - d8) - (d6 - d8) * (d9 - d7)) / d12) / zirkelCanvas.dx(1);
                        if (this.Value <= (double)n3) {
                            return true;
                        }
                    }
                }
                d7 = d9;
                d8 = d10;
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return false;
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        CurveEditDialog curveEditDialog;
        while (true) {
            Warning warning;
            Frame frame;
            curveEditDialog = new CurveEditDialog(zirkelCanvas, this);
            curveEditDialog.setVisible(true);
            this.EditAborted = false;
            if (curveEditDialog.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (!this.EX.isValid()) {
                frame = zirkelCanvas.getFrame();
                warning = new Warning(frame, this.EX.getErrorText(), Zirkel.name("warning"), true);
                warning.center(frame);
                warning.setVisible(true);
                continue;
            }
            if (this.EY.isValid()) break;
            frame = zirkelCanvas.getFrame();
            warning = new Warning(frame, this.EY.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        this.validate();
        this.updateText();
        zirkelCanvas.getConstruction().updateCircleDep();
        zirkelCanvas.repaint();
        if (curveEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("x", this.EX.toString());
        xmlWriter.printArg("y", this.EY.toString());
        xmlWriter.printArg("var", this.getVar());
        xmlWriter.printArg("min", "" + this.VarMin);
        xmlWriter.printArg("max", "" + this.VarMax);
        xmlWriter.printArg("d", "" + this.DVar);
        if (this.Special) {
            xmlWriter.printArg("special", "true");
        }
        this.printType(xmlWriter);
        if (this.Filled) {
            xmlWriter.printArg("filled", "true");
        }
        if (this.getCenter() != null) {
            xmlWriter.printArg("center", this.getCenter().getName());
        }
    }

    public void setType(int n) {
        this.Type = n;
    }

    public int getType() {
        return this.Type;
    }

    public void printType(XmlWriter xmlWriter) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xmlWriter.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xmlWriter.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xmlWriter.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xmlWriter.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xmlWriter.printArg("shape", "dcross");
                }
            }
        }
    }

    public void translate() {
        try {
            this.EX = new Expression(this.EX.toString(), this.getConstruction(), this, this.Var);
            this.EY = new Expression(this.EY.toString(), this.getConstruction(), this, this.Var);
            this.VarMin = new Expression(this.VarMin.toString(), this.getConstruction(), this);
            this.VarMax = new Expression(this.VarMax.toString(), this.getConstruction(), this);
            this.DVar = new Expression(this.DVar.toString(), this.getConstruction(), this);
            ConstructionObject constructionObject = this.getTranslation();
            this.setTranslation(this);
            this.EX.translate();
            this.EY.translate();
            this.VarMin.translate();
            this.VarMax.translate();
            this.DVar.translate();
            if (this.getCenter() != null) {
                this.setCenter(this.getCenter().getName());
                this.Center.translate();
            }
            this.validate();
            this.setTranslation(constructionObject);
        }
        catch (Exception exception) {
            System.out.println();
            System.out.println(this.getName());
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return false;
    }

    public boolean equals(ConstructionObject constructionObject) {
        return false;
    }

    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.EX);
        this.addDepending(this.EY);
        this.addDepending(this.VarMin);
        this.addDepending(this.VarMax);
        this.addDepending(this.DVar);
        return DL.elements();
    }

    public void addDepending(Expression expression) {
        if (expression != null) {
            Enumeration enumeration = expression.getDepList().elements();
            while (enumeration.hasMoreElements()) {
                DL.add((ConstructionObject)enumeration.nextElement());
            }
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public double evaluateF(double[] dArray) throws ConstructionException {
        int n;
        int n2 = dArray.length;
        if (n2 > this.X.length) {
            n2 = this.X.length;
        }
        for (n = 0; n < n2; ++n) {
            this.X[n] = dArray[n];
        }
        for (n = n2; n < this.X.length; ++n) {
            this.X[n] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception exception) {
            throw new ConstructionException("");
        }
    }

    public double evaluateF(double d2) throws ConstructionException {
        this.X[0] = d2;
        for (int i = 1; i < this.X.length; ++i) {
            this.X[i] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception exception) {
            throw new ConstructionException("");
        }
    }

    public void project(PointObject pointObject) {
        double d2;
        double d3;
        double d4;
        double d5;
        try {
            d5 = this.VarMin.getValue();
            d4 = this.VarMax.getValue();
            d3 = this.DVar.getValue();
            if (d5 > d4) {
                d2 = d5;
                d5 = d4;
                d4 = d2;
            }
            if (d3 < (d4 - d5) / 1000.0) {
                d3 = (d4 - d5) / 1000.0;
            }
        }
        catch (Exception exception) {
            this.Valid = false;
            return;
        }
        this.X[0] = d5;
        d2 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        boolean bl = false;
        while (true) {
            try {
                double d10 = this.EX.getValue();
                double d11 = this.EY.getValue();
                if (!bl) {
                    d9 = Math.sqrt((pointObject.getX() - d10) * (pointObject.getX() - d10) + (pointObject.getY() - d11) * (pointObject.getY() - d11));
                    d7 = d2 = d10;
                    d8 = d6 = d11;
                    bl = true;
                } else {
                    double d12 = (d10 - d7) * (d10 - d7) + (d11 - d8) * (d11 - d8);
                    double d13 = (pointObject.getX() - d7) * (d10 - d7) + (pointObject.getY() - d8) * (d11 - d8);
                    if (d13 < 0.0) {
                        d13 = 0.0;
                    }
                    if (d13 > d12) {
                        d13 = d12;
                    }
                    double d14 = d7 + d13 / d12 * (d10 - d7);
                    double d15 = d8 + d13 / d12 * (d11 - d8);
                    double d16 = Math.sqrt((pointObject.getX() - d14) * (pointObject.getX() - d14) + (pointObject.getY() - d15) * (pointObject.getY() - d15));
                    if (d16 < d9) {
                        d9 = d16;
                        d2 = d14;
                        d6 = d15;
                    }
                    d7 = d10;
                    d8 = d11;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= d4) break;
            this.X[0] = this.X[0] + d3;
            if (!(this.X[0] > d4)) continue;
            this.X[0] = d4;
        }
        if (bl) {
            pointObject.setXY(d2, d6);
        }
    }

    public double getSum() {
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl = false;
        boolean bl2 = !this.getEX().equals(this.getVar());
        try {
            d5 = this.VarMin.getValue();
            d4 = this.VarMax.getValue();
            d3 = this.DVar.getValue();
            if (d5 > d4) {
                d2 = d5;
                d5 = d4;
                d4 = d2;
                bl = true;
            }
            if (d3 < 0.0) {
                d3 = -d3;
            }
            if (d3 < (d4 - d5) / 1000.0) {
                d3 = (d4 - d5) / 1000.0;
            }
        }
        catch (Exception exception) {
            this.Valid = false;
            return 0.0;
        }
        this.X[0] = d5;
        d2 = 0.0;
        double d6 = 0.0;
        boolean bl3 = false;
        double d7 = 0.0;
        while (true) {
            try {
                double d8 = this.EX.getValue();
                double d9 = this.EY.getValue();
                if (bl2) {
                    double d10 = 0.0;
                    double d11 = 0.0;
                    if (this.getCenter() != null) {
                        d10 = this.getCenter().getX();
                        d11 = this.getCenter().getY();
                    }
                    if (bl3) {
                        d7 += ((d2 - d10) * (d9 - d11) - (d6 - d11) * (d8 - d10)) / 2.0;
                    }
                } else if (bl3) {
                    d7 = this.Special ? (bl ? (d7 += (d8 - d2) * d9) : (d7 += (d8 - d2) * d6)) : (d7 += (d8 - d2) * (d6 + d9) / 2.0);
                }
                d2 = d8;
                d6 = d9;
                bl3 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= d4) break;
            this.X[0] = this.X[0] + d3;
            if (!(this.X[0] > d4)) continue;
            this.X[0] = d4;
        }
        return d7;
    }

    public double getLength() {
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl = false;
        boolean bl2 = !this.getEX().equals(this.getVar());
        try {
            d5 = this.VarMin.getValue();
            d4 = this.VarMax.getValue();
            d3 = this.DVar.getValue();
            if (d5 > d4) {
                d2 = d5;
                d5 = d4;
                d4 = d2;
                bl = true;
            }
            if (d3 < 0.0) {
                d3 = -d3;
            }
            if (d3 < (d4 - d5) / 1000.0) {
                d3 = (d4 - d5) / 1000.0;
            }
        }
        catch (Exception exception) {
            this.Valid = false;
            return 0.0;
        }
        this.X[0] = d5;
        d2 = 0.0;
        double d6 = 0.0;
        boolean bl3 = false;
        double d7 = 0.0;
        while (true) {
            try {
                double d8 = this.EX.getValue();
                double d9 = this.EY.getValue();
                if (bl3) {
                    d7 += Math.sqrt((d8 - d2) * (d8 - d2) + (d9 - d6) * (d9 - d6));
                }
                bl3 = true;
                d2 = d8;
                d6 = d9;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= d4) break;
            this.X[0] = this.X[0] + d3;
            if (!(this.X[0] > d4)) continue;
            this.X[0] = d4;
        }
        return d7;
    }

    public boolean isSpecial() {
        return this.Special;
    }

    public void setSpecial(boolean bl) {
        this.Special = bl;
    }

    public void project(PointObject pointObject, double d2) {
        this.project(pointObject);
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean canDisplayName() {
        return false;
    }

    public void setCenter(String string) {
        if (this.Cn == null) {
            return;
        }
        this.Center = new Expression("@\"" + string + "\"", this.Cn, this);
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public PointObject getCenter() {
        try {
            return (PointObject)this.Center.getObject();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getVar() {
        String string = this.Var[0];
        for (int i = 1; i < this.Var.length; ++i) {
            string = string + " " + this.Var[i];
        }
        return string;
    }

    public boolean canInteresectWith(ConstructionObject constructionObject) {
        return true;
    }
}

