/*
 *  Copyright (C) 2006-2017, Thomas Maier-Komor
 *
 *  This is the source code of xjobs.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LOG_H
#define LOG_H

typedef enum { Silent = 0, Error, Warning, Info, Status, Debug } verbose_t;

extern verbose_t Verbose;

void write_log(verbose_t, const char *s, size_t l);
extern void set_log(const char *);
void dbug(const char *, ...);		/* stderr */
void info(const char *, ...);		/* stdout */
void status(const char *, ...);		/* terminal */
void warn(const char *, ...);		/* stderr */
extern void error(const char *, ...);	/* stderr */

#endif
