/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={Connection.class, OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
@ProxyLocale
public abstract class NonTxnReplayableConnection
extends NonTxnReplayableBase
implements Replayable,
ReplayableConnection {
    private static final String CONN_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableConnection";
    private static Logger CONN_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Pre
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={}), @Signature(name="rollback", args={Savepoint.class}), @Signature(name="setSavepoint", args={}), @Signature(name="setSavepoint", args={String.class}), @Signature(name="releaseSavepoint", args={Savepoint.class}), @Signature(name="oracleRollback", args={OracleSavepoint.class}), @Signature(name="oracleSetSavepoint", args={}), @Signature(name="oracleSetSavepoint", args={String.class}), @Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class})})
    protected void preForTxnControl(Method var1_1, Object var2_2, Object ... var3_3) {
        var4_4 = this.failoverMngr.getReplayLifecycle();
        if (var4_4 != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        var5_5 = var1_1 == null ? "NULL METHOD" : var1_1.getName();
        NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, entering preForTxnControl({1})", new Object[]{this, var5_5});
        if (this.failoverMngr != null) {
            var6_6 = false;
            try {
                var7_7 = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
                var8_9 = var7_7.getTransactionState();
                NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, method {1}, transaction state: {2}", new Object[]{this, var5_5, var8_9});
                if (!var8_9.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) || var8_9.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) ** GOTO lbl26
                var6_6 = true;
            }
            catch (SQLException var7_8) {
                NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.WARNING, "On connection {0}, could not get transaction state: {1}", new Object[]{this, var7_8});
                var6_6 = true;
            }
            finally {
                if (var6_6) {
                    this.failoverMngr.disableReplayInternal(var1_1, 371, "Replay disabled because of active transaction", null);
                } else {
                    super.preForAll(var1_1, var2_2, var3_3);
                }
            }
        } else {
            NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.SEVERE, "On connection {0}, failover manager not set", this);
        }
lbl26:
        // 4 sources

        NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, exiting preForTxnControl()", this);
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, preForClosure({1})", new Object[]{this, method.getName()});
        this.isClosedAndNoReplay = true;
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, preForCancel({1})", new Object[]{this, method.getName()});
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, postForClosure({1})", new Object[]{this, method.getName()});
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, postForCancel({1})", new Object[]{this, method.getName()});
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering setReplayInitiationTimeout({1})", new Object[]{this, n2});
        this.failoverMngr.setReplayInitiationTimeout(n2);
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting setReplayInitiationTimeout({1})", new Object[]{this, n2});
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource) throws SQLException {
        FailoverManagerImpl failoverManagerImpl = (FailoverManagerImpl)FailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(failoverManagerImpl);
    }

    @Override
    public void beginRequest() throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering beginRequest()", this);
        this.failoverMngr.beginRequest();
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting beginRequest()", this);
    }

    @Override
    public void endRequest() throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering endRequest()", this);
        this.failoverMngr.endRequest();
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting endRequest()", this);
    }

    @Override
    public void disableReplay() throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering disableReplay()", this);
        this.failoverMngr.disableReplay();
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting disableReplay()", this);
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public ARRAY createARRAY(String string, Object objectArray) throws SQLException {
        Object[] objectArray2;
        Object object;
        Object object2;
        if (objectArray != null && objectArray instanceof Object[]) {
            object2 = objectArray;
            if (((Object[])object2).length > 0) {
                object = new Object[((Object[])object2).length];
                int n2 = 0;
                for (Object object3 : object2) {
                    object[n2++] = object3 instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object3).getDelegate() : object3;
                }
                objectArray2 = object;
            } else {
                objectArray2 = objectArray;
            }
        } else {
            objectArray2 = objectArray;
        }
        object2 = null;
        try {
            object2 = oracle.jdbc.internal.OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        this.preForAll((Method)object2, this, string, objectArray2);
        try {
            object = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
            ARRAY aRRAY = object.createARRAY(string, objectArray2);
            return (ARRAY)this.postForAll((Method)object2, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll((Method)object2, this.onErrorForAll((Method)object2, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        Method method = null;
        try {
            method = Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        Method method = null;
        try {
            method = Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Blob createBlob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Clob createClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract NClob createNClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract SQLXML createSQLXML() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, String[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)this.getDelegate();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public abstract Connection _getPC();

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection unwrap() {
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).unwrap();
    }

    static {
        if (CONN_REPLAY_LOGGER == null) {
            CONN_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(CONN_FEATURE_LOGGER_NAME);
        }
    }
}

