/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DFSReadWriteTest$ {
    public static final DFSReadWriteTest$ MODULE$;
    private File localFilePath;
    private String dfsDirPath;
    private final int NPARAMS;

    static {
        new DFSReadWriteTest$();
    }

    private File localFilePath() {
        return this.localFilePath;
    }

    private void localFilePath_$eq(File x$1) {
        this.localFilePath = x$1;
    }

    private String dfsDirPath() {
        return this.dfsDirPath;
    }

    private void dfsDirPath_$eq(String x$1) {
        this.dfsDirPath = x$1;
    }

    private int NPARAMS() {
        return this.NPARAMS;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> readFile(String filename) {
        void var3_3;
        Iterator lineIter = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec()).getLines();
        List lineList = lineIter.toList();
        return var3_3;
    }

    private void printUsage() {
        String usage = "DFS Read-Write Test\n\nUsage: localFile dfsDir\n\nlocalFile - (string) local file to use in test\ndfsDir - (string) DFS directory for read/write tests\n";
        Predef$.MODULE$.println((Object)usage);
    }

    private void parseArgs(String[] args) {
        if (args.length != this.NPARAMS()) {
            this.printUsage();
            System.exit(1);
        }
        int i = 0;
        this.localFilePath_$eq(new File(args[i]));
        if (!this.localFilePath().exists()) {
            System.err.println(new StringBuilder().append((Object)"Given path (").append((Object)args[i]).append((Object)") does not exist.\n").toString());
            this.printUsage();
            System.exit(1);
        }
        if (!this.localFilePath().isFile()) {
            System.err.println(new StringBuilder().append((Object)"Given path (").append((Object)args[i]).append((Object)") is not a file.\n").toString());
            this.printUsage();
            System.exit(1);
        }
        this.dfsDirPath_$eq(args[++i]);
    }

    public int runLocalWordCount(List<String> fileContents) {
        return BoxesRunTime.unboxToInt((Object)((TraversableLike)((TraversableLike)((TraversableLike)fileContents.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split(" "));
            }
        }, List$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2.split("\t"));
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).size() > 0;
            }
        })).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String w) {
                return w;
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(List<String> x$4) {
                return x$4.size();
            }
        }).values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void main(String[] args) {
        this.parseArgs(args);
        Predef$.MODULE$.println((Object)"Performing local word count");
        List<String> fileContents = this.readFile(this.localFilePath().toString());
        int localWordCount = this.runLocalWordCount(fileContents);
        Predef$.MODULE$.println((Object)"Creating SparkConf");
        SparkConf conf = new SparkConf().setAppName("DFS Read Write Test");
        Predef$.MODULE$.println((Object)"Creating SparkContext");
        SparkContext sc = new SparkContext(conf);
        Predef$.MODULE$.println((Object)"Writing local file to DFS");
        String dfsFilename = new StringBuilder().append((Object)this.dfsDirPath()).append((Object)"/dfs_read_write_test").toString();
        RDD fileRDD = sc.parallelize(fileContents, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        fileRDD.saveAsTextFile(dfsFilename);
        Predef$.MODULE$.println((Object)"Reading file from DFS and running Word Count");
        RDD readFileRDD = sc.textFile(dfsFilename, sc.textFile$default$2());
        long dfsWordCount = BoxesRunTime.unboxToLong((Object)SparkContext$.MODULE$.rddToPairRDDFunctions(readFileRDD.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$5) {
                return Predef$.MODULE$.refArrayOps((Object[])x$5.split(" "));
            }
        }, ClassTag$.MODULE$.apply(String.class)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$6) {
                return Predef$.MODULE$.refArrayOps((Object[])x$6.split("\t"));
            }
        }, ClassTag$.MODULE$.apply(String.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).size() > 0;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String w) {
                return new Tuple2((Object)w, (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).countByKey().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        sc.stop();
        if ((long)localWordCount == dfsWordCount) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Success! Local Word Count (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)localWordCount)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and DFS Word Count (", ") agree."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)dfsWordCount)}))).toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure! Local Word Count (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)localWordCount)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and DFS Word Count (", ") disagree."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)dfsWordCount)}))).toString());
        }
    }

    private DFSReadWriteTest$() {
        MODULE$ = this;
        this.localFilePath = new File(".");
        this.dfsDirPath = "";
        this.NPARAMS = 2;
    }
}

