# Copyright 2021 Red Hat, Inc. Jake Hunsaker <jhunsake@redhat.com>

# This file is part of the sos project: https://github.com/sosreport/sos
#
# This copyrighted material is made available to anyone wishing to use,
# modify, copy, or redistribute it subject to the terms and conditions of
# version 2 of the GNU General Public License.
#
# See the LICENSE file in the source distribution for further information.


from sos.cleaner.archives import SoSObfuscationArchive

import tarfile


class InsightsArchive(SoSObfuscationArchive):
    """This class represents archives generated by the insights-client utility
    for RHEL systems.
    """

    type_name = 'insights'
    description = 'insights-client archive'

    @classmethod
    def check_is_type(cls, arc_path):
        try:
            return tarfile.is_tarfile(arc_path) and 'insights-' in arc_path
        except Exception:
            return False

    def get_archive_root(self):
        top = self.archive_path.split('/')[-1].split('.tar')[0]
        if self.tarobj.firstmember.name == '.':
            top = './' + top
        return top
