--TEST--
GH-20582 (Heap Buffer Overflow in iptcembed)
--CREDITS--
Nikita Sveshnikov (Positive Technologies)
ndossche
--SKIPIF--
<?php
if (!function_exists("posix_mkfifo")) {
    die("skip no posix_mkfifo()");
}
?>
--FILE--
<?php

$pipe = __DIR__.'/gh20582.pipe.jpg';

// Create named pipe (FIFO)
if (!file_exists($pipe)) {
    if (!posix_mkfifo($pipe, 0666)) {
        die("Failed to create FIFO\n");
    }
}

$descriptorspec = array(
   0 => STDIN,
   1 => STDOUT,
   2 => STDOUT,
);
$pipes = [];
$proc = proc_open([PHP_BINARY, '-n', '-r', "var_dump(iptcembed('A', '$pipe'));"], $descriptorspec, $pipes);

// Blocks until a reader opens it
$fp = fopen($pipe, 'wb') or die("Failed to open FIFO");

// Write header
$data  = "\xFF\xD8";                    // SOI marker
$data .= "\xFF\xE0\x00\x10";            // APP0 marker (JFIF)
$data .= "JFIF" . str_repeat("\x00", 9);
$data .= "\xFF\xDA\x00\x08";            // SOS marker
$data .= str_repeat("\x00", 6);
fwrite($fp, $data);

// Write garbage
fwrite($fp, str_repeat("A", 5120));

fclose($fp);

?>
--CLEAN--
<?php
@unlink(__DIR__.'/gh20582.pipe.jpg');
?>
--EXPECTF--
string(1055) "%0JFIF%0%0%0%0%0%0%0%0%0%0Photoshop 3.0%08BIM%0%0%0%0%0A%0%0%0%0%0%0%0%0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
