/**
 * Astronomical calculations. Currently, only the Earth position is calculated.
 * The ACM program needs to know the position of the Sun to determinate the
 * general brightness of the scene and to provide a further reference to
 * pilots flying VFR.
 * The returned values have been verified to be accurate within 0.1 DEG of
 * latitude and 0.2 DEG of longitude (the apparent diameter of the Sun being
 * only 0.5 DEG).
 * 
 * @file
 * @author Umberto Salsi <salsi@icosaedro.it>
 * @version $Date: 2017/10/25 01:59:03 $
 */

#ifndef ASTRO_H
#define ASTRO_H

#include "../V/Vlibmath.h"
#include "../util/zulu.h"

#ifdef astro_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Initializes the module, and set the current position and rotation of the Earth
 * in the Universe.
 * @param simulation_time Simulation time (s).
 * @param departure The state of the Earth is set at the specified date and time.
 */
EXTERN void astro_init(double simulation_time, zulu_Date *departure);

/**
 * Returns the current position of the Sun. Calculated values are cached and
 * a new position is calculated only from time to time.
 * @param simulation_time Simulation time (s).
 * @param sun Here returns the current position of the Sun in the Earth geodetic
 * reference (m).
 */
EXTERN void astro_getSun(double simulation_time, VPoint *sun);

#undef EXTERN
#endif
