// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __loc_manager_h__
#define __loc_manager_h__

#include "Puma/Location.h"
#include "Puma/Token.h"

namespace Puma {


class LocManager {
  Location now;

public:
  LocManager () { now.setup ("<<undefined>>", 0); }
  LocManager (Filename f, int l = 1) { now.setup (f, l); }
  void setup (Filename f, int l) { now = Location (f, l); }
  void new_line (int l = 1) 
   { now = Location (now.filename (), now.line () + l); }
  void line (int l) { now = Location (now.filename (), l); }
  void file (Filename f) { now = Location (f, 1); }
  Location location () { return now; }
  void update (Token *t);
};


} // namespace Puma

#endif /* __loc_manager_h__ */
