/***** Autogenerated from runmath.in; changes will be overwritten *****/

#line 1 "runtimebase.in"
/*****
 * runtimebase.in
 * Andy Hammerlindl  2009/07/28
 *
 * Common declarations needed for all code-generating .in files.
 *
 *****/


#line 1 "runmath.in"
/*****
 * runmath.in
 *
 * Runtime functions for math operations.
 *
 *****/

#line 1 "runtimebase.in"
#include "stack.h"
#include "types.h"
#include "builtin.h"
#include "entry.h"
#include "errormsg.h"
#include "array.h"
#include "triple.h"
#include "callable.h"
#include "opsymbols.h"

using vm::stack;
using vm::error;
using vm::array;
using vm::read;
using vm::callable;
using types::formal;
using types::function;
using camp::triple;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

typedef double real;

void unused(void *);

namespace run {
array *copyArray(array *a);
array *copyArray2(array *a);
array *copyArray3(array *a);

double *copyTripleArray2Components(array *a, size_t &N,
                                   GCPlacement placement=NoGC);
triple *copyTripleArray2C(array *a, size_t &N,
                          GCPlacement placement=NoGC);
}

function *realRealFunction();

#define CURRENTPEN processData().currentpen

#line 12 "runmath.in"
#include <inttypes.h>

#include "mathop.h"
#include "path.h"

#ifdef __CYGWIN__
extern "C" double yn(int, double);
extern "C" double jn(int, double);
#endif

using namespace camp;

typedef array realarray;
typedef array pairarray;

using types::realArray;
using types::pairArray;

using run::integeroverflow;
using vm::frame;

const char *invalidargument="invalid argument";

extern uint32_t CLZ(uint32_t a);

// Return the factorial of a non-negative integer using a lookup table.
Int factorial(Int n)
{
  static Int *table;
  static Int size=0;
  if(size == 0) {
    Int f=1;
    size=2;
    while(f <= Int_MAX/size)
      f *= (size++);
    table=new Int[size];
    table[0]=f=1;
    for(Int i=1; i < size; ++i) {
      f *= i;
      table[i]=f;
    }
  }
  if(n >= size) integeroverflow(0);
  return table[n];
}

static inline Int Round(double x) 
{
  return Int(x+((x >= 0) ? 0.5 : -0.5));
}

inline Int sgn(double x) 
{
  return (x > 0.0 ? 1 : (x < 0.0 ? -1 : 0));
}

static bool initializeRandom=true;

void Srand(Int seed)
{ 
  initializeRandom=false;
  const int n=256;
  static char state[n];
  initstate(intcast(seed),state,n);
}  

// Autogenerated routines:



#ifndef NOSYM
#include "runmath.symbols.h"

#endif
namespace run {
#line 81 "runmath.in"
// real ^(real x, Int y);
void gen_runmath0(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  real x=vm::pop<real>(Stack);
#line 82 "runmath.in"
  {Stack->push<real>(pow(x,y)); return;}
}

#line 86 "runmath.in"
// pair ^(pair z, Int y);
void gen_runmath1(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 87 "runmath.in"
  {Stack->push<pair>(pow(z,y)); return;}
}

#line 91 "runmath.in"
// Int quotient(Int x, Int y);
void gen_runmath2(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  Int x=vm::pop<Int>(Stack);
#line 92 "runmath.in" 
  {Stack->push<Int>(quotient<Int>()(x,y)); return;}
}

#line 96 "runmath.in"
// Int abs(Int x);
void gen_runmath3(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
#line 97 "runmath.in" 
  {Stack->push<Int>(Abs(x)); return;}
}

#line 101 "runmath.in"
// Int sgn(real x);
void gen_runmath4(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 102 "runmath.in" 
  {Stack->push<Int>(sgn(x)); return;}
}

#line 106 "runmath.in"
// Int rand();
void gen_runmath5(stack *Stack)
{
#line 107 "runmath.in" 
  if(initializeRandom)
    Srand(1);
  {Stack->push<Int>(random()); return;}
}

#line 113 "runmath.in"
// void srand(Int seed);
void gen_runmath6(stack *Stack)
{
  Int seed=vm::pop<Int>(Stack);
#line 114 "runmath.in" 
  Srand(seed);
}

// a random number uniformly distributed in the interval [0,1]
#line 119 "runmath.in"
// real unitrand();
void gen_runmath7(stack *Stack)
{
#line 120 "runmath.in"                         
  {Stack->push<real>(((real) random())/RANDOM_MAX); return;}
}

#line 124 "runmath.in"
// Int ceil(real x);
void gen_runmath8(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 125 "runmath.in" 
  {Stack->push<Int>(Intcast(ceil(x))); return;}
}

#line 129 "runmath.in"
// Int floor(real x);
void gen_runmath9(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 130 "runmath.in" 
  {Stack->push<Int>(Intcast(floor(x))); return;}
}

#line 134 "runmath.in"
// Int round(real x);
void gen_runmath10(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 135 "runmath.in" 
  if(validInt(x)) {Stack->push<Int>(Round(x)); return;}
  integeroverflow(0);
}

#line 140 "runmath.in"
// Int Ceil(real x);
void gen_runmath11(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 141 "runmath.in" 
  {Stack->push<Int>(Ceil(x)); return;}
}

#line 145 "runmath.in"
// Int Floor(real x);
void gen_runmath12(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 146 "runmath.in" 
  {Stack->push<Int>(Floor(x)); return;}
}

#line 150 "runmath.in"
// Int Round(real x);
void gen_runmath13(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 151 "runmath.in" 
  {Stack->push<Int>(Round(Intcap(x))); return;}
}

#line 155 "runmath.in"
// real fmod(real x, real y);
void gen_runmath14(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 156 "runmath.in"
  if (y == 0.0) dividebyzero();
  {Stack->push<real>(fmod(x,y)); return;}
}

#line 161 "runmath.in"
// real atan2(real y, real x);
void gen_runmath15(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
#line 162 "runmath.in" 
  {Stack->push<real>(atan2(y,x)); return;}
}

#line 166 "runmath.in"
// real hypot(real x, real y);
void gen_runmath16(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 167 "runmath.in" 
  {Stack->push<real>(hypot(x,y)); return;}
}

#line 171 "runmath.in"
// real remainder(real x, real y);
void gen_runmath17(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 172 "runmath.in" 
  {Stack->push<real>(remainder(x,y)); return;}
}

#line 176 "runmath.in"
// real Jn(Int n, real x);
void gen_runmath18(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 177 "runmath.in"
  {Stack->push<real>(jn(n,x)); return;}
}

#line 181 "runmath.in"
// real Yn(Int n, real x);
void gen_runmath19(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 182 "runmath.in"
  {Stack->push<real>(yn(n,x)); return;}
}

#line 186 "runmath.in"
// real erf(real x);
void gen_runmath20(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 187 "runmath.in"
  {Stack->push<real>(erf(x)); return;}
}

#line 191 "runmath.in"
// real erfc(real x);
void gen_runmath21(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 192 "runmath.in"
  {Stack->push<real>(erfc(x)); return;}
}

#line 196 "runmath.in"
// Int factorial(Int n);
void gen_runmath22(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 197 "runmath.in"
  if(n < 0) error(invalidargument);
  {Stack->push<Int>(factorial(n)); return;}
}

#line 201 "runmath.in"
// Int choose(Int n, Int k);
void gen_runmath23(stack *Stack)
{
  Int k=vm::pop<Int>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 202 "runmath.in"
  if(n < 0 || k < 0 || k > n) error(invalidargument);
  Int f=1;
  Int r=n-k;
  for(Int i=n; i > r; --i) {
    if(f > Int_MAX/i) integeroverflow(0);
    f=(f*i)/(n-i+1);
  }
  {Stack->push<Int>(f); return;}
}

#line 212 "runmath.in"
// real gamma(real x);
void gen_runmath24(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 213 "runmath.in"
#ifdef HAVE_TGAMMA
  {Stack->push<real>(tgamma(x)); return;}
#else
  real lg = lgamma(x);
  {Stack->push<real>(signgam*exp(lg)); return;}
#endif
}

#line 222 "runmath.in"
// realarray* quadraticroots(real a, real b, real c);
void gen_runmath25(stack *Stack)
{
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 223 "runmath.in"
  quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots == 2) (*roots)[1]=q.t2;
  {Stack->push<realarray*>(roots); return;}
}

#line 231 "runmath.in"
// pairarray* quadraticroots(explicit pair a, explicit pair b, explicit pair c);
void gen_runmath26(stack *Stack)
{
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 232 "runmath.in"
  Quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.z1;
  if(q.roots == 2) (*roots)[1]=q.z2;
  {Stack->push<pairarray*>(roots); return;}
}

#line 240 "runmath.in"
// realarray* cubicroots(real a, real b, real c, real d);
void gen_runmath27(stack *Stack)
{
  real d=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 241 "runmath.in"
  cubicroots q(a,b,c,d);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots >= 2) (*roots)[1]=q.t2;
  if(q.roots == 3) (*roots)[2]=q.t3;
  {Stack->push<realarray*>(roots); return;}
}


// Logical operations
#line 252 "runmath.in"
// bool !(bool b);
void gen_runmath28(stack *Stack)
{
  bool b=vm::pop<bool>(Stack);
#line 253 "runmath.in"
  {Stack->push<bool>(!b); return;}
}

#line 258 "runmath.in"
void boolMemEq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 259 "runmath.in"
  {Stack->push<bool>(a == b); return;}
}

#line 263 "runmath.in"
void boolMemNeq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 264 "runmath.in"
  {Stack->push<bool>(a != b); return;}
}

#line 268 "runmath.in"
void boolFuncEq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 269 "runmath.in"
  {Stack->push<bool>(a->compare(b)); return;}
}

#line 273 "runmath.in"
void boolFuncNeq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 274 "runmath.in"
  {Stack->push<bool>(!(a->compare(b))); return;}
}


// Bit operations
#line 280 "runmath.in"
// Int AND(Int a, Int b);
void gen_runmath33(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 281 "runmath.in"
  {Stack->push<Int>(a & b); return;}
}

#line 286 "runmath.in"
// Int OR(Int a, Int b);
void gen_runmath34(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 287 "runmath.in"
  {Stack->push<Int>(a | b); return;}
}

#line 291 "runmath.in"
// Int XOR(Int a, Int b);
void gen_runmath35(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 292 "runmath.in"
  {Stack->push<Int>(a ^ b); return;}
}

#line 296 "runmath.in"
// Int NOT(Int a);
void gen_runmath36(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 297 "runmath.in"
  {Stack->push<Int>(~a); return;}
}

#line 301 "runmath.in"
// Int CLZ(Int a);
void gen_runmath37(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 302 "runmath.in"
  if((uint32_t) a > 0xFFFFFFFF) {Stack->push<Int>(-1); return;}
  {Stack->push<Int>(CLZ((uint32_t) a)); return;}
}

#line 307 "runmath.in"
// Int CTZ(Int a);
void gen_runmath38(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 308 "runmath.in"
  if((uint32_t) a > 0xFFFFFFFF) {Stack->push<Int>(-1); return;}
#if __GNUC__
  {Stack->push<Int>(__builtin_ctz(a)); return;}
#else
  // find the number of trailing zeros in a 32-bit number
  static const int MultiplyDeBruijnBitPosition[32] = {
    0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 
    31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9
  };
  {Stack->push<Int>(MultiplyDeBruijnBitPosition[((uint32_t)((a & -a) * 0x077CB531U))
                                     >> 27]); return;}
#endif
}

} // namespace run

namespace trans {

void gen_runmath_venv(venv &ve)
{
#line 81 "runmath.in"
  addFunc(ve, run::gen_runmath0, primReal(), SYM_CARET, formal(primReal(), SYM(x), false, false), formal(primInt(), SYM(y), false, false));
#line 86 "runmath.in"
  addFunc(ve, run::gen_runmath1, primPair(), SYM_CARET, formal(primPair(), SYM(z), false, false), formal(primInt(), SYM(y), false, false));
#line 91 "runmath.in"
  addFunc(ve, run::gen_runmath2, primInt(), SYM(quotient), formal(primInt(), SYM(x), false, false), formal(primInt(), SYM(y), false, false));
#line 96 "runmath.in"
  addFunc(ve, run::gen_runmath3, primInt(), SYM(abs), formal(primInt(), SYM(x), false, false));
#line 101 "runmath.in"
  addFunc(ve, run::gen_runmath4, primInt(), SYM(sgn), formal(primReal(), SYM(x), false, false));
#line 106 "runmath.in"
  addFunc(ve, run::gen_runmath5, primInt(), SYM(rand));
#line 113 "runmath.in"
  addFunc(ve, run::gen_runmath6, primVoid(), SYM(srand), formal(primInt(), SYM(seed), false, false));
#line 118 "runmath.in"
  addFunc(ve, run::gen_runmath7, primReal(), SYM(unitrand));
#line 124 "runmath.in"
  addFunc(ve, run::gen_runmath8, primInt(), SYM(ceil), formal(primReal(), SYM(x), false, false));
#line 129 "runmath.in"
  addFunc(ve, run::gen_runmath9, primInt(), SYM(floor), formal(primReal(), SYM(x), false, false));
#line 134 "runmath.in"
  addFunc(ve, run::gen_runmath10, primInt(), SYM(round), formal(primReal(), SYM(x), false, false));
#line 140 "runmath.in"
  addFunc(ve, run::gen_runmath11, primInt(), SYM(Ceil), formal(primReal(), SYM(x), false, false));
#line 145 "runmath.in"
  addFunc(ve, run::gen_runmath12, primInt(), SYM(Floor), formal(primReal(), SYM(x), false, false));
#line 150 "runmath.in"
  addFunc(ve, run::gen_runmath13, primInt(), SYM(Round), formal(primReal(), SYM(x), false, false));
#line 155 "runmath.in"
  addFunc(ve, run::gen_runmath14, primReal(), SYM(fmod), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 161 "runmath.in"
  addFunc(ve, run::gen_runmath15, primReal(), SYM(atan2), formal(primReal(), SYM(y), false, false), formal(primReal(), SYM(x), false, false));
#line 166 "runmath.in"
  addFunc(ve, run::gen_runmath16, primReal(), SYM(hypot), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 171 "runmath.in"
  addFunc(ve, run::gen_runmath17, primReal(), SYM(remainder), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 176 "runmath.in"
  addFunc(ve, run::gen_runmath18, primReal(), SYM(Jn), formal(primInt(), SYM(n), false, false), formal(primReal(), SYM(x), false, false));
#line 181 "runmath.in"
  addFunc(ve, run::gen_runmath19, primReal(), SYM(Yn), formal(primInt(), SYM(n), false, false), formal(primReal(), SYM(x), false, false));
#line 186 "runmath.in"
  addFunc(ve, run::gen_runmath20, primReal(), SYM(erf), formal(primReal(), SYM(x), false, false));
#line 191 "runmath.in"
  addFunc(ve, run::gen_runmath21, primReal(), SYM(erfc), formal(primReal(), SYM(x), false, false));
#line 196 "runmath.in"
  addFunc(ve, run::gen_runmath22, primInt(), SYM(factorial), formal(primInt(), SYM(n), false, false));
#line 201 "runmath.in"
  addFunc(ve, run::gen_runmath23, primInt(), SYM(choose), formal(primInt(), SYM(n), false, false), formal(primInt(), SYM(k), false, false));
#line 212 "runmath.in"
  addFunc(ve, run::gen_runmath24, primReal(), SYM(gamma), formal(primReal(), SYM(x), false, false));
#line 222 "runmath.in"
  addFunc(ve, run::gen_runmath25, realArray(), SYM(quadraticroots), formal(primReal(), SYM(a), false, false), formal(primReal(), SYM(b), false, false), formal(primReal(), SYM(c), false, false));
#line 231 "runmath.in"
  addFunc(ve, run::gen_runmath26, pairArray(), SYM(quadraticroots), formal(primPair(), SYM(a), false, true), formal(primPair(), SYM(b), false, true), formal(primPair(), SYM(c), false, true));
#line 240 "runmath.in"
  addFunc(ve, run::gen_runmath27, realArray(), SYM(cubicroots), formal(primReal(), SYM(a), false, false), formal(primReal(), SYM(b), false, false), formal(primReal(), SYM(c), false, false), formal(primReal(), SYM(d), false, false));
#line 250 "runmath.in"
  addFunc(ve, run::gen_runmath28, primBoolean(), SYM_LOGNOT, formal(primBoolean(), SYM(b), false, false));
#line 258 "runmath.in"
  REGISTER_BLTIN(run::boolMemEq,"boolMemEq");
#line 263 "runmath.in"
  REGISTER_BLTIN(run::boolMemNeq,"boolMemNeq");
#line 268 "runmath.in"
  REGISTER_BLTIN(run::boolFuncEq,"boolFuncEq");
#line 273 "runmath.in"
  REGISTER_BLTIN(run::boolFuncNeq,"boolFuncNeq");
#line 278 "runmath.in"
  addFunc(ve, run::gen_runmath33, primInt(), SYM(AND), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(b), false, false));
#line 286 "runmath.in"
  addFunc(ve, run::gen_runmath34, primInt(), SYM(OR), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(b), false, false));
#line 291 "runmath.in"
  addFunc(ve, run::gen_runmath35, primInt(), SYM(XOR), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(b), false, false));
#line 296 "runmath.in"
  addFunc(ve, run::gen_runmath36, primInt(), SYM(NOT), formal(primInt(), SYM(a), false, false));
#line 301 "runmath.in"
  addFunc(ve, run::gen_runmath37, primInt(), SYM(CLZ), formal(primInt(), SYM(a), false, false));
#line 307 "runmath.in"
  addFunc(ve, run::gen_runmath38, primInt(), SYM(CTZ), formal(primInt(), SYM(a), false, false));
}

} // namespace trans
