<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : autoPhysicalProperties.xsl
    Created on : 02 March 2004, 15:48
    Author     : promayon
    Description:
        Generate the custom properties C++ classes from the custom property XML document.

/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:cp='http://www-timc.imag.fr/customPhysicalProperties'
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:common="http://exslt.org/common">
    
    <!-- get the current date -->            
    <xsl:variable name="now" select="date:date-time()"/>
    
    <!-- used to transform from upper to lower case and lower to upper case -->
    <xsl:variable name="upperCase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
    <xsl:variable name="lowerCase" select="'abcdefghijklmnopqrstuvwxyz'"/>
    
    <xsl:template match="cp:physicalProperties">
        <!-- generate the 6 C++ files (1 header and 1 implementation file per type) -->
        <xsl:apply-templates select="cp:atomProperties"/>
        <xsl:apply-templates select="cp:cellProperties"/>
        <xsl:apply-templates select="cp:structuralComponentProperties"/>
    
        <!-- genetrate the parameter reading methods -->    
        <xsl:call-template name="xmlHandler">
                <xsl:with-param name="inherits"><xsl:value-of select="cp:cellProperties/@inherits"/></xsl:with-param>
        </xsl:call-template>                    
    </xsl:template>
    
    
    <!-- generate custom properties classes for atom -->
    <xsl:template match="cp:atomProperties">
        <xsl:document href="src/AtomProperties.h" method="text">        
            <xsl:call-template name="header">
                <xsl:with-param name="class">Atom</xsl:with-param>
                <xsl:with-param name="baseClass">BasicAtomProperties</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="atomConstructors"/>
            <xsl:call-template name="propertyDeclaration">
                <xsl:with-param name="class">Atom</xsl:with-param>
            </xsl:call-template>
        </xsl:document>
        <xsl:document href="src/AtomProperties.cpp" method="text">        
            <xsl:call-template name="implementation">
                <xsl:with-param name="class">Atom</xsl:with-param>                
            </xsl:call-template>
        </xsl:document>
    </xsl:template>
    
    <xsl:template match="cp:cellProperties">
        <xsl:document href="src/CellProperties.h" method="text">        
            <xsl:call-template name="header">
                <xsl:with-param name="class">Cell</xsl:with-param>                
                <xsl:with-param name="baseClass">BasicCellProperties</xsl:with-param>
                <xsl:with-param name="inherits"><xsl:value-of select="@inherits"/></xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="cellConstructors">
                <xsl:with-param name="inherits"><xsl:value-of select="@inherits"/></xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="propertyDeclaration">
                <xsl:with-param name="class">Cell</xsl:with-param>
            </xsl:call-template>
        </xsl:document>
        <xsl:document href="src/CellProperties.cpp" method="text">        
            <xsl:call-template name="implementation">
                <xsl:with-param name="class">Cell</xsl:with-param>                
                <xsl:with-param name="inherits"><xsl:value-of select="@inherits"/></xsl:with-param>
            </xsl:call-template>
        </xsl:document>
    </xsl:template>

    <xsl:template match="cp:structuralComponentProperties">
        <xsl:document href="src/StructuralComponentProperties.h" method="text">        
            <xsl:call-template name="header">
                <xsl:with-param name="class">StructuralComponent</xsl:with-param>                
                <xsl:with-param name="baseClass">BasicSCProperties</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="scConstructors"/>
            <xsl:call-template name="propertyDeclaration">
                <xsl:with-param name="class">StructuralComponent</xsl:with-param>
            </xsl:call-template>
        </xsl:document>
        <xsl:document href="src/StructuralComponentProperties.cpp" method="text">        
            <xsl:call-template name="implementation">
                <xsl:with-param name="class">StructuralComponent</xsl:with-param>                
            </xsl:call-template>
        </xsl:document>
    </xsl:template>

    
    
    
    
    
    <xsl:template name="currentDate">
        <xsl:text>    auto-generated       : </xsl:text>
        <xsl:value-of select="concat(date:day-name($now), ' ', date:day-in-month($now), ' ',
                                    date:month-name($now), ' ',
                                    date:year($now))"/>
        <xsl:text> at </xsl:text>
        <xsl:value-of select="concat(date:hour-in-day($now), ':',
                                    date:minute-in-hour($now), ':',
                                    date:second-in-minute($now))"/>
    </xsl:template>

    
    
    
    
    
    
    <xsl:template name="header">
        <xsl:param name="class"/>   
        <xsl:param name="baseClass"/>
        <xsl:param name="inherits"/>
        
        <xsl:variable name="upperName">
            <xsl:value-of select="translate($class, $lowerCase, $upperCase)"/>
        </xsl:variable>
                    
        <xsl:text>/***************************************************************************
                          </xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>Properties.h  -  custom </xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text> properties
                             -------------------
</xsl:text>
            <xsl:call-template name="currentDate"/>
            <xsl:text>
    copyright            : (C) 2001-</xsl:text>
        <xsl:value-of select="date:year($now)"/>
        <xsl:text> TIMC (E. Promayon, M. Chabanas)
    email                : Emmanuel.Promayon@imag.fr
    Date                 : $Date: 2008-02-20 18:08:02 +0100 (Wed, 20 Feb 2008) $
    Version              : $Revision: 2267 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef </xsl:text>
        <xsl:value-of select="$upperName"/>
        <xsl:text>PROPERTIES_H
#define </xsl:text>
        <xsl:value-of select="$upperName"/>
        <xsl:text>PROPERTIES_H

#include "</xsl:text>
        <xsl:value-of select="$baseClass"/>
        <xsl:text>.h"
</xsl:text>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>#include "StructuralComponentProperties.h"
            </xsl:text>            
        </xsl:if>            
    <xsl:text>
/**
  * This is an automatically generated class for custom </xsl:text>
    <xsl:value-of select="$class"/>
    <xsl:text> properties.
  * It was generated by the &lt;tt&gt;customPhysicalProperties&lt;/tt&gt; stylesheet from 
  * the following xml document:
  &lt;pre&gt;
  </xsl:text>
  <!--   <xsl:copy-of select="common:node-set(/*)"/>   //-->
  <xsl:copy-of select="."/>
  <xsl:text>
  &lt;/pre&gt;
  * This class inherits </xsl:text>
  <xsl:value-of select="$baseClass"/>
  <xsl:text>.
  * Here is all the specific attributes of </xsl:text>
  <xsl:value-of select="$class"/>
  <xsl:text> properties (custom physical properties)
  *
  * @author Emmanuel Promayon
  * $Revision $
  */
class </xsl:text>
    <xsl:value-of select="$class"/>
    <xsl:text>Properties : public </xsl:text>
    <xsl:value-of select="$baseClass"/>
    <xsl:if test="$inherits='true' or $inherits='1'">
        <xsl:text>, public StructuralComponentProperties
        </xsl:text>            
    </xsl:if>              
  <xsl:text> {
public:
    /** Constructors (do not change) */</xsl:text>
    </xsl:template>

    

    <xsl:template name="atomConstructors">
        <xsl:text>
    AtomProperties(PhysicalModel *p) :  BasicAtomProperties(p) { init(); };
    AtomProperties(PhysicalModel *p, xmlNodePtr node) :  BasicAtomProperties(p, node) { init(); };
    AtomProperties(PhysicalModel *p, const unsigned int ind) : BasicAtomProperties(p, ind) { init(); };
    AtomProperties(PhysicalModel *p, const double pos[3]) : BasicAtomProperties(p, pos) { init(); };
    AtomProperties(PhysicalModel *p, const unsigned int ind, const double pos[3]) : BasicAtomProperties(p, ind, pos) { init(); };
    virtual ~AtomProperties();</xsl:text>
    </xsl:template>    
    

    <xsl:template name="cellConstructors">
        <xsl:param name="inherits"/>
        <xsl:text>
    CellProperties(PhysicalModel *p, const StructureProperties::GeometricType t) : BasicCellProperties(p, t)</xsl:text>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>, StructuralComponentProperties(p)</xsl:text>
        </xsl:if>
        <xsl:text> { init(); };
  	CellProperties(PhysicalModel *p, const StructureProperties::GeometricType t ,xmlNodePtr node) : BasicCellProperties(p, t, node)</xsl:text>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>, StructuralComponentProperties(p)</xsl:text>
        </xsl:if>
        <xsl:text> { init(); };
    CellProperties(PhysicalModel *p, const StructureProperties::GeometricType t, const unsigned int ind) : BasicCellProperties(p, t, ind)</xsl:text>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>, StructuralComponentProperties(p)</xsl:text>
        </xsl:if>
        <xsl:text>{ init(); };
    virtual ~CellProperties();</xsl:text>
    </xsl:template>    

    <xsl:template name="scConstructors">
        <xsl:text>
    StructuralComponentProperties(PhysicalModel *p) : BasicSCProperties(p)  { init(); };
    StructuralComponentProperties(PhysicalModel *p, xmlNodePtr node) : BasicSCProperties(p, node)  { init(); };
    StructuralComponentProperties(PhysicalModel *p, const std::string n) : BasicSCProperties(p, n) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const Color c) : BasicSCProperties(p,c) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const Color c, const std::string n) : BasicSCProperties(p,c,n) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double * rgb) : BasicSCProperties(p, rgb) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double * rgb, const std::string n) : BasicSCProperties(p, rgb,n) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double r, const double g, const double b) : BasicSCProperties(p, r,g,b) { init(); };
    StructuralComponentProperties(PhysicalModel *p, const double r, const double g, const double b, const std::string n) : BasicSCProperties(p,r,g,b,n
) { init(); };
    virtual ~StructuralComponentProperties();</xsl:text>
    </xsl:template>    

    
    
    
    
    <xsl:template name="propertyDeclaration">
        <xsl:param name="class"/> 

        <xsl:text>     
           
    /** Print the properties in xml */
    void xmlPrint(std::ostream &amp;);

    /** Set and get method for all the properties */
    </xsl:text>
    
        <!-- mutator and acessor methods -->
        <xsl:for-each select="cp:property">
            <!-- transform the property name first letter in uppercase -->
            <xsl:variable name="upperName">
                <xsl:value-of select="concat(translate(substring(@name,1,1), $lowerCase, $upperCase), substring(@name,2))"/>
            </xsl:variable>
        
            <!-- mutator -->
            <xsl:text>void set</xsl:text>
            <xsl:value-of select="$upperName"/>
            <xsl:text>(const </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text>);
    </xsl:text>
            
            <!-- accessor -->
            <xsl:value-of select="@type"/>
            <xsl:text> get</xsl:text>
            <xsl:value-of select="$upperName"/>
            <xsl:text>() const;
            
    </xsl:text>        
        </xsl:for-each>
        
        <!-- attributes declaration (private) -->
        <xsl:text>
protected:
                
    virtual void init();
    </xsl:text>
        
        <xsl:for-each select="cp:property">
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text>;
    </xsl:text>
        </xsl:for-each>
    
        <xsl:text>
};                

// inlines
</xsl:text>

        <!-- inline methods -->
        <xsl:for-each select="cp:property">
            <!-- transform the property name first letter in uppercase -->
            <xsl:variable name="upperName">
                <xsl:value-of select="concat(translate(substring(@name,1,1), $lowerCase, $upperCase), substring(@name,2))"/>
            </xsl:variable>
                        
            <!-- mutator -->            
            <xsl:text>inline void </xsl:text>
            <xsl:value-of select="$class"/>
            <xsl:text>Properties::set</xsl:text>                                
            <xsl:value-of select="$upperName"/>
            <xsl:text>(const </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> value) { </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> = value; }
</xsl:text>

            <!-- accessor -->
            <xsl:text>inline </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>            
            <xsl:value-of select="$class"/>
            <xsl:text>Properties::get</xsl:text>
            <xsl:value-of select="$upperName"/>
            <xsl:text>() const { return </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text>; }
</xsl:text>
        </xsl:for-each>        
            
        <xsl:text>
#endif

</xsl:text>
        
    </xsl:template>
    
    
    
    
    <xsl:template name="implementation">
        <xsl:param name="class"/>   
        <xsl:param name="inherits"/>

        <xsl:variable name="upperName">
            <xsl:value-of select="translate($class, $lowerCase, $upperCase)"/>
        </xsl:variable>
                    
        <xsl:text>/***************************************************************************
                  </xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>Properties.cpp  -  custom </xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text> properties
                             -------------------
</xsl:text>
            <xsl:call-template name="currentDate"/>
            <xsl:text>
    copyright            : (C) 2001-</xsl:text>
        <xsl:value-of select="date:year($now)"/>
        <xsl:text> TIMC (E. Promayon, M. Chabanas)
    email                : Emmanuel.Promayon@imag.fr
    Date                 : $Date: 2008-02-20 18:08:02 +0100 (Wed, 20 Feb 2008) $
    Version              : $Revision: 2267 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "PhysicalModelIO.h"
#include "</xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>Properties.h"

//--------------- Constructor -------------
void </xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>Properties::init() {
    </xsl:text>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>StructuralComponentProperties::init();
    </xsl:text>
        </xsl:if>
        
        <xsl:for-each select="cp:property">
            <xsl:value-of select="@name"/>
            <xsl:text> = </xsl:text>
            <xsl:choose>
                <!-- use given default value -->
                <xsl:when test="boolean(@defaultValue) and contains(@type,'char')">
                    <xsl:text>'</xsl:text><xsl:value-of select="@defaultValue"/><xsl:text>'</xsl:text>
                </xsl:when>
                <xsl:when test="boolean(@defaultValue) and contains(@type,'string')">
                    <xsl:text>"</xsl:text><xsl:value-of select="@defaultValue"/><xsl:text>"</xsl:text>
                </xsl:when>
                <xsl:when test="boolean(@defaultValue)">
                    <xsl:value-of select="@defaultValue"/>
                </xsl:when>
                <xsl:when test="@type='bool'">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'char')">
                    <xsl:text>'\0'</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'int')">
                    <xsl:text>0</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'string')">
                    <xsl:text>""</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>0.0</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>;
    </xsl:text>
        </xsl:for-each>
	
        
<xsl:text>
}
 
//--------------- destructor --------------
</xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>Properties::~</xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>Properties()  {
}

// --------------- xmlPrint ---------------
void </xsl:text>
        <xsl:value-of select="$class"/>
        <xsl:text>Properties::xmlPrint(std::ostream &amp;o) {
        
        // beginning of the atom properties
        </xsl:text>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>// need to cast due to multiple inheritance lattice
        BasicCellProperties::</xsl:text>
        </xsl:if>
        <xsl:text>beginXML(o);

    // print all fields and their values
    for(std::map&lt;std::string, std::string&gt;::iterator it = fields.begin(); it!=fields.end() ; it++)
			o &lt;&lt; " " &lt;&lt; (*it).first &lt;&lt; "=\"" &lt;&lt; (*it).second &lt;&lt; "\" ";

        // print the custom properties only if different than default value
</xsl:text>
        
        <xsl:for-each select="cp:property">
            <xsl:text>        if (</xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> != </xsl:text>
            <xsl:choose>
                <xsl:when test="boolean(@defaultValue) and contains(@type,'char')">
                    <xsl:text>'</xsl:text><xsl:value-of select="@defaultValue"/><xsl:text>'</xsl:text>
                </xsl:when>
                <xsl:when test="boolean(@defaultValue) and contains(@type,'string')">
                    <xsl:text>"</xsl:text><xsl:value-of select="@defaultValue"/><xsl:text>"</xsl:text>
                </xsl:when>
                <xsl:when test="boolean(@defaultValue)">
                    <xsl:value-of select="@defaultValue"/>
                </xsl:when>            
                <xsl:when test="@type='bool'">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'char')">
                    <xsl:text>'\0'</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'int')">
                    <xsl:text>0</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'string')">
                    <xsl:text>""</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>0.0</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>) {
            o &lt;&lt; " </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text>=\"" &lt;&lt; </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> &lt;&lt; "\" ";
        }
</xsl:text>            
        </xsl:for-each>

        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>        // inherited properties
</xsl:text>            
            <xsl:for-each select="../cp:structuralComponentProperties/cp:property">
                <xsl:text>        if (</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text> != </xsl:text>
                <xsl:choose>
                    <xsl:when test="boolean(@defaultValue) and contains(@type,'char')">
                        <xsl:text>'</xsl:text><xsl:value-of select="@defaultValue"/><xsl:text>'</xsl:text>
                    </xsl:when>
                    <xsl:when test="boolean(@defaultValue) and contains(@type,'string')">
                        <xsl:text>"</xsl:text><xsl:value-of select="@defaultValue"/><xsl:text>"</xsl:text>
                    </xsl:when>
                    <xsl:when test="boolean(@defaultValue)">
                        <xsl:value-of select="@defaultValue"/>
                    </xsl:when>                
                    <xsl:when test="@type='bool'">
                        <xsl:text>false</xsl:text>
                    </xsl:when>
                    <xsl:when test="contains(@type,'char')">
                        <xsl:text>'\0'</xsl:text>
                    </xsl:when>
                    <xsl:when test="contains(@type,'int')">
                        <xsl:text>0</xsl:text>
                    </xsl:when>
                    <xsl:when test="contains(@type,'string')">
                        <xsl:text>""</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>0.0</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>) {
                o &lt;&lt; " </xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text>=\"" &lt;&lt; </xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text> &lt;&lt; "\" ";
        }
</xsl:text>            
            </xsl:for-each>
        </xsl:if>        
        <xsl:text>    
        // end of the properties
        </xsl:text>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>// need to cast due to multiple inheritance lattice
        BasicCellProperties::</xsl:text>
        </xsl:if>
        <xsl:text>endXML(o);
}

</xsl:text>
    </xsl:template>
    
    
    
    <xsl:template name="xmlHandler">    
        <xsl:param name="inherits"/>
        
      <xsl:document href="src/XMLPhysicalPropertiesHandler.cpp" method="text">        
        <xsl:text>/***************************************************************************
     XMLPhysicalPropertiesHandler.cpp  -  Specific properties XML handler
                             -------------------
</xsl:text>
            <xsl:call-template name="currentDate"/>
            <xsl:text>
    copyright            : (C) 2001-</xsl:text>
        <xsl:value-of select="date:year($now)"/>
        <xsl:text> TIMC (E. Promayon, M. Chabanas)
    email                : Emmanuel.Promayon@imag.fr
    Date                 : $Date: 2008-02-20 18:08:02 +0100 (Wed, 20 Feb 2008) $
    Version              : $Revision: 2267 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "XMLPhysicalModelHandler.h"
#include "Atom.h"
#include "AtomProperties.h"
#include "Cell.h"
#include "CellProperties.h"
#include "StructuralComponent.h"
#include "StructuralComponentProperties.h"

// Read from XML. These methods are automatcially called by the PhysicalModel XML handler
// Four methods can be used to get xml attribute value:
//        std::string getStringValue(const char *);
//        int getIntValue(const char *);
//        float getFloatValue(const char *);
//        double getDoubleValue(const char *);

// atoms
void XMLPhysicalModelHandler::processAtomProperties(Atom *ptr) {
</xsl:text>

        <xsl:call-template name="getXMLProperties">
            <xsl:with-param name="properties" select="//cp:atomProperties"/>
            <xsl:with-param name="startAt">0</xsl:with-param>
        </xsl:call-template>
        
        <xsl:text>}

// cell
void XMLPhysicalModelHandler::processCellProperties(Cell *ptr) {
</xsl:text>

        <xsl:call-template name="getXMLProperties">
            <xsl:with-param name="properties" select="//cp:cellProperties"/>
            <xsl:with-param name="startAt">0</xsl:with-param>
        </xsl:call-template>
        <xsl:if test="$inherits='true' or $inherits='1'">
            <xsl:text>    // inherited properties
</xsl:text>            
        <xsl:call-template name="getXMLProperties">
            <xsl:with-param name="properties" select="//cp:structuralComponentProperties"/>
            <xsl:with-param name="startAt" select="count(//cp:cellProperties/cp:property)"/>
        </xsl:call-template>
        </xsl:if>              
      
        <xsl:text>
}

// structural component
void XMLPhysicalModelHandler::processStructuralComponentProperties(StructuralComponent *ptr) {
</xsl:text>

        <xsl:call-template name="getXMLProperties">
            <xsl:with-param name="properties" select="//cp:structuralComponentProperties"/>
            <xsl:with-param name="startAt">0</xsl:with-param>
        </xsl:call-template>
        <xsl:text>}

</xsl:text>
      
      </xsl:document>
    </xsl:template>
        
    
    <xsl:template name="getXMLProperties">    
        <xsl:param name="properties"/>
        <xsl:param name="startAt"/>
        
        <xsl:for-each select="$properties/cp:property">
            <!-- property nr -->
            <xsl:variable name="varName">
                <xsl:text>propValue</xsl:text><xsl:value-of select="position() + $startAt"/>
            </xsl:variable>
            <!-- transform the property name first letter in uppercase -->
            <xsl:variable name="upperName">
                <xsl:value-of select="concat(translate(substring(@name,1,1), $lowerCase, $upperCase), substring(@name,2))"/>
            </xsl:variable>
            
            <xsl:text>    </xsl:text>            
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>       
            <xsl:value-of select="$varName"/>
            <xsl:text>;
    </xsl:text>
            <xsl:value-of select="$varName"/>
            <xsl:text> = </xsl:text>                   
            <xsl:choose>
                <xsl:when test="@type='bool'">
                    <xsl:text>getBoolValue("</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'char')">
                    <xsl:text>getCharValue("</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'int')">
                    <xsl:text>getIntValue("</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'string')">
                    <xsl:text>getStringValue("</xsl:text>
                </xsl:when>
                <xsl:when test="contains(@type,'double')">
                    <xsl:text>getDoubleValue("</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>getFloatValue("</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="@name"/>
            <xsl:text>");
    if (noProblem())
        ptr->getProperties()->set</xsl:text>
            <xsl:value-of select="$upperName"/>
            <xsl:text>(</xsl:text>
            <xsl:value-of select="$varName"/>
            <xsl:text>);

</xsl:text>                        
        </xsl:for-each>
        
    </xsl:template>            
    

</xsl:stylesheet> 
