*** Settings ***
Documentation       Check EMC DataDomain in SNMP

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Ctn Generic Suite Setup
Test Timeout        120s


*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=storage::emc::datadomain::snmp::plugin


*** Test Cases ***
mtrees ${tc}
    [Tags]    snmp  storage
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=mtrees
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=storage/emc/datadomain/snmp/slim-datadomain
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc    extra_options                                                                                       expected_result    --
            ...      1     --verbose                                                                                           OK: All MTrees are ok | 'mtrees.detected.count'=5;;;0; '/data/col1/SQL_prod_DTX#mtree.precompression.space.usage.bytes'=71739590364364.8B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.precompression.data.written.bytes'=411672615321B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.postcompression.data.written.bytes'=4617089843B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.precompression.space.usage.bytes'=633367338103603B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.precompression.data.written.bytes'=1781445060198B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.postcompression.data.written.bytes'=261778256691B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.precompression.space.usage.bytes'=283773213710746B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.precompression.data.written.bytes'=2615957205811B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.postcompression.data.written.bytes'=252651451187B;;;0; '/data/col1/backup#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.postcompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.postcompression.data.written.bytes'=0B;;;0; checking MTree '/data/col1/SQL_prod_DTX' status: readOnly space precompression used: 65.25 TB daily data written precompression: 383.40 GB, postcompression: 4.30 GB checking MTree '/data/col1/Veeam_StorageUnit_DTX' status: readOnly space precompression used: 576.04 TB daily data written precompression: 1.62 TB, postcompression: 243.80 GB checking MTree '/data/col1/Veeam_StorageUnit_PA6' status: retentionLockEnabled space precompression used: 258.09 TB daily data written precompression: 2.38 TB, postcompression: 235.30 GB checking MTree '/data/col1/backup' status: readWrite space precompression used: 0.00 B daily data written precompression: 0.00 B, postcompression: 0.00 B checking MTree '/data/col1/cofpr3ubkp01p' status: readWrite space precompression used: 0.00 B daily data written precompression: 0.00 B, postcompression: 0.00 B 
            ...      2     --filter-counters='status'                                                                          OK: All MTrees are ok
            ...      3     --filter-mtree-name=''                                                                              OK: All MTrees are ok | 'mtrees.detected.count'=5;;;0; '/data/col1/SQL_prod_DTX#mtree.precompression.space.usage.bytes'=71739590364364.8B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.precompression.data.written.bytes'=411672615321B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.postcompression.data.written.bytes'=4617089843B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.precompression.space.usage.bytes'=633367338103603B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.precompression.data.written.bytes'=1781445060198B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.postcompression.data.written.bytes'=261778256691B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.precompression.space.usage.bytes'=283773213710746B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.precompression.data.written.bytes'=2615957205811B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.postcompression.data.written.bytes'=252651451187B;;;0; '/data/col1/backup#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.postcompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.postcompression.data.written.bytes'=0B;;;0;
            ...      4     --unknown-status=\\\%{state}                                                                        OK: All MTrees are ok | 'mtrees.detected.count'=5;;;0; '/data/col1/SQL_prod_DTX#mtree.precompression.space.usage.bytes'=71739590364364.8B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.precompression.data.written.bytes'=411672615321B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.postcompression.data.written.bytes'=4617089843B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.precompression.space.usage.bytes'=633367338103603B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.precompression.data.written.bytes'=1781445060198B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.postcompression.data.written.bytes'=261778256691B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.precompression.space.usage.bytes'=283773213710746B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.precompression.data.written.bytes'=2615957205811B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.postcompression.data.written.bytes'=252651451187B;;;0; '/data/col1/backup#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.postcompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.postcompression.data.written.bytes'=0B;;;0;
            ...      5     --warning-status=\\\%{state}                                                                        OK: All MTrees are ok | 'mtrees.detected.count'=5;;;0; '/data/col1/SQL_prod_DTX#mtree.precompression.space.usage.bytes'=71739590364364.8B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.precompression.data.written.bytes'=411672615321B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.postcompression.data.written.bytes'=4617089843B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.precompression.space.usage.bytes'=633367338103603B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.precompression.data.written.bytes'=1781445060198B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.postcompression.data.written.bytes'=261778256691B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.precompression.space.usage.bytes'=283773213710746B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.precompression.data.written.bytes'=2615957205811B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.postcompression.data.written.bytes'=252651451187B;;;0; '/data/col1/backup#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.postcompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.postcompression.data.written.bytes'=0B;;;0;
            ...      6     --critical-status=\\\%{state}                                                                       OK: All MTrees are ok | 'mtrees.detected.count'=5;;;0; '/data/col1/SQL_prod_DTX#mtree.precompression.space.usage.bytes'=71739590364364.8B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.precompression.data.written.bytes'=411672615321B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.postcompression.data.written.bytes'=4617089843B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.precompression.space.usage.bytes'=633367338103603B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.precompression.data.written.bytes'=1781445060198B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.postcompression.data.written.bytes'=261778256691B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.precompression.space.usage.bytes'=283773213710746B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.precompression.data.written.bytes'=2615957205811B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.postcompression.data.written.bytes'=252651451187B;;;0; '/data/col1/backup#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.postcompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.postcompression.data.written.bytes'=0B;;;0;
            ...      7     --warning-mtrees-detected='' --critical-mtrees-detected=''                                          OK: All MTrees are ok | 'mtrees.detected.count'=5;;;0; '/data/col1/SQL_prod_DTX#mtree.precompression.space.usage.bytes'=71739590364364.8B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.precompression.data.written.bytes'=411672615321B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.postcompression.data.written.bytes'=4617089843B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.precompression.space.usage.bytes'=633367338103603B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.precompression.data.written.bytes'=1781445060198B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.postcompression.data.written.bytes'=261778256691B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.precompression.space.usage.bytes'=283773213710746B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.precompression.data.written.bytes'=2615957205811B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.postcompression.data.written.bytes'=252651451187B;;;0; '/data/col1/backup#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.postcompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.precompression.space.usage.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.postcompression.data.written.bytes'=0B;;;0;
            ...      8     --warning-space-precompression-usage='1:' --critical-space-precompression-usage='1:'                CRITICAL: MTree '/data/col1/backup' space precompression used: 0.00 B - MTree '/data/col1/cofpr3ubkp01p' space precompression used: 0.00 B | 'mtrees.detected.count'=5;;;0; '/data/col1/SQL_prod_DTX#mtree.precompression.space.usage.bytes'=71739590364364.8B;1:;1:;0; '/data/col1/SQL_prod_DTX#mtree.daily.precompression.data.written.bytes'=411672615321B;;;0; '/data/col1/SQL_prod_DTX#mtree.daily.postcompression.data.written.bytes'=4617089843B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.precompression.space.usage.bytes'=633367338103603B;1:;1:;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.precompression.data.written.bytes'=1781445060198B;;;0; '/data/col1/Veeam_StorageUnit_DTX#mtree.daily.postcompression.data.written.bytes'=261778256691B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.precompression.space.usage.bytes'=283773213710746B;1:;1:;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.precompression.data.written.bytes'=2615957205811B;;;0; '/data/col1/Veeam_StorageUnit_PA6#mtree.daily.postcompression.data.written.bytes'=252651451187B;;;0; '/data/col1/backup#mtree.precompression.space.usage.bytes'=0B;1:;1:;0; '/data/col1/backup#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/backup#mtree.daily.postcompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.precompression.space.usage.bytes'=0B;1:;1:;0; '/data/col1/cofpr3ubkp01p#mtree.daily.precompression.data.written.bytes'=0B;;;0; '/data/col1/cofpr3ubkp01p#mtree.daily.postcompression.data.written.bytes'=0B;;;0;
