
#include <stdint.h>
#include "test.h"


const uint8_t pg_leftmost_one_pos[256] = {
    0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7
};


void test_bitwise_operations() {
    uint64_t num = 9223372036854775807;
    uint64_t word = num - 1;
    int shift = 64 - 8;

    printf("Testing num: %lu\n", num);
    printf("Initial word: %lu\n", word);
    ASSERT(9223372036854775807, num);
    ASSERT(9223372036854775806, word);

    while ((word >> shift) == 0) {
        shift -= 8;
        printf("Shift: %d, word: %lu\n", shift, word >> shift);
    }

    printf("Final shift: %d\n", shift);
    ASSERT(56, shift);
    int pos = shift + pg_leftmost_one_pos[(word >> shift) & 255];
    printf("Computed pos: %d\n", pos);
    ASSERT(62, pos);
    printf("Computed log2: %d\n", pos + 1);
    ASSERT(63, pos + 1);
}

int main() {
    test_bitwise_operations();
    return 0;
}
