-- examples/list-migration.lua
--
-- Example of list migration capability of Clod
--
-- Copyright 2012 Daniel Silverstone <dsilvers@digital-scurf.org>
--

clod = require "clod"

local configuration = [[
description = "Gitano Alpha Testers"
members = {
    "dsilvers",
    "liw",
}
subgroups {
}
]]

conf, err = clod.parse(configuration, "@config", true)
if not conf then
   error(err)
end

print("Group description is", conf.settings.description)
local members = conf:get_list("members")
print("There are", #members, "members")
for i = 1, #members do
   print(members[i])
end
local subgroups = conf:get_list("subgroups")
print("There are", #subgroups, "sub-groups")
