/*
 *  Copyright 2012  Integrated Computer Solutions - http://www.ics.com
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef ACCELEROMETER_H
#define ACCELEROMETER_H

#include "../cplugin.h"
#include <QAccelerometer>
#include <QtCore>

class Accelerometer : public CPlugin {
    Q_OBJECT
public:
    explicit Accelerometer(Cordova *cordova);

    virtual const QString fullName() override {
        return Accelerometer::fullID();
    }

    virtual const QString shortName() override {
        return "Accelerometer";
    }

    static const QString fullID() {
        return "com.cordova.Accelerometer";
    }

public slots:
    void getCurrentAcceleration(int scId, int ecId, QVariantMap p_options);

protected slots:
    void updateSensor();

private:
    QSharedPointer<QAccelerometer> m_accelerometerSource;

    bool m_sensorAvaliable;
    QList<int> m_successCallbacks;
};

#endif
