#include "sys"
#include "config/config"

vector<string> str2parts (string const &s, char sep) {
    PROFILE("str2parts");
    
    string str = s;
    size_t pos;
    vector<string> parts;

    bool sep_is_first = false;
    while ( (pos = str.find_first_of(sep)) != string::npos) {
	if (!pos) {
	    sep_is_first = true;
	    parts.push_back("");
	} else {
	    sep_is_first = true;
	    parts.push_back (str.substr(0, pos));
	}
	str = str.substr(pos + 1);
    }
    if (str.length() > 0)
	parts.push_back (str);
    else if (sep_is_first)
	parts.push_back("");

    /*
	ostringstream o;
	o << "str2parts: ";
	for (unsigned int i = 0; i < parts.size(); i++)
	    o << "[" << parts[i] << "] ";
	o << "\n";
	_debugmsg(o.str());
    */

    return (parts);
}
