#
# Common.py - common DITrack backend declarations
#
# Copyright (c) 2007 The DITrack Project, www.ditrack.org.
#
# $Id: Common.py 1913 2007-08-17 20:14:53Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/trunk/DITrack/Common.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

#
# Generic backend exception class.
#
class Error(Exception):
    """
    The following data members are available:

    message
        One-line description of a problem. No new lines, not terminated with
        a period. Suitable to be displayed in a pop-up window whatsoever.
        Always available.

    details
        A [possibly empty] list of strings describing the problem in a greater
        detail. Strings are not terminated with newlines.
    """

    def __init__(self, message, details):
        self.message = message
        self.details = details

class UpdateStatus:
    """
    Abstract class representing the backend-specific result of an update.
    """

    def __init__(self):
        raise NotImplementedError

    def __str__(self):
        raise NotImplementedError
