#!/bin/sh

# Updates .travis.yml envs based on tox.ini configuration.

# Removing old environment list
cp ./.travis.yml ./.travis.yml.bak
cat ./.travis.yml.bak | grep -v "^  - TOXENV=" > ./.travis.yml

# Inserting envs based on list generated by tox
for env_name in $(tox --listenvs | sort -r); do
    sed -i "/^env:$/a\
\ \ - TOXENV=${env_name}" ./.travis.yml;
done
