/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 by Stephen McInerney                   *
 *   spm@stedee.id.au                                                      *
 *                                                                         *
 *   $Id: common.h 58 2006-01-02 10:40:49Z steve $
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
 ***************************************************************************
 * common.h
 *
 *  Common definitions/includes
 *
 ***************************************************************************
 ***************************************************************************/

#ifndef DNSHISTORY_COMMON_H
#define DNSHISTORY_COMMON_H 1

#if HAVE_CONFIG_H
#  include <config.h>
#endif          /* HAVE_CONFIG_H */

#include <stdio.h>

#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif          /* HAVE_SYS_TYPES_H */

#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif          /* HAVE_SYS_STAT_H */

#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
# if !HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif          /* STDC_HEADERS */

#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif          /* HAVE_STRING_H */

#if HAVE_STRINGS_H
# include <strings.h>
#endif          /* HAVE_STRINGS_H */

#define __USE_XOPEN
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif          /* TIME_WITH_SYS_TIME */

#if HAVE_STDBOOL_H
# include <stdbool.h>
#endif          /* HAVE_STDBOOL_H */

#if HAVE_PCRE_H
# include <pcre.h>
#elif HAVE_PCRE_PCRE_H
# include <pcre/pcre.h>
#endif          /* HAVE_PCRE_H */

#if HAVE_DB_H
# include <db.h>
#endif          /* HAVE_DB_H */

#if HAVE_MATH_H
# include <math.h>
#endif          /* HAVE_MATH_H */

#if HAVE_GETOPT_H
# include <getopt.h>
#endif          /* HAVE_GETOPT_H */

#if HAVE_ZLIB_H
# include <zlib.h>
#endif          /* HAVE_ZLIB_H */

#if HAVE_UNISTD_H
# include <unistd.h>
#endif          /* HAVE_ZLIB_H */

#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif          /* HAVE_ZLIB_H */

#if HAVE_NETINET_IN_H
# include <netinet/in.h>                        /* Get in_addr */
#endif          /* HAVE_ZLIB_H */

#if HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif          /* HAVE_ZLIB_H */

#if HAVE_NETDB_H
# include <netdb.h>                             /* Name lookups */
#endif          /* HAVE_ZLIB_H */

#if HAVE_PTHREAD_H
# include <pthread.h>
#endif          /* HAVE_ZLIB_H */


/********************/

#endif          /* DNSHISTORY_COMMON_H */

/************************************************************************
 ************************************************************************
 *                      END OF FILE                                     *
 ************************************************************************
 ************************************************************************/
