﻿namespace Microsoft.ApplicationInsights.WindowsServer.Channel.Implementation
{
    /// <summary>
    /// Represents a method that is invoked every time sampling percentage is evaluated
    /// by the dynamic sampling algorithm.
    /// </summary>
    /// <param name="afterSamplingTelemetryItemRatePerSecond">Rate of telemetry items generated by this instance of the application after current sampling percentage was applied.</param>
    /// <param name="currentSamplingPercentage">Current sampling percentage that was used by the algorithm.</param>
    /// <param name="newSamplingPercentage">Suggested new sampling percentage that will allow to keep desired telemetry item generation rate given the volume of items states the same.</param>
    /// <param name="isSamplingPercentageChanged">A value indicating whether new sampling percentage will be applied by dynamic sampling algorithm. New sampling percentage may not be immediately applied in case it was recently changed.</param>
    /// <param name="settings">Dynamic sampling algorithm settings.</param>
    public delegate void AdaptiveSamplingPercentageEvaluatedCallback(
        double afterSamplingTelemetryItemRatePerSecond,
        double currentSamplingPercentage,
        double newSamplingPercentage,
        bool isSamplingPercentageChanged,
        Channel.Implementation.SamplingPercentageEstimatorSettings settings);
}
