# Find libjsonc
#
#   LIBJSONC_INCLUDE_DIR
#   LIBJSONC_LIBRARY

IF (LIBJSONC_INCLUDE_DIR)
  # Already in cache, be silent
  SET(LIBJSONC_FIND_QUIETLY TRUE)
ENDIF (LIBJSONC_INCLUDE_DIR)

FIND_PATH(LIBJSONC_INCLUDE_DIR json-c/json.h json/json.h)
FIND_LIBRARY(LIBJSONC_LIBRARY json-c json)

if (LIBJSONC_LIBRARY)
  add_definitions(-DHAVE_JSONC)
endif()

IF (EXISTS ${LIBJSONC_INCLUDE_DIR}/json-c/json.h)
  add_definitions(-DJSONC_INCLUDE_WITH_C)
endif()

MARK_AS_ADVANCED(LIBJSONC_LIBRARY LIBJSONC_INCLUDE_DIR)
