# -*- coding: utf-8 -*-

# LyricsScreenlet Copyright (C) 2009 by Marcel Dancak <dancakm@gmail.com>

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import dbus
import utils
import gobject
from player import PlayerEvents

REFRESH_INTERVAL = 1000

class ListenPlayer(PlayerEvents):
	
	__name__     = "Listen"
	session_bus  = None
	playerAPI    = None
	timer        = None
	lastSong     = None
	lastState    = None
	lastTime     = 0
	
	def __init__(self, session_bus):
		self.session_bus = session_bus
	
	def is_active(self, dbus_iface):
		return "org.gnome.Listen" in dbus_iface.ListNames()

	def connect(self):
		proxy = self.session_bus.get_object("org.gnome.Listen", "/org/gnome/listen")
		self.playerAPI = dbus.Interface(proxy, "org.gnome.Listen")
		if self.timer != None:
			gobject.source_remove(self.timer)
		self.timer = gobject.timeout_add(REFRESH_INTERVAL, self.refresh)
		self.lastSong = self.getCurrentFile()

	def disconnect(self):
		PlayerEvents.disconnect(self)
		if self.timer != None:
			gobject.source_remove(self.timer)
			
	def getCurrentFile(self):
		uri = self.playerAPI.get_uri()
		return utils.get_local_path_from_uri(uri)
		
	def get_title(self):
		return self.playerAPI.get_title()

	def get_artist(self):
		return self.playerAPI.get_artist()

	def get_album(self):
		return self.playerAPI.get_album()

	def is_playing(self):
		return self.playerAPI.current_playing() != ""

	def getElapsed(self):
		return self.playerAPI.current_position()

	def refresh(self):
		try:
			# song change events
			if self.onSongChanged != None:
				playing_song = self.playerAPI.get_uri()
				if playing_song != "":
					if playing_song != self.lastSong:
						self.onSongChanged(utils.get_local_path_from_uri(playing_song))
					self.lastSong = playing_song
		
			# elapsed events
			if self.onElapsed:				
				elapsed = self.getElapsed()
				if elapsed-self.lastTime not in range (0,3):
					#print str(elapsed) +' '+str(self.lastTime)
					self.onElapsed(elapsed)
				self.lastTime = elapsed	
		
			# play/stop events
			state = "play" if self.is_playing() else "stop"
			if (state != self.lastState):
				if state == "play" and self.onPlay != None:
					self.onPlay()
				if state == "stop" and self.onStop != None:
					self.onStop()
				self.lastState = state

			return True
		except Exception, e:
			print e
			return False
