/* ----- encode/761x1531round, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_761x1531round_checksums[] = {
  "f674dd6b79402fc0c6546f3716d5bc6498485e3943167d4901f3150f01ceafbc",
  "96687a4792184335a94adc906f4ec93dacf1286d3b83eff1196b48df80063634",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_761x1531round_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_761x1531round_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_761x1531round_ITEMBYTES

static void *storage_encode_761x1531round_s;
static unsigned char *test_encode_761x1531round_s;
static void *storage_encode_761x1531round_x;
static unsigned char *test_encode_761x1531round_x;
static void *storage_encode_761x1531round_s2;
static unsigned char *test_encode_761x1531round_s2;
static void *storage_encode_761x1531round_x2;
static unsigned char *test_encode_761x1531round_x2;

#define precomputed_encode_761x1531round_NUM 4

static const unsigned char precomputed_encode_761x1531round_s[precomputed_encode_761x1531round_NUM][crypto_encode_STRBYTES] = {
  {66,224,23,200,251,224,133,12,241,194,97,242,126,218,24,219,240,71,223,12,90,102,159,10,188,19,31,131,125,112,159,19,150,195,120,250,23,148,157,134,101,51,16,170,135,0,62,10,225,242,153,63,108,106,186,167,205,240,10,48,168,9,69,45,9,183,6,209,241,211,50,170,38,190,223,26,40,217,70,229,205,117,19,78,31,117,109,185,137,221,215,190,139,101,59,187,118,242,215,35,160,241,112,72,241,94,88,222,14,221,129,238,55,113,100,247,109,102,212,218,228,57,34,68,221,74,226,255,43,148,226,164,20,216,29,226,198,152,172,130,135,102,11,119,164,63,27,157,123,52,57,4,124,236,18,48,228,168,144,247,71,93,64,115,93,45,57,201,54,215,213,27,66,153,103,176,104,195,174,2,231,49,244,28,178,245,88,166,103,211,114,96,88,208,195,253,190,181,123,112,15,152,215,151,9,103,125,27,127,3,97,69,97,133,115,78,175,189,205,103,53,154,210,101,99,207,103,194,76,160,127,72,218,151,26,77,233,150,101,71,1,214,156,253,206,170,171,126,233,202,218,211,162,149,206,58,54,33,80,91,228,210,202,13,24,235,54,222,92,78,220,150,230,47,142,79,102,87,137,68,63,102,1,10,246,150,50,168,13,117,140,160,79,191,77,87,4,20,109,224,61,186,178,223,118,107,58,193,84,250,219,16,216,114,110,127,245,159,74,237,187,117,174,232,137,246,171,81,128,91,53,46,146,45,131,82,36,67,71,8,205,14,176,210,80,167,13,30,202,120,145,120,230,91,230,75,237,57,255,169,218,81,50,44,173,22,131,20,70,232,84,62,181,203,219,140,94,33,55,193,168,30,96,169,178,81,13,209,94,182,135,138,192,181,40,24,243,130,249,96,33,192,25,93,60,132,42,198,0,110,137,223,111,85,57,150,88,63,164,200,28,209,118,98,139,7,93,236,187,64,56,233,8,54,113,40,122,165,253,135,42,114,50,14,186,174,21,223,19,128,151,254,226,230,251,247,248,222,174,83,156,204,31,63,43,209,123,127,141,197,11,2,254,79,64,142,201,196,199,95,172,210,131,23,194,18,209,109,196,248,124,31,86,8,210,200,11,6,66,0,161,221,222,53,209,150,111,176,199,84,148,69,88,106,34,118,100,152,236,96,43,28,145,245,100,178,47,12,178,126,146,191,219,147,48,231,72,77,37,255,211,70,0,178,162,39,178,233,171,79,199,201,251,211,167,126,8,164,85,57,187,210,166,90,133,204,63,207,213,2,88,202,104,73,68,41,230,115,42,115,121,166,189,8,106,191,24,247,208,195,226,67,100,159,10,204,81,189,218,182,50,20,2,246,242,241,226,175,134,47,234,192,126,21,4,133,195,202,183,114,35,36,96,123,180,24,198,94,215,47,229,79,247,216,41,206,139,183,3,57,47,185,29,145,188,90,85,112,123,57,219,239,110,7,99,102,156,48,89,161,213,214,92,185,44,92,147,218,39,189,85,200,57,12,169,79,124,222,220,175,135,126,108,157,70,16,212,65,39,78,235,196,221,146,134,22,72,220,121,139,149,171,139,142,185,181,101,92,83,158,182,243,86,239,119,60,23,225,190,208,202,249,153,2,213,38,194,151,33,155,112,71,60,105,241,234,145,227,224,109,55,159,252,22,218,66,30,23,179,34,176,225,131,66,50,30,92,45,202,249,52,71,85,124,114,86,241,100,72,25,120,194,75,124,77,237,127,36,64,226,238,151,81,108,85,191,94,70,173,93,67,16,63,245,74,226,196,96,102,8,95,57,221,77,11,110,25,27,158,124,126,102,176,141,8,148,245,34,239,179,79,225,242,128,156,227,91,213,69,6,211,20,153,243,95,219,164,28,20,77,142,3,113,56,75,199,198,89,68,14,121,149,140,154,46,187,221,13,38,159,128,249,94,0,184,26,196,203,15,47,29,177,180,229,106,127,241,47,134,3,85,10,191,24,63,214,213,130,208,216,222,238,166,238,103,150,149,26,171,162,115,234,108,204,55,153,33,52,197,191,120,254,135,72,146,247,133,215,150,184,11,165,215,121,17,2,188,254,104,97,115,20,21,55,229,189,66,116,149,144,157,200,190,172,132,117,254,159,224,192,188,194,129,145,226,225,15,22,218,97,74,145,149,161,21,109,212,97,161,50,227,0,106,26,30,174,161,160,164,88,30,114,137,205,18,250,131,116,41,174,238,199,45,222,144,184,193,24,3,207,29,99,4,107,155,247,47},
  {3,193,3,115,2,143,141,53,17,199,207,158,143,21,6,197,187,66,190,73,215,56,20,74,67,212,224,90,252,105,249,7,166,211,60,140,175,143,17,169,207,84,15,246,196,19,54,132,206,85,174,209,206,95,162,75,201,69,250,54,7,7,237,110,122,81,201,154,51,101,192,153,147,49,163,238,138,233,178,227,245,185,252,153,170,65,60,139,57,61,158,51,112,155,10,146,253,57,171,22,221,51,88,86,175,50,32,176,156,197,145,38,19,70,223,230,10,45,166,147,213,114,86,138,15,40,146,201,187,170,104,175,224,49,69,76,223,239,214,150,230,85,70,11,105,53,0,192,63,150,197,106,248,195,68,151,162,152,162,148,157,137,23,164,54,120,126,247,203,114,175,252,210,162,213,74,84,62,246,186,132,254,165,40,212,102,58,235,65,73,51,226,111,178,18,128,169,168,161,184,142,54,46,124,23,201,19,156,224,43,246,41,187,59,101,162,13,120,132,25,242,126,206,73,99,109,154,85,23,96,220,109,173,122,99,242,182,22,114,55,32,241,251,255,237,104,223,22,10,56,9,72,180,207,161,144,157,145,207,130,206,142,101,115,132,214,95,188,172,123,176,93,104,142,9,170,214,227,158,60,81,24,225,234,231,200,168,163,207,162,132,212,44,228,65,53,69,197,26,119,187,136,101,20,189,222,153,99,113,221,75,227,144,116,24,244,95,7,76,133,160,142,17,227,250,148,231,118,134,41,110,252,72,180,79,180,25,161,36,94,150,148,22,244,216,199,53,134,92,240,24,56,54,117,154,147,247,5,111,30,25,159,109,109,41,0,35,217,119,90,188,70,69,241,102,193,247,211,77,16,166,132,106,226,90,182,165,90,65,101,153,75,207,84,93,160,202,101,104,125,37,39,151,97,221,14,23,52,10,179,144,167,191,104,151,53,51,28,123,230,223,96,139,162,254,89,74,66,49,135,180,48,75,211,115,5,40,34,148,32,49,250,124,161,173,51,213,40,72,45,210,65,148,236,15,122,201,139,206,10,217,95,90,66,143,233,135,126,238,210,167,144,147,107,130,248,181,248,183,121,55,103,84,23,232,112,103,1,163,68,191,27,52,168,125,114,81,200,164,149,61,244,44,102,73,129,147,215,203,9,31,85,147,212,167,234,155,38,171,82,74,16,212,126,151,25,44,97,215,110,183,216,44,157,23,116,75,46,113,212,186,187,163,10,173,146,155,18,242,124,192,228,206,222,40,33,34,142,166,232,163,238,122,44,214,152,252,152,58,23,176,184,136,99,59,25,239,160,156,27,45,171,58,225,95,13,142,108,209,135,172,8,98,164,155,241,220,42,143,255,231,4,32,15,111,179,128,216,241,71,120,212,116,59,156,183,50,175,8,166,102,68,148,0,105,8,234,83,247,176,141,113,144,105,1,125,162,42,206,0,6,110,103,80,137,70,219,57,206,242,137,2,49,89,254,43,93,105,233,138,185,208,71,25,161,124,100,190,182,248,164,254,83,166,76,97,213,131,151,249,193,153,184,182,125,255,82,52,24,103,41,137,175,59,129,254,37,102,57,58,159,15,236,113,39,247,59,37,224,30,222,22,242,116,91,193,192,81,92,165,155,214,47,140,7,8,198,236,73,152,221,21,39,140,40,196,67,160,8,205,233,53,95,68,45,210,185,42,162,212,166,31,125,221,173,216,176,226,112,245,222,198,222,203,26,124,210,193,246,173,73,163,73,172,124,94,57,143,173,12,155,102,75,25,83,205,147,35,23,86,218,151,137,25,32,58,17,111,120,77,102,191,198,9,76,21,239,130,155,206,96,221,92,225,157,123,149,131,86,43,32,34,43,236,91,61,22,116,72,94,62,15,150,142,207,239,236,158,205,19,205,2,41,45,215,121,30,64,25,40,218,28,151,205,74,141,77,254,224,170,73,126,142,23,100,67,7,44,238,0,131,198,66,220,126,210,65,18,7,203,150,109,160,41,195,64,249,228,106,95,238,43,144,98,123,253,71,162,23,140,37,25,68,30,169,6,169,249,21,128,176,196,111,249,15,231,6,8,196,125,226,30,11,43,49,176,49,52,94,162,247,78,208,158,69,101,120,166,176,53,17,254,162,246,52,79,44,250,76,17,165,182,163,84,171,175,158,160,74,240,132,142,200,116,108,22,236,29,196,66,69,0,82,200,134,54,174,124,5,39,195,61,191,162,160,58,224,139,195,83,3,239,217,150,57,181,32,8,142,34,68,241,198,47,176,225,45},
  {39,189,223,11,49,167,183,179,128,203,73,243,121,225,30,131,188,85,172,105,210,35,29,177,79,202,5,83,99,177,84,48,118,190,55,17,99,213,59,244,170,26,162,200,224,204,199,217,225,206,141,41,183,69,114,254,180,67,178,88,77,66,187,254,83,10,171,68,177,221,218,78,69,42,184,195,41,243,103,173,127,94,248,142,42,234,86,23,181,91,58,105,224,128,42,151,205,114,29,18,128,142,55,87,12,149,162,157,83,194,126,96,53,214,248,244,251,91,234,68,179,189,15,33,190,122,54,6,59,111,40,35,110,163,146,210,75,149,175,125,113,132,223,116,71,191,79,228,60,230,69,198,136,5,184,84,245,209,112,206,224,195,137,13,114,186,43,176,197,170,186,239,40,61,41,242,151,71,28,71,194,79,102,88,195,122,20,205,11,87,224,70,107,56,241,155,12,94,129,92,131,250,65,161,124,200,23,200,174,227,206,155,89,66,43,95,114,139,36,111,52,246,213,77,48,147,64,222,55,250,226,145,188,252,212,106,231,75,79,144,55,205,13,22,149,4,197,107,135,74,63,131,168,139,118,1,240,191,6,197,88,23,31,45,108,146,116,215,123,54,231,34,158,219,156,220,43,108,84,82,96,241,153,102,234,194,217,215,27,49,13,181,28,31,3,225,187,223,39,86,55,166,211,85,4,147,248,45,2,210,213,149,56,169,183,21,153,46,8,114,23,118,56,15,173,7,107,194,109,196,213,249,175,30,10,149,88,157,219,164,196,105,152,158,29,189,245,165,242,45,5,236,176,98,16,239,2,250,25,194,41,205,22,32,82,126,212,211,229,74,53,67,220,212,72,179,157,142,155,195,172,112,9,236,77,166,213,136,215,134,13,220,192,105,220,106,232,63,219,201,232,132,133,229,214,245,119,93,151,203,210,12,177,197,213,0,52,180,245,69,204,49,167,134,99,30,63,139,93,36,37,119,58,168,167,242,227,31,2,182,251,136,79,250,81,203,64,105,229,200,38,79,162,251,215,165,50,222,107,233,20,60,24,186,205,160,208,18,226,173,167,163,45,235,201,94,35,101,8,228,69,185,90,18,249,106,103,20,91,224,177,49,1,250,33,66,12,67,239,169,53,147,46,93,250,107,204,90,124,64,60,248,238,164,6,66,38,157,14,112,162,183,241,16,95,76,10,250,48,117,75,77,88,66,85,131,25,226,26,54,106,6,162,241,240,111,130,41,233,116,23,220,232,208,122,241,189,158,102,242,197,7,203,219,65,180,14,240,173,70,237,157,194,221,20,186,17,148,114,16,246,152,132,184,111,34,253,216,47,7,123,190,21,144,120,84,159,196,159,110,175,69,194,203,36,143,182,103,243,140,81,70,194,21,168,54,121,84,135,7,239,218,199,74,13,242,121,128,28,218,67,118,209,25,133,88,229,115,198,123,97,13,230,89,219,45,138,239,212,180,201,176,123,22,208,205,76,157,80,155,11,77,250,206,140,196,250,77,161,65,6,152,118,251,57,20,198,179,52,29,163,85,12,225,137,158,189,136,158,219,81,80,9,32,217,166,60,242,163,7,28,11,165,109,164,110,205,81,55,253,253,111,6,176,41,17,254,63,217,219,22,51,159,70,7,153,78,226,235,85,90,23,230,54,103,128,140,125,118,3,79,135,0,165,184,8,30,83,218,85,165,181,229,84,8,146,159,33,43,132,79,128,76,105,148,82,194,214,177,134,28,140,101,20,117,109,48,83,198,91,243,72,249,71,150,191,0,61,124,196,51,156,46,64,191,191,84,17,246,242,173,253,86,80,99,169,58,229,63,199,226,111,5,248,90,166,72,58,127,93,157,181,141,51,142,28,83,237,20,21,141,102,105,131,128,250,231,109,108,4,40,104,231,141,160,121,176,152,12,174,72,211,69,132,141,51,47,187,183,51,183,135,82,201,59,22,219,114,18,17,161,178,224,200,185,213,83,225,195,167,218,168,182,92,81,71,228,237,133,222,125,212,164,50,50,255,85,111,212,171,136,107,91,16,174,237,85,19,231,72,74,253,13,83,127,94,244,76,87,20,231,90,204,117,146,209,39,179,58,160,96,254,137,166,61,233,244,142,28,104,138,56,70,200,165,223,169,58,215,165,117,236,26,49,173,225,232,43,73,95,216,191,74,226,50,68,22,209,52,23,10,234,236,250,60,115,42,63,218,166,43,131,91,50,29,106,141,126,0,243,222,80,215,31,129,39,6,45,45,53,115,103,174,248,49,83,32},
  {157,209,193,198,227,253,67,95,222,227,84,35,13,104,74,35,111,94,175,33,182,120,111,121,2,239,127,4,111,95,210,147,238,252,80,9,76,13,71,178,76,152,227,126,142,97,159,191,254,29,23,171,164,75,40,213,251,197,45,101,228,187,76,87,12,42,244,177,251,170,155,103,140,95,90,146,208,36,39,211,222,220,97,30,229,199,79,198,102,55,123,62,93,33,131,126,63,150,213,160,137,218,3,80,100,164,87,49,34,184,78,49,18,67,176,177,25,228,24,25,49,9,151,234,248,82,48,159,59,227,53,83,211,84,141,87,245,238,236,36,203,214,181,249,118,60,219,173,126,205,209,249,224,216,229,50,239,16,145,46,9,40,3,125,197,167,52,77,249,45,254,70,82,44,200,207,121,245,202,240,100,65,16,76,218,177,149,14,74,198,220,248,62,31,230,106,97,221,99,48,132,124,120,149,24,226,232,35,15,251,103,19,63,183,213,176,171,30,237,102,90,219,249,118,199,255,118,203,247,165,48,2,172,206,88,241,238,221,154,210,27,217,231,235,61,46,39,123,144,206,252,18,56,91,143,131,201,47,7,186,229,84,110,38,39,162,59,71,155,18,150,207,55,222,23,213,117,144,140,183,226,22,142,3,90,3,237,47,229,104,27,114,179,132,214,78,202,73,106,237,95,28,85,26,22,132,97,183,91,12,175,80,65,230,242,41,81,54,183,196,149,231,41,104,144,76,207,71,89,186,143,160,111,146,212,4,250,209,120,75,97,211,173,37,137,197,167,188,201,164,33,1,167,46,191,182,40,223,69,114,183,232,63,94,130,252,18,250,245,143,196,40,221,99,24,30,170,159,174,96,132,181,6,56,76,31,81,172,102,208,18,16,14,170,6,240,151,144,107,88,237,230,163,172,179,103,240,205,83,160,5,43,162,168,144,147,228,54,243,199,109,244,217,173,149,188,171,178,218,67,17,155,130,96,46,226,181,57,243,158,75,68,231,66,192,24,82,161,42,159,108,66,241,147,105,247,227,146,185,196,11,214,13,56,150,227,179,145,120,155,26,72,153,190,46,141,62,72,73,24,208,48,15,195,93,1,88,134,74,96,48,213,208,240,107,31,202,85,81,226,116,126,6,203,31,39,109,47,21,148,109,126,125,231,128,158,35,158,130,200,228,247,127,152,243,3,195,211,85,206,26,88,120,81,113,46,92,184,127,79,77,146,248,235,174,219,64,101,133,230,6,182,80,27,249,181,18,251,7,88,84,158,66,191,170,83,230,226,43,206,245,138,231,67,2,207,237,181,167,136,69,79,65,234,240,228,143,232,200,117,6,132,113,165,5,147,188,11,9,53,20,33,253,225,105,3,212,229,209,31,28,54,11,26,18,146,62,105,110,129,74,25,127,37,180,109,165,168,225,84,238,42,233,115,248,244,147,214,12,143,211,156,83,248,221,183,53,103,37,95,165,8,110,83,74,46,139,41,42,163,64,128,144,123,158,167,105,93,77,12,42,68,36,76,92,137,255,67,115,154,130,124,116,250,111,101,156,189,212,195,185,216,31,67,51,13,151,184,53,106,238,39,241,244,102,191,114,76,174,160,21,214,163,195,69,196,209,49,42,218,234,134,64,3,95,192,184,50,198,246,140,186,95,134,237,200,42,119,83,145,101,176,27,113,4,151,227,198,150,184,99,45,67,150,180,58,237,113,62,239,198,82,106,3,27,188,69,64,82,212,198,95,20,246,140,193,67,214,159,218,47,48,25,238,48,64,207,151,157,187,50,173,231,155,217,248,168,243,163,151,87,130,75,101,215,153,224,184,233,200,81,76,223,122,30,98,69,236,161,14,165,14,171,186,236,232,18,78,205,225,164,32,23,111,131,185,51,252,218,40,2,248,8,241,248,194,242,158,154,74,61,255,196,87,177,129,231,231,50,41,40,189,3,101,218,187,21,144,93,153,115,44,120,62,84,150,118,118,143,159,79,154,82,38,142,216,121,22,145,27,72,13,42,195,145,19,14,4,19,114,108,113,11,223,18,91,35,92,179,191,102,221,56,152,14,88,130,11,229,239,119,49,253,249,30,112,168,76,191,68,241,204,46,83,115,127,245,65,17,90,129,193,190,14,83,174,53,108,242,49,23,22,57,166,120,171,48,65,254,111,84,16,61,182,64,60,60,122,64,115,8,102,241,144,77,238,239,76,27,118,29,153,30,165,228,123,5,152,234,196,240,137,41,123,53,160,213,73,78,143,123,128,151,111,63,156,3},
} ;

static const int16_t precomputed_encode_761x1531round_x[precomputed_encode_761x1531round_NUM][crypto_encode_ITEMS] = {
  {-29418,4170,-29733,5242,6719,-25897,-4454,28182,26204,-27719,25973,-17510,-4764,14489,-29638,318,-3140,-2097,11881,11790,1287,-27028,15819,19052,10978,5967,5781,-22669,-12780,-24218,-21118,2973,17615,25402,5181,-8164,-14390,-12731,-14043,-29994,31982,7477,-13160,-22804,19657,-28206,-16749,29370,-20524,19650,24539,2240,-12952,30115,22090,9824,20717,-10361,-13563,3577,-26317,25726,623,26335,-22778,-6942,30753,18944,-21167,-16891,8372,32304,-4419,2078,-26674,9737,-4679,-973,400,-7314,17258,9798,-3569,13753,-15585,-15765,-20696,6158,-523,-10878,23605,3910,-22869,-8903,22514,-15923,-454,17548,20742,31657,30571,-64,-19940,17537,-17282,-29010,-3917,32747,-902,-15133,-28229,22268,11877,5946,11906,9003,-2409,2029,11686,-13147,22837,-16720,24412,20449,-25564,-13135,10131,-11919,3755,-24331,495,-15465,20073,24037,26808,-5507,17092,-24619,-6757,-13041,-22554,17482,-14855,31288,10282,-418,-15555,24431,-3194,10958,25902,-12644,-26962,7902,-19677,-15118,6956,-1100,-12636,15163,4654,-1181,3082,-522,27141,-8554,-26143,364,439,-1000,12894,-25334,-20469,-23760,-3537,21308,-7486,6159,23679,11777,-21889,30418,-14589,5629,23948,-8648,15561,-18291,-3977,-23093,-24471,-7916,26389,16940,-28409,29099,-30375,29184,25942,-24416,-22251,-18515,30788,-17070,28143,30604,30621,1993,-16308,-12820,32434,-18340,-32669,-19120,-5879,-7651,9218,-24165,21966,27206,6614,-28132,-14521,25837,-21014,-3152,16752,14708,-26945,2339,29435,-4698,-11679,3802,20537,6305,32453,21579,-14420,-26814,-11846,-20620,1204,27198,23000,-11694,-11759,-9347,-901,-20936,7376,15981,-4803,-8204,1515,5995,15110,-121,8379,4360,17180,-12667,-29407,-5359,24691,24800,4132,8691,21946,-4068,-6595,24513,28230,-18272,-5494,-28367,-11897,31266,5062,-13753,-21582,9844,28286,-26906,-18096,5033,25067,-25257,-12833,25298,16212,-30679,8660,-25973,10478,-6388,-27612,32657,-3846,-30127,-9600,11929,11522,7071,-705,-28825,7813,20885,-5319,20590,9128,-9510,-22870,26376,-17430,-23083,9731,7703,9246,15483,28504,30141,-26383,28211,-8705,4270,-11804,-28533,30422,-21250,2470,-19235,6884,-15801,-17771,-15700,25721,-21706,-23574,31259,-9057,5032,-2275,31230,19546,-14247,3169,13605,-6265,28032,14629,30781,-5873,11108,23109,27912,362,3970,3207,3872,20521,-29766,-16550,-1899,-2313,-14170,-24009,-254,-31726,18030,32345,-12152,-3967,-9798,-26537,24912,-15199,21328,1716,-23018,-1074,10476,-20284,-5643,7784,31361,12619,-16281,-4865,2041,23655,-32532,9832,-291,16732,-25424,27761,-249,11415,23215,-14214,16049,-6770,-18230,-28163,-10362,32485,-14525,3157,-13447,-27758,-19992,23780,1873,-5569,16235,-15635,-18451,-15719,30348,-23220,-1522,19008,-1353,21449,19959,-31416,-30878,-11544,-24179,16788,18268,-19470,-15973,26220,-29523,15730,14911,-21992,-22985,-29296,-868,29410,-15400,-2415,31909,-1095,-1963,10195,17450,25196,17723,-29671,-22985,-25366,-30473,15350,5745,-30295,-7530,5864,20562,-28429,3903,-21088,15371,25697,15861,-5380,-18898,7802,-21413,-22430,32551,-27618,18407,-14267,-31782,-32548,26685,-8809,-5031,-6790,6252,-27499,10028,24373,-30852,-25723,15681,2983,16734,2365,-12781,-21298,-16155,-18821,-25040,20491,19551,-17059,3887,-15797,16998,29013,28958,23574,9188,-27323,-20273,-25607,-25217,-2747,-32061,9717,3775,-4616,-29531,-16912,-18941,8657,18755,6912,4949,9015,-6245,10641,4278,-17958,29426,18680,17172,1958,26583,-22746,-10664,-4026,1040,16557,2146,-31263,-4379,32021,-17844,-31861,29029,9702,-12007,-23686,32047,6098,-30203,18127,18063,-16126,-10387,24807,-11240,21759,-30189,13077,-11955,-25634,16681,12127,24499,26989,8726,30212,-7615,-18992,17829,-14770,-31696,-12257,1653,-24674,1465,30472,1015,27043,-27639,18378,31388,-2663,-6921,-10085,9600,32324,-4531,22427,31012,-3937,-6516,-563,-15580,22567,20022,-461,-11074,-10716,7248,-10383,32174,-23007,-31219,-32425,-15212,-28717,-8418,3176,-28960,-27244,-29230,6693,-2864,-17824,-640,1055,28895,-9614,31079,28313,-11234,-13584,-22957,-18075,21514,-4984,13434,12390,-11669,21592,-21571,-29421,-31110,19248,-3868,9923,-20625,23313,27035,27579,-25367,-25461,14217,-22181,-27401,-9930,-4570,-25116,-15916,9255,-14780,7269,26398,18813,3028,6133,-18275,-8231,-4178,-27119,-9592,-27734,32466,31411,29919,-31705,-27096,-2743,75,-15164,31155,23918,25385,3102,31050,-16259,-12516,-19561,-4335,-22401,-24241,19532,-237,-29906,12740,-24778,-2386,30275,5758,17988,22389,7951,27641,6318,-17691,-1235,-24628,-17447,11688,22941,5546,7984,-19472,-8969,-3735,5777,19252,32600,17696,-29055,17454,11908,-1331,21515,-19136,-12001,-21077,19219,-8875,17220,-30949,-23774,-24692,-12485,30917,-24816,28017,-26408,12939,-19276,-1520,24976,14873,18520,-12765,15736,44,-17965,8856,29694,9391,31850,28388,13929,-7106,-5656,-26751,32484,30790,26900,-3269,-2513,-30311,10202,13074,28711,22120,-2379},
  {25835,-1791,-15762,23160,-19011,-4257,15256,6624,-13706,14057,-4085,-27005,-25432,-2705,31506,24864,7309,-230,-30685,-3178,-16056,103,-22776,-29934,-9450,-15842,28407,-10605,30139,-14551,9021,31851,5228,-2847,19307,16936,-12713,-26762,-3840,-18774,-11192,-158,-23624,-24512,-4813,31390,-1246,-7913,-17730,30776,27619,2127,-19204,31052,27374,-8855,25516,-20945,11993,-19669,32744,-23696,-26374,4353,32755,-10641,28992,-11369,-24888,21311,14229,11318,-6512,-15581,-31660,-25250,-8889,-5364,-9967,16500,3605,22826,7561,-9230,14050,-5896,26181,130,-1357,-5860,16248,1966,23728,-32243,10800,27690,325,-29591,-26051,13587,13284,9318,-22494,-28064,30144,26392,31346,29415,1752,-13666,30968,25665,-27041,-10591,23379,16367,12942,-25865,-3831,9089,8284,22498,-15581,9073,29098,9626,-27369,24931,12582,-10707,6596,32510,-32755,-2518,18762,-6778,27745,-24833,-4374,-31800,18112,3924,32132,-2054,-25208,-26573,12290,9349,-20778,27908,-18756,30979,12472,17113,6220,-30425,23255,-876,-24586,-22964,16281,-11474,18840,-9851,-32520,-9104,23324,13284,-3597,4151,-31560,2668,-19421,3408,-17409,31566,27602,14149,-19001,32574,8508,846,25628,14832,32266,15766,30143,-5730,-27630,11933,-23405,18023,13657,8577,11519,21735,-18830,15085,17107,-31243,31734,19740,-9507,15741,11572,-11965,10254,-11920,28267,20506,26049,31913,19019,27958,-1889,906,-19510,1181,27533,32428,23492,-17499,-26484,-22770,20511,27497,-8289,-21196,-32041,-6381,-11206,1213,28113,30098,19495,-27401,5870,14702,-31453,-31354,13453,31036,-12273,-23249,27994,-22962,-6985,20186,31511,-3272,-21595,-29013,22396,22115,-21838,-1460,16410,-12337,-8254,-20790,-26312,14703,18745,14611,-14569,12062,23714,26122,-5757,-24531,-15650,-13972,-25802,-17419,-9743,15121,-5056,-7940,11579,-29304,1950,-30510,4179,-5606,-8310,25184,-2628,-24022,-4622,-32312,-5288,20576,-12582,-13159,-15924,4900,24903,-23105,3818,-7254,-1586,12473,15509,19380,-21273,-19856,-8439,-23605,30141,-29893,19976,-28751,21621,4028,-24807,-18407,-16912,-18576,5976,-13120,9838,27636,6787,1744,-8039,-18815,-3474,21793,-5805,7620,-19945,-6973,30332,-351,-11168,-20036,23426,-9098,-3346,1164,10067,-20557,-11197,-25575,-10419,-4558,-23863,-5784,26992,20691,-12501,-25422,31275,-27731,-14879,1652,-25707,-6510,27870,7723,-6096,18524,8044,-2224,28258,23275,1640,22226,-7707,12059,-14117,16784,-30655,23383,21861,30095,-27981,29292,10797,-22654,10421,24590,-6886,-8776,17391,-13,-14700,-27151,-7709,26563,32060,21090,1278,22076,-18447,8557,-23184,290,-12836,9821,11537,-17378,-15432,-5466,6390,-28589,32647,-6182,31891,-3048,27036,-16055,507,-6610,-3222,-987,-10875,-11415,-24884,16254,-4585,3142,-18137,-6921,-8352,-6741,28200,2182,-27459,14321,-7536,25899,10001,27908,6981,31948,-20116,-31997,13071,27592,31135,-15465,22628,-6294,21170,-14928,-29125,29058,-10566,-25049,16889,-3437,3893,-10466,-8733,-23905,8430,-11477,-21709,-1832,24582,-11642,-18661,-17356,-31754,29393,-4542,15309,5795,-24746,-3906,10192,-15681,19650,24773,6125,-16026,26071,856,-3489,-11515,8181,28372,-351,11789,15375,15749,3567,32752,31094,27912,-26676,11272,-15946,14777,-26796,4306,-4309,-5664,10718,6698,-15195,-21822,7067,-12779,13214,-616,-26860,21304,-17178,-29098,9869,26070,4462,11249,-1978,15374,-17931,13763,-28548,-16150,-6315,-3457,19813,-31869,3967,24029,6075,7418,8631,-23522,-19364,-32380,-30433,1543,24575,-15837,5851,9148,-3562,-10746,19717,27563,-21362,-18437,-20636,1689,-202,9911,-5491,-12917,-27867,21803,6493,-24362,4471,4149,-6732,-8331,-18026,26116,-25484,18305,-32082,19167,25416,32692,26529,16584,-27019,-7993,24249,-31015,11469,-19113,-12974,-24475,20538,4579,-24413,25798,-11192,24524,9494,22576,-18798,744,28384,28634,-3980,16274,16799,24999,-21708,-16039,24024,32532,5014,10429,23937,3281,14786,-11711,-32367,-29619,11327,22383,4882,-15645,23492,19693,-13236,-3663,-5321,31178,25538,22870,30779,-27836,-27142,-10640,-31039,21901,4199,27973,-5849,12986,-2327,-26714,5811,12420,-6820,24283,-26626,27468,30532,-22260,2369,-12399,29858,-2628,15670,-2153,-25134,24619,21100,-14029,-32423,-12348,-21657,9627,-31382,-11682,30813,-32469,-16847,-10946,21240,-32071,-22967,-4294,23814,4477,-20800,10779,30586,23047,-31225,29245,27366,-27746,23433,-2105,-29353,2714,-27856,11705,19019,-18756,-29706,30279,28605,17458,31825,-20956,23195,-24330,-22002,7455,28352,-5315,-17661,12203,21566,30564,14644,-30337,24655,-1957,30703,23360,3999,-31384,-9375,5502,10752,7692,-2211,-16178,19258,-32561,-3060,9429,-1020,-11086,604,-19606,-2597,-22138,18654,13675,27561,-24651,21299,-3321,20936,26523,21119,-6942,24706,-3699,19697,3657,-19146,-22198,-25707,3761,8828,-18194,-19810,-14307,22686,14023,-20933,10273,5552,6674,-32490,-18196,20576,-22717,16291,-11039,-7930,-8390,-27447,26905,-2082,-24157,18873,29650},
  {-20442,20983,-4660,-2779,-25090,5708,-521,-29337,-12717,-31286,-29349,-7190,4437,-13754,-4962,31113,-25313,12480,15257,734,8524,21893,6018,-25555,-27825,-16689,3327,-1919,22719,-12516,-12343,25876,8656,-20233,13529,-11723,-7410,22539,-20083,29004,25097,-2626,-13417,-24658,19423,26814,5403,30523,-5526,8735,32115,25818,-27600,-15193,22653,20976,7709,-18426,-14506,-3203,-11109,-19619,5954,-25297,2166,-19494,5125,9365,-29311,20430,-13310,21758,19492,3795,10540,-22638,-5527,8747,-25660,18281,7648,26881,20025,-18581,-9775,31235,-24923,28440,-2544,-29510,-7243,5553,-16806,-20981,-23538,12322,-10198,5872,-31245,8176,-12338,24181,-6513,6412,12019,27134,-17341,14162,188,24657,22643,1259,7149,31026,-25938,19101,15866,-13667,-33,17408,-1262,17783,-15054,19077,29397,-1650,32524,8716,29476,-19898,-8748,-23865,-32473,-21742,-3686,28722,-32705,-31315,618,-1077,-26169,-801,-3181,-27860,23637,-20596,-22271,-12458,-6787,-28183,11265,-9172,-16935,9549,2216,25445,16581,7050,-2698,20409,5150,-10353,-10221,-17810,-29862,10883,-9665,-8053,31941,-11036,16791,-13824,24891,-5665,-11983,3792,-31535,4600,27133,23250,31311,-27402,-27250,-490,2745,31960,-23627,28126,6057,22340,-25075,32073,-27734,-13804,-3450,1911,11230,-25308,21050,22844,-6992,-21586,26924,29475,23748,-23024,-8815,-5392,-16472,-3344,26760,15920,14413,22506,-15620,8666,-9653,-10010,30551,-29325,20575,-19401,-27005,-15434,1240,20141,-17396,-13636,31388,18425,-23008,-22505,-21506,-18983,-29816,19384,-26145,13480,8447,-28804,9609,12421,16952,8915,16968,-16421,-22346,-18459,-5076,23762,-19842,-4340,-21600,-19806,22473,-5946,30077,-24987,25185,-17599,27694,-25452,-15007,28780,-29323,-2290,-17822,16162,17904,18604,-5273,-19141,-25377,-19805,23101,-18755,-2650,-26276,2618,32455,24085,-22991,-20560,-15244,-12517,-1350,-19819,27205,-28286,18936,-2945,-25576,14930,6887,32230,23059,25603,6424,-10239,29772,-22011,-1416,-22875,29619,-12349,-16572,-6604,-1418,11196,10583,32325,-10372,14754,-17309,-15236,-17807,-8782,-31918,-9796,7039,-4681,-14784,12063,17458,24447,17614,28510,31200,1943,6317,15277,20513,-11250,6384,27831,12788,-13218,-8180,-8243,-15619,-32043,-27656,-8076,-1854,-25769,2305,-30559,11778,-18535,-16524,24231,-18024,-2221,14168,20603,-12809,141,-23683,-12542,16965,21772,-14494,-11604,31993,23022,-24118,-1993,-23226,-22517,-58,-21423,32514,-6903,3119,-16154,31470,3160,-3308,-26287,-21377,30847,-15051,24190,-26477,-7668,28055,14414,-19208,454,26015,-245,5240,-26972,-26383,-11040,-15210,-18951,-9543,19359,31624,4912,8897,-24189,18572,-12994,-12203,-22012,-13553,23278,-7544,-10047,19996,22244,-28835,-2054,-7230,2860,2624,8274,-7639,24429,8865,-26657,-3419,4925,-13141,11371,10535,6117,17130,-1171,14000,25429,-23031,-8224,30790,13554,20771,-3086,-1700,12303,12266,-21417,31980,12104,-13161,21670,710,20792,-12911,-10265,-19181,-7377,-20244,-12173,-19455,-30648,-26683,828,-20148,-26393,-1925,13095,6073,-26985,-2431,-11065,14540,-28798,15215,-21969,-12744,22657,30256,15865,22694,-25793,-1257,-3877,27716,-303,-7406,-30146,-30822,18695,-8089,15909,-11261,-15393,8871,27906,-22469,-30314,-1463,-1359,22661,-3576,24094,-32520,-18929,-4357,10362,22387,-26566,-9785,15614,4970,28055,15132,-26320,-30787,32403,-17152,-291,20900,-8060,-19247,17250,27746,24382,-7891,2422,7295,-23017,2131,24327,-27202,2475,22910,30075,-16772,31688,28061,-6892,-6912,-12922,22113,-11158,14575,-10473,-25872,-1672,-1311,-14507,-5633,10203,-26610,-19370,17061,-14184,28747,-7585,32766,10272,629,3295,-4167,-5535,18440,22130,-25976,14775,30599,-13576,4283,25299,24382,20850,-25649,19978,17071,-19988,17587,24028,-22900,-31682,-11596,-20450,-17483,-30090,-31961,-13457,25265,5361,30698,-19978,1632,-14533,-18125,-20512,18104,29656,32317,4413,26220,-4,-12317,-28589,245,6456,-23544,-2429,30709,-7670,-5495,24588,-25902,-10446,26972,-9960,4494,4964,10250,-6181,-896,3949,-7334,-8578,-19671,13714,-17117,-11121,-32742,-31461,-2640,31343,-20395,32689,1545,-407,-7264,-10109,31661,19920,-32604,2316,24688,-9651,-8692,11921,201,23177,9388,-27573,-14690,27448,-27521,28952,-29430,22177,8751,-91,32146,31357,5969,-30605,24785,-27764,3043,-5901,4462,31851,30922,-23754,-6588,-2287,21861,-2550,-2678,-17480,6828,27805,16531,-14556,-10749,-18108,3423,26315,20383,-28369,15173,-20368,8401,29223,-30453,-7710,-19879,20565,6174,23601,-28290,-17129,12658,-22847,24555,-21240,-27570,-19114,19915,-28084,13370,-29164,8583,4348,19968,-15766,11908,-28593,-20985,32356,-21911,-14501,-17379,11635,23225,21142,-7710,28403,-27623,-2715,-6054,-15717,-4633,-26537,25399,-13817,-23372,18097,-31262,32104,-23251,14842,14553,-30794,-6893,-19312,-25317,29110,5207,19848,-12421,-18940,23302,18350,5827,-19283,-15707,15,-18564,-19874,4118,26172,-8118,-15584,-8263,-20775,-16413,22130,7227,-354,8563},
  {-28867,30541,22036,-13373,5957,4156,18968,8085,-22813,-25068,2814,-21901,25805,4155,-25429,23640,19088,6405,-10907,27334,18553,11757,-22301,-30687,9010,-22055,-581,11503,-17052,-19879,-972,-27291,17058,-30387,30046,6983,195,-26988,30508,-619,24389,15887,11985,11242,-22520,6443,15545,-14465,-19172,1036,-4474,14331,-4480,-13765,-30406,16247,-6244,-489,19295,18915,-30154,18017,-1063,-1983,4470,25746,-5947,-19148,30106,-20231,14086,-5576,5691,-25981,-4907,-625,-25034,-21730,11917,-24492,31294,-23115,3194,2091,16708,-26377,4316,4634,16028,31696,-5343,25454,3470,-3489,925,31462,29288,17439,-32365,-31314,1285,2247,22603,-6633,-30249,-10901,16323,22325,2403,27140,12258,24091,11505,-29992,-5668,-31809,13631,28155,-4193,-24850,-17870,23177,17904,13102,16237,-15070,-22085,16939,-8805,-28330,-10629,-22877,-27748,24929,-6836,-8737,5705,-3559,-1945,-5962,28948,9340,-7819,27413,-20543,21672,6853,22928,9480,-13305,20353,868,-29316,-22824,6284,16705,-18687,-9897,-3019,11617,-19808,25916,-19095,20683,-28325,16454,-26600,21907,-1480,-29352,-29789,-285,-18508,23754,-22565,12066,-26758,-17846,16870,-24859,-10566,-23680,25060,-1675,30491,22792,-26189,4988,25485,-3729,13592,31272,-11432,-8359,23002,1548,-31931,-24579,-16241,7006,18479,-8820,28776,7116,-2518,25922,-12680,9763,18911,24672,-24946,29532,-15305,30789,24090,24661,-22391,-20106,13907,19216,-16907,17162,4527,-14270,2779,-11991,23853,9295,12935,26092,22767,29543,-17105,8910,-19597,18428,-5316,-30867,25812,-11281,4289,-12936,23376,-30289,-32632,27080,14526,-10438,28870,-14182,21900,23897,-31288,12409,22449,-32254,26655,-26286,7081,1286,-20236,-19533,-12175,20717,-31687,-17822,-7317,-10773,-24603,-1824,-32038,4401,15280,-31283,-17925,-16060,-16178,-709,11482,-3042,599,13983,-26194,18652,14104,24276,28405,-25894,17803,17066,3939,-17159,-17262,-29226,-3172,-13530,28840,-27730,-13754,2254,-4162,-6683,-8401,-22709,6280,15824,-11318,-15340,30782,5464,-19391,-6052,13220,-6195,6521,19224,-8735,-30700,-21706,-28576,-31900,14103,-2610,26341,3782,6137,29506,-7837,-17781,15380,12669,-9027,-18732,-29676,-27797,4641,19047,-1914,-22912,-30199,-10909,-279,25915,-278,-1720,3914,13296,-25516,23352,-17253,23040,31986,-804,-13997,23882,26806,-20190,13613,-6331,2182,-25616,-1694,-8130,-30840,-26443,2337,9437,3847,13280,29515,-10378,19484,-551,-17189,-16438,17295,20117,26002,-21428,30368,24735,-17909,10040,-21835,-6366,-16560,23713,-1463,20210,12614,-24551,-10802,24553,-30108,14016,28585,27480,10462,-11566,15024,4319,-4838,-13181,25405,27379,-2013,-28804,30714,-27037,-4801,23741,-14734,28584,-17301,28359,16001,-25662,27788,-2503,2172,-4882,4090,-15000,-30036,-15101,-31925,-6122,8248,-27632,24971,29004,-25271,5393,24435,-8959,4240,20963,21620,2621,16241,-11599,-24483,-20404,-1954,-1497,22242,16073,7555,12921,-5464,-16898,-19189,10291,4451,-2821,-20950,-6486,24520,2395,16773,16144,15086,-13831,-6037,-31100,15855,22081,-27133,12427,-18960,-10460,-30183,2057,8723,-6443,26082,1756,-23745,-9950,-15369,1713,-13130,22862,28464,18249,-19008,-25529,25532,-20666,15090,-16964,29765,4058,-11902,-8522,-17794,-12725,-30116,-26850,2909,5319,15309,29190,-8757,-24552,32234,-24777,13992,5776,-8242,-2051,-25873,-10175,-8343,21438,21368,-29220,15256,27360,-13372,-4473,-29439,-17503,27790,-29010,-13232,8561,-18219,-24965,21308,5223,-21213,-29433,21018,-26953,-32098,-30003,-763,-10509,-21917,25230,-18790,6499,-7675,23465,-24770,28250,24009,-10011,29481,-19680,-15577,28654,-5544,-14325,5863,31036,-24741,10639,29929,10634,15159,-10448,-7982,-10808,-193,7821,2185,-17284,-5244,-8993,-28518,9956,-24610,-13020,32497,-4984,-9317,16956,-7570,-18463,-3138,13558,-21974,-30477,21196,-2209,-1896,-5084,-8716,-10158,11343,-17905,-21970,9350,21906,-29521,-20960,-28069,18726,-10796,26821,-8556,-6072,-26901,-19654,12770,13604,-21215,-26620,29179,-18504,5392,1489,-24584,-7322,7563,-6009,-22979,-24972,-17824,-3868,-6324,28340,18509,12681,19430,-598,-24691,-26066,-1569,8424,-23656,-32060,19483,20667,-19035,-26435,17459,-18684,-13911,873,29201,9651,6910,-17167,30224,-13823,-23404,-5066,-10996,2269,922,11281,-24869,32315,-17457,-260,-10362,17791,21359,15459,16007,-5949,-6677,-6976,5360,-5867,28817,32217,11401,18976,21884,-21057,-1188,-24979,-2222,-32661,-1907,7876,-26994,-22292,-10857,-26095,-25138,12027,27165,-21868,10219,4120,30427,4080,15196,23272,11449,-20596,3986,-15699,20274,-2487,-23334,-9595,22805,-30860,15356,21924,16024,29347,-8502,-25612,-10349,27321,-13031,16424,8778,-10145,-18022,32253,30535,-32350,3522,-3185,3260,2516,-15677,18186,-25698,5358,-1493,20776,-12676,-11331,27679,21865,-5605,-24607,-9401,20098,-20498,-10630,-4712,16151,24446,3285,134,2819,-24175,26346,23283,-4565,12925,20496,-22041,-20270,-6776,26666,-27004,29266,-25636,-32466,-1187},
} ;

static void test_encode_761x1531round_impl(long long impl)
{
  unsigned char *s = test_encode_761x1531round_s;
  unsigned char *x = test_encode_761x1531round_x;
  unsigned char *s2 = test_encode_761x1531round_s2;
  unsigned char *x2 = test_encode_761x1531round_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_761x1531round_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_761x1531round(impl);
    printf("encode_761x1531round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x1531round_implementation(impl),ntruprime_dispatch_encode_761x1531round_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_761x1531round;
    printf("encode_761x1531round selected implementation %s compiler %s\n",ntruprime_encode_761x1531round_implementation(),ntruprime_encode_761x1531round_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_761x1531round_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_761x1531round_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_761x1531round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_761x1531round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_761x1531round_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_761x1531round_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_761x1531round(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x1531round")) return;
  storage_encode_761x1531round_s = callocplus(crypto_encode_STRBYTES);
  test_encode_761x1531round_s = aligned(storage_encode_761x1531round_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_761x1531round_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_761x1531round_x = aligned(storage_encode_761x1531round_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_761x1531round_s2 = callocplus(maxalloc);
  test_encode_761x1531round_s2 = aligned(storage_encode_761x1531round_s2,crypto_encode_STRBYTES);
  storage_encode_761x1531round_x2 = callocplus(maxalloc);
  test_encode_761x1531round_x2 = aligned(storage_encode_761x1531round_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_761x1531round offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_761x1531round();++impl)
      forked(test_encode_761x1531round_impl,impl);
    ++test_encode_761x1531round_s;
    ++test_encode_761x1531round_x;
    ++test_encode_761x1531round_s2;
    ++test_encode_761x1531round_x2;
  }
  free(storage_encode_761x1531round_x2);
  free(storage_encode_761x1531round_s2);
  free(storage_encode_761x1531round_x);
  free(storage_encode_761x1531round_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

