# Short version of "tcl/ex/simple.tcl", also present at
# https://www.isi.edu/websites/nsnam/ns/doc/node2.html
# and in the "The ns Manual"

# The preamble
set ns [new Simulator]

# Predefine tracing
set f [open out.tr w]
$ns trace-all $f

# Topology
#
#       n0
#         \
#      5Mb \
#      2ms  \
#            \
#             n2 --------- n3
#            /     1.5Mb
#      5Mb  /       10ms
#      2ms /
#         /
#       n1
#
set n0 [$ns node]
set n1 [$ns node]
set n2 [$ns node]
set n3 [$ns node]
$ns duplex-link $n0 $n2 5Mb 2ms DropTail
$ns duplex-link $n1 $n2 5Mb 2ms DropTail
$ns duplex-link $n2 $n3 1.5Mb 10ms DropTail

# Some agents
set udp0 [new Agent/UDP]
$ns attach-agent $n0 $udp0
set cbr0 [new Application/Traffic/CBR]
$cbr0 attach-agent $udp0
$udp0 set class_ 0

set null0 [new Agent/Null]
$ns attach-agent $n3 $null0

$ns connect $udp0 $null0
$ns at 1.0 "$cbr0 start"

# A FTP over TCP/Tahoe from $n1 to $n3, flowid 2
set tcp [new Agent/TCP]
$tcp set class_ 1
$ns attach-agent $n1 $tcp

set sink [new Agent/TCPSink]
$ns attach-agent $n3 $sink

set ftp [new Application/FTP]
$ftp attach-agent $tcp
$ns at 1.2 "$ftp start"

$ns connect $tcp $sink
$ns at 1.35 "$ns detach-agent $n0 $tcp ; $ns detach-agent $n3 $sink"

# The simulation runs for 3s
# The simulation comes to an end when the scheduler invokes the finish{} procedure below
# This procedure closes all trace files
$ns at 3.0 "finish"
proc finish {} {
        global ns f
        $ns flush-trace
        close $f

        exit 0
}

# Finally, start the simulation
$ns run
