/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef FILETRANSFERWGT_H
#define FILETRANSFERWGT_H

#include <QWidget>
#include <QPushButton>
#include <QLabel>
#include <QProgressBar>
#include <QHostAddress>
#include <QLayout>
#include <QCheckBox>
#include <QCloseEvent>

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class FileTransferWgt : public QWidget
{
  Q_OBJECT
  private:
    QGridLayout*  m_grid;
    QPushButton*  m_cancelBtn;
    QPushButton*  m_acceptBtn;
    QPushButton*  m_rejectBtn;
    QProgressBar* m_progress;
    QCheckBox*    m_autoCloseChbx;
    quint16       m_id;
    quint64       m_uid; // uid of sender or receiver
    quint64       m_ip; // ip of sender or receiver
    QString       m_filename;
    bool          m_finished;
    bool          m_receiving; // esli false - to otobrazhaet peredachu faila
    bool          m_accepted;

    QLabel*       m_filenameLab;
    QString       m_userName;

  public:
    FileTransferWgt(const QString &, bool receiving = 0, QWidget *parent = 0);
    ~FileTransferWgt();

    void retranslate();

    void init();

    void setUserName(const QString& name){m_userName = name;}
    void setID   (quint16 id ){m_id  = id;}
    void setIp   (quint64 ip ){m_ip  = ip;}
    void setUid  (quint64 uid){m_uid = uid;}
    bool cmp     (quint16 id, quint64 uid) const {return (id == m_id && uid == m_uid);}

  public slots:
    void slot_selfDestroy();
    void slot_setProgress(quint8, quint16, quint64);
    void slot_accept();
    void slot_reject();
    void slot_kill  (quint16 id){if(id == m_id) slot_selfDestroy();}
    void slot_cancelledByReceiver(quint16 id);
    void slot_cannotSend         (quint16 id);
    void slot_rejectedByReceiver (quint16 id);
    void slot_cancelledBySender  (quint16 id, quint64 ip);
    void slot_receivingTimeout   (quint16 id, quint64 ip);
    void slot_sendingTimeout     (quint16 id);

  protected:
    void closeEvent(QCloseEvent* ev)
    {
      slot_reject();
      ev->accept();
    }

  signals:
    void accepted(const QString &, quint16, quint64);
    void rejected(quint16, quint64, int);
    void cancel  (quint16);
};

#endif
