from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


aliases = _Mock()

boolean_flag = _Mock()

catch_config_error = _Mock()

check_for_zmq = _Mock()

default_secure = _Mock()

errno = _Mock()

filefind = _Mock()

flags = _Mock()

get_ipython_dir = _Mock()

httpserver = _Mock()

import_item = _Mock()

io = _Mock()

ioloop = _Mock()

json = _Mock()

kernel_aliases = _Mock()

kernel_flags = _Mock()

launch_new_instance = _Mock()

list_running_servers = _Mock()

load_handlers = _Mock()

log_request = _Mock()

logging = _Mock()

notebook_aliases = _Mock()

notebook_flags = _Mock()

os = _Mock()

print_function = _Mock()

py3compat = _Mock()

random = _Mock()

random_ports = _Mock()

re = _Mock()

select = _Mock()

signal = _Mock()

socket = _Mock()

submodule = _Mock()

swallow_argv = _Mock()

sys = _Mock()

threading = _Mock()

time = _Mock()

tornado = _Mock()

url_path_join = _Mock()

version_info = _Mock()

web = _Mock()

webbrowser = _Mock()

DEFAULT_STATIC_FILES_PATH = '/usr/share/ipython/notebook/static'

_examples = '\nipython notebook                       # start the notebook\nipython notebook --profile=sympy       # use the sympy profile\nipython notebook --certfile=mycert.pem # use SSL/TLS certificate\n'

msg = 'The IPython Notebook requires tornado >= 3.1.0'

class AuthenticatedFileHandler(_Mock):
  pass
  CACHE_MAX_AGE = 315360000

class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Bytes(_Mock):
  pass
  default_value = ''
  info_text = 'a bytes object'

class ClusterManager(_Mock):
  pass


class Config(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class DottedObjectName(_Mock):
  pass
  info_text = 'a valid object identifier in Python'

class Environment(_Mock):
  pass
  overlayed = False
  sandboxed = False
  shared = False

class FileFindHandler(_Mock):
  pass
  CACHE_MAX_AGE = 315360000

class FileNotebookManager(_Mock):
  pass


class FileSystemLoader(_Mock):
  pass
  has_source_access = True

class IPythonConsoleApp(_Mock):
  pass
  description = '\n        The IPython Mixin Console.\n        \n        This class contains the common portions of console client (QtConsole,\n        ZMQ-based terminal console, etc).  It is not a full console, in that\n        launched terminal subprocesses will not be able to accept input.\n        \n        The Console using this mixing supports various extra features beyond\n        the single-process Terminal IPython shell, such as connecting to\n        existing kernel, via:\n        \n            ipython <appname> --existing\n        \n        as well as tunnel via SSH\n        \n    '
  name = 'ipython-console-mixin'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class List(_Mock):
  pass
  info_text = 'any value'

class MappingKernelManager(_Mock):
  pass


class NbserverListApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'List currently running notebook servers in this profile.'

class NotebookApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = '\n        The IPython HTML Notebook.\n        \n        This launches a Tornado based HTML Notebook Server that serves up an\n        HTML5/Javascript Notebook client.\n    '
  examples = '\nipython notebook                       # start the notebook\nipython notebook --profile=sympy       # use the sympy profile\nipython notebook --certfile=mycert.pem # use SSL/TLS certificate\n'
  name = 'ipython-notebook'

class NotebookManager(_Mock):
  pass


class NotebookNotary(_Mock):
  pass


class NotebookWebApplication(_Mock):
  pass


class ProfileDir(_Mock):
  pass


class SessionManager(_Mock):
  pass


class Template404(_Mock):
  pass


class TraitError(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

