// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file calculatorServer.hpp
 * Server implementation for interfaces
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__CALCULATOR_SERVER_HPP
#define FAST_DDS_GENERATED__CALCULATOR_SERVER_HPP

#include <memory>

#include <fastdds/dds/domain/DomainParticipant.hpp>
#include <fastdds/dds/domain/qos/ReplierQos.hpp>
#include <fastdds/dds/rpc/exceptions.hpp>
#include <fastdds/dds/rpc/interfaces.hpp>
#include <fastdds/rtps/common/Guid.hpp>
#include <fastdds/rtps/common/RemoteLocators.hpp>

#include "calculator.hpp"

namespace calculator_example {

struct CalculatorServer_IServerImplementation
{
    virtual ~CalculatorServer_IServerImplementation() = default;

    virtual calculator_example::detail::Calculator_representation_limits_Out representation_limits(
            const eprosima::fastdds::dds::rpc::RpcRequest& info) = 0;



    virtual int32_t addition(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ int32_t value1,
            /*in*/ int32_t value2) = 0;



    virtual int32_t subtraction(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ int32_t value1,
            /*in*/ int32_t value2) = 0;



    virtual void fibonacci_seq(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ uint32_t n_results,
            /*result*/ eprosima::fastdds::dds::rpc::RpcServerWriter<int32_t>& result_writer) = 0;



    virtual int32_t sum_all(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ eprosima::fastdds::dds::rpc::RpcServerReader<int32_t>& value) = 0;



    virtual void accumulator(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ eprosima::fastdds::dds::rpc::RpcServerReader<int32_t>& value,
            /*result*/ eprosima::fastdds::dds::rpc::RpcServerWriter<int32_t>& result_writer) = 0;



    virtual void filter(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ eprosima::fastdds::dds::rpc::RpcServerReader<int32_t>& value,
            /*in*/ calculator_example::FilterKind filter_kind,
            /*result*/ eprosima::fastdds::dds::rpc::RpcServerWriter<int32_t>& result_writer) = 0;

};

/**
 * @brief Create a Calculator server instance.
 *
 * @param part             The DomainParticipant to use for the server.
 * @param service_name     The name of the service.
 * @param qos              The QoS settings for the server.
 * @param thread_pool_size The size of the thread pool to use for processing requests.
 *                         When set to 0, a pool with a single thread will be created.
 * @param implementation   The implementation of the server interface.
 */
extern eProsima_user_DllExport std::shared_ptr<eprosima::fastdds::dds::rpc::RpcServer> create_CalculatorServer(
        eprosima::fastdds::dds::DomainParticipant& part,
        const char* service_name,
        const eprosima::fastdds::dds::ReplierQos& qos,
        size_t thread_pool_size,
        std::shared_ptr<CalculatorServer_IServerImplementation> implementation);

/**
 * @brief Create a Calculator server instance.
 *
 * @param part            The DomainParticipant to use for the server.
 * @param service_name    The name of the service.
 * @param qos             The QoS settings for the server.
 * @param scheduler       The request scheduling strategy to use for the server.
 * @param implementation  The implementation of the server interface.
 */
extern eProsima_user_DllExport std::shared_ptr<eprosima::fastdds::dds::rpc::RpcServer> create_CalculatorServer(
        eprosima::fastdds::dds::DomainParticipant& part,
        const char* service_name,
        const eprosima::fastdds::dds::ReplierQos& qos,
        std::shared_ptr<eprosima::fastdds::dds::rpc::RpcServerSchedulingStrategy> scheduler,
        std::shared_ptr<CalculatorServer_IServerImplementation> implementation);


} // namespace calculator_example


#endif  // FAST_DDS_GENERATED__CALCULATOR_CLIENT_HPP
