/* vfs-file.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-file.vala, do not modify */

/*
 * Desktop Agnostic Library: File interface (similar to GFile).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_TYPE (desktop_agnostic_vfs_file_type_get_type ())

#define DESKTOP_AGNOSTIC_VFS_TYPE_ACCESS_FLAGS (desktop_agnostic_vfs_access_flags_get_type ())

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE (desktop_agnostic_vfs_file_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFile))
#define DESKTOP_AGNOSTIC_VFS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))

typedef struct _DesktopAgnosticVFSFile DesktopAgnosticVFSFile;
typedef struct _DesktopAgnosticVFSFileClass DesktopAgnosticVFSFileClass;
typedef struct _DesktopAgnosticVFSFilePrivate DesktopAgnosticVFSFilePrivate;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR (desktop_agnostic_vfs_file_monitor_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR, DesktopAgnosticVFSFileMonitor))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR, DesktopAgnosticVFSFileMonitorIface))

typedef struct _DesktopAgnosticVFSFileMonitor DesktopAgnosticVFSFileMonitor;
typedef struct _DesktopAgnosticVFSFileMonitorIface DesktopAgnosticVFSFileMonitorIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_EVENT (desktop_agnostic_vfs_file_monitor_event_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION (desktop_agnostic_vfs_implementation_get_type ())
#define DESKTOP_AGNOSTIC_VFS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, DesktopAgnosticVFSImplementation))
#define DESKTOP_AGNOSTIC_VFS_IS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_IMPLEMENTATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, DesktopAgnosticVFSImplementationIface))

typedef struct _DesktopAgnosticVFSImplementation DesktopAgnosticVFSImplementation;
typedef struct _DesktopAgnosticVFSImplementationIface DesktopAgnosticVFSImplementationIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR (desktop_agnostic_vfs_volume_monitor_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, DesktopAgnosticVFSVolumeMonitor))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, DesktopAgnosticVFSVolumeMonitorIface))

typedef struct _DesktopAgnosticVFSVolumeMonitor DesktopAgnosticVFSVolumeMonitor;
typedef struct _DesktopAgnosticVFSVolumeMonitorIface DesktopAgnosticVFSVolumeMonitorIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME (desktop_agnostic_vfs_volume_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, DesktopAgnosticVFSVolume))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, DesktopAgnosticVFSVolumeIface))

typedef struct _DesktopAgnosticVFSVolume DesktopAgnosticVFSVolume;
typedef struct _DesktopAgnosticVFSVolumeIface DesktopAgnosticVFSVolumeIface;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
   * File-related errors.
   */
typedef enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_ERROR_FILE_NOT_FOUND,
	DESKTOP_AGNOSTIC_VFS_FILE_ERROR_EXISTS,
	DESKTOP_AGNOSTIC_VFS_FILE_ERROR_INVALID_TYPE
} DesktopAgnosticVFSFileError;
#define DESKTOP_AGNOSTIC_VFS_FILE_ERROR desktop_agnostic_vfs_file_error_quark ()
typedef enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN = 0,
	DESKTOP_AGNOSTIC_VFS_FILE_TYPE_REGULAR,
	DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY,
	DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SYMBOLIC_LINK,
	DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SPECIAL
} DesktopAgnosticVFSFileType;

typedef enum  {
	DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_NONE = 0,
	DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ = 1 << 0,
	DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE = 1 << 1,
	DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_EXECUTE = 1 << 2
} DesktopAgnosticVFSAccessFlags;

typedef enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_UNKNOWN = 0,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED
} DesktopAgnosticVFSFileMonitorEvent;

struct _DesktopAgnosticVFSFileMonitorIface {
	GTypeInterface parent_iface;
	void (*emit) (DesktopAgnosticVFSFileMonitor* self, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event);
	gboolean (*cancel) (DesktopAgnosticVFSFileMonitor* self);
	gboolean (*get_cancelled) (DesktopAgnosticVFSFileMonitor* self);
};

struct _DesktopAgnosticVFSFile {
	GObject parent_instance;
	DesktopAgnosticVFSFilePrivate * priv;
};

struct _DesktopAgnosticVFSFileClass {
	GObjectClass parent_class;
	void (*init) (DesktopAgnosticVFSFile* self, const char* uri);
	gboolean (*exists) (DesktopAgnosticVFSFile* self);
	DesktopAgnosticVFSFileMonitor* (*monitor) (DesktopAgnosticVFSFile* self);
	gboolean (*load_contents) (DesktopAgnosticVFSFile* self, char** contents, gsize* length, GError** error);
	gboolean (*replace_contents) (DesktopAgnosticVFSFile* self, const char* contents, GError** error);
	gboolean (*launch) (DesktopAgnosticVFSFile* self, GError** error);
	GSList* (*enumerate_children) (DesktopAgnosticVFSFile* self, GError** error);
	gboolean (*copy) (DesktopAgnosticVFSFile* self, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error);
	gboolean (*remove) (DesktopAgnosticVFSFile* self, GError** error);
	gboolean (*is_native) (DesktopAgnosticVFSFile* self);
	char* (*get_mime_type) (DesktopAgnosticVFSFile* self, GError** error);
	char** (*get_icon_names) (DesktopAgnosticVFSFile* self, int* result_length1, GError** error);
	char* (*get_thumbnail_path) (DesktopAgnosticVFSFile* self);
	void* (*get_implementation) (DesktopAgnosticVFSFile* self);
	char* (*get_impl_uri) (DesktopAgnosticVFSFile* self);
	char* (*get_impl_path) (DesktopAgnosticVFSFile* self);
	DesktopAgnosticVFSFileType (*get_file_type) (DesktopAgnosticVFSFile* self);
	DesktopAgnosticVFSAccessFlags (*get_access_flags) (DesktopAgnosticVFSFile* self);
	DesktopAgnosticVFSFile* (*get_parent) (DesktopAgnosticVFSFile* self);
};

typedef void (*DesktopAgnosticVFSVolumeCallback) (void* user_data);
typedef enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_MOUNT,
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_UNMOUNT,
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_EJECT
} DesktopAgnosticVFSVolumeError;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR desktop_agnostic_vfs_volume_error_quark ()
struct _DesktopAgnosticVFSVolumeIface {
	GTypeInterface parent_iface;
	gboolean (*is_mounted) (DesktopAgnosticVFSVolume* self);
	void (*mount) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*mount_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	void (*unmount) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*unmount_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	gboolean (*can_eject) (DesktopAgnosticVFSVolume* self);
	void (*eject) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*eject_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	const char* (*get_name) (DesktopAgnosticVFSVolume* self);
	DesktopAgnosticVFSFile* (*get_uri) (DesktopAgnosticVFSVolume* self);
	char* (*get_icon) (DesktopAgnosticVFSVolume* self);
};

struct _DesktopAgnosticVFSVolumeMonitorIface {
	GTypeInterface parent_iface;
	void* (*get_implementation) (DesktopAgnosticVFSVolumeMonitor* self);
	GList* (*get_volumes) (DesktopAgnosticVFSVolumeMonitor* self);
};

struct _DesktopAgnosticVFSImplementationIface {
	GTypeInterface parent_iface;
	void (*init) (DesktopAgnosticVFSImplementation* self);
	GSList* (*files_from_uri_list) (DesktopAgnosticVFSImplementation* self, const char* uri_list, GError** error);
	DesktopAgnosticVFSVolumeMonitor* (*volume_monitor_get_default) (DesktopAgnosticVFSImplementation* self);
	void (*shutdown) (DesktopAgnosticVFSImplementation* self);
	const char* (*get_name) (DesktopAgnosticVFSImplementation* self);
	GType (*get_file_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_file_monitor_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_trash_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_volume_type) (DesktopAgnosticVFSImplementation* self);
};


static gpointer desktop_agnostic_vfs_file_parent_class = NULL;

GQuark desktop_agnostic_vfs_file_error_quark (void);
GType desktop_agnostic_vfs_file_type_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_access_flags_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_file_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_file_monitor_event_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_file_monitor_get_type (void) G_GNUC_CONST;
enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_FILE_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_FILE_IMPL_URI,
	DESKTOP_AGNOSTIC_VFS_FILE_URI,
	DESKTOP_AGNOSTIC_VFS_FILE_IMPL_PATH,
	DESKTOP_AGNOSTIC_VFS_FILE_PATH,
	DESKTOP_AGNOSTIC_VFS_FILE_FILE_TYPE,
	DESKTOP_AGNOSTIC_VFS_FILE_ACCESS_FLAGS,
	DESKTOP_AGNOSTIC_VFS_FILE_PARENT
};
void desktop_agnostic_vfs_file_init (DesktopAgnosticVFSFile* self, const char* uri);
static void desktop_agnostic_vfs_file_real_init (DesktopAgnosticVFSFile* self, const char* uri);
gboolean desktop_agnostic_vfs_file_exists (DesktopAgnosticVFSFile* self);
static gboolean desktop_agnostic_vfs_file_real_exists (DesktopAgnosticVFSFile* self);
gboolean desktop_agnostic_vfs_file_is_readable (DesktopAgnosticVFSFile* self);
DesktopAgnosticVFSAccessFlags desktop_agnostic_vfs_file_get_access_flags (DesktopAgnosticVFSFile* self);
gboolean desktop_agnostic_vfs_file_is_writable (DesktopAgnosticVFSFile* self);
gboolean desktop_agnostic_vfs_file_is_executable (DesktopAgnosticVFSFile* self);
DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_monitor (DesktopAgnosticVFSFile* self);
static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_real_monitor (DesktopAgnosticVFSFile* self);
gboolean desktop_agnostic_vfs_file_load_contents (DesktopAgnosticVFSFile* self, char** contents, gsize* length, GError** error);
static gboolean desktop_agnostic_vfs_file_real_load_contents (DesktopAgnosticVFSFile* self, char** contents, gsize* length, GError** error);
gboolean desktop_agnostic_vfs_file_replace_contents (DesktopAgnosticVFSFile* self, const char* contents, GError** error);
static gboolean desktop_agnostic_vfs_file_real_replace_contents (DesktopAgnosticVFSFile* self, const char* contents, GError** error);
gboolean desktop_agnostic_vfs_file_launch (DesktopAgnosticVFSFile* self, GError** error);
static gboolean desktop_agnostic_vfs_file_real_launch (DesktopAgnosticVFSFile* self, GError** error);
GSList* desktop_agnostic_vfs_file_enumerate_children (DesktopAgnosticVFSFile* self, GError** error);
static GSList* desktop_agnostic_vfs_file_real_enumerate_children (DesktopAgnosticVFSFile* self, GError** error);
gboolean desktop_agnostic_vfs_file_copy (DesktopAgnosticVFSFile* self, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error);
static gboolean desktop_agnostic_vfs_file_real_copy (DesktopAgnosticVFSFile* self, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error);
gboolean desktop_agnostic_vfs_file_remove (DesktopAgnosticVFSFile* self, GError** error);
static gboolean desktop_agnostic_vfs_file_real_remove (DesktopAgnosticVFSFile* self, GError** error);
gboolean desktop_agnostic_vfs_file_is_native (DesktopAgnosticVFSFile* self);
static gboolean desktop_agnostic_vfs_file_real_is_native (DesktopAgnosticVFSFile* self);
char* desktop_agnostic_vfs_file_get_mime_type (DesktopAgnosticVFSFile* self, GError** error);
static char* desktop_agnostic_vfs_file_real_get_mime_type (DesktopAgnosticVFSFile* self, GError** error);
char** desktop_agnostic_vfs_file_get_icon_names (DesktopAgnosticVFSFile* self, int* result_length1, GError** error);
static char** desktop_agnostic_vfs_file_real_get_icon_names (DesktopAgnosticVFSFile* self, int* result_length1, GError** error);
char* desktop_agnostic_vfs_file_get_thumbnail_path (DesktopAgnosticVFSFile* self);
static char* desktop_agnostic_vfs_file_real_get_thumbnail_path (DesktopAgnosticVFSFile* self);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_construct (GType object_type);
void* desktop_agnostic_vfs_file_get_implementation (DesktopAgnosticVFSFile* self);
char* desktop_agnostic_vfs_file_get_impl_uri (DesktopAgnosticVFSFile* self);
char* desktop_agnostic_vfs_file_get_uri (DesktopAgnosticVFSFile* self);
static void desktop_agnostic_vfs_file_set_uri (DesktopAgnosticVFSFile* self, const char* value);
char* desktop_agnostic_vfs_file_get_impl_path (DesktopAgnosticVFSFile* self);
char* desktop_agnostic_vfs_file_get_path (DesktopAgnosticVFSFile* self);
static void desktop_agnostic_vfs_file_set_path (DesktopAgnosticVFSFile* self, const char* value);
DesktopAgnosticVFSFileType desktop_agnostic_vfs_file_get_file_type (DesktopAgnosticVFSFile* self);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_get_parent (DesktopAgnosticVFSFile* self);
static void desktop_agnostic_vfs_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_file_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_new_for_path (const char* path, GError** error);
GQuark desktop_agnostic_vfs_volume_error_quark (void);
GType desktop_agnostic_vfs_volume_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_volume_monitor_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_implementation_get_type (void) G_GNUC_CONST;
DesktopAgnosticVFSImplementation* desktop_agnostic_vfs_get_default (GError** error);
GType desktop_agnostic_vfs_implementation_get_file_type (DesktopAgnosticVFSImplementation* self);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_new_for_uri (const char* uri, GError** error);
char** desktop_agnostic_vfs_get_icon_names_for_mime_type (const char* mime_type, int* result_length1);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static void _vala_array_add2 (char*** array, int* length, int* size, char* value);
static void _vala_array_add3 (char*** array, int* length, int* size, char* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark desktop_agnostic_vfs_file_error_quark (void) {
	return g_quark_from_static_string ("desktop_agnostic_vfs_file_error-quark");
}


/**
   * The kinds of files recognized by the File backends.
   */
GType desktop_agnostic_vfs_file_type_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_file_type_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_file_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN, "DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN", "unknown"}, {DESKTOP_AGNOSTIC_VFS_FILE_TYPE_REGULAR, "DESKTOP_AGNOSTIC_VFS_FILE_TYPE_REGULAR", "regular"}, {DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY, "DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY", "directory"}, {DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SYMBOLIC_LINK, "DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SYMBOLIC_LINK", "symbolic-link"}, {DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SPECIAL, "DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SPECIAL", "special"}, {0, NULL, NULL}};
		GType desktop_agnostic_vfs_file_type_type_id;
		desktop_agnostic_vfs_file_type_type_id = g_enum_register_static ("DesktopAgnosticVFSFileType", values);
		g_once_init_leave (&desktop_agnostic_vfs_file_type_type_id__volatile, desktop_agnostic_vfs_file_type_type_id);
	}
	return desktop_agnostic_vfs_file_type_type_id__volatile;
}


GType desktop_agnostic_vfs_access_flags_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_access_flags_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_access_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_NONE, "DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_NONE", "none"}, {DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ, "DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ", "read"}, {DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE, "DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE", "write"}, {DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_EXECUTE, "DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_EXECUTE", "execute"}, {0, NULL, NULL}};
		GType desktop_agnostic_vfs_access_flags_type_id;
		desktop_agnostic_vfs_access_flags_type_id = g_enum_register_static ("DesktopAgnosticVFSAccessFlags", values);
		g_once_init_leave (&desktop_agnostic_vfs_access_flags_type_id__volatile, desktop_agnostic_vfs_access_flags_type_id);
	}
	return desktop_agnostic_vfs_access_flags_type_id__volatile;
}


/**
     * Implementation detail. Implementing classes override this to properly
     * associate the URI with the implementation pointer.
     */
static void desktop_agnostic_vfs_file_real_init (DesktopAgnosticVFSFile* self, const char* uri) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_init'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_vfs_file_init (DesktopAgnosticVFSFile* self, const char* uri) {
	DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->init (self, uri);
}


/**
     * Whether something exists at the URI that the object represents.
     */
static gboolean desktop_agnostic_vfs_file_real_exists (DesktopAgnosticVFSFile* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_exists'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_vfs_file_exists (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->exists (self);
}


/**
     * Whether the file is readable.
     */
gboolean desktop_agnostic_vfs_file_is_readable (DesktopAgnosticVFSFile* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (desktop_agnostic_vfs_file_get_access_flags (self) & DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ) != 0;
	return result;
}


/**
     * Whether the file is writable.
     */
gboolean desktop_agnostic_vfs_file_is_writable (DesktopAgnosticVFSFile* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (desktop_agnostic_vfs_file_get_access_flags (self) & DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE) != 0;
	return result;
}


/**
     * Whether the file is executable.
     */
gboolean desktop_agnostic_vfs_file_is_executable (DesktopAgnosticVFSFile* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (desktop_agnostic_vfs_file_get_access_flags (self) & DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_EXECUTE) != 0;
	return result;
}


/**
     * Adds a monitor to the file.
     * @return the monitor associated with the file
     */
static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_real_monitor (DesktopAgnosticVFSFile* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_monitor'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_monitor (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->monitor (self);
}


/**
     * Loads the contents of the file to a string.
     * @return %TRUE on success, %FALSE on failure.
     */
static gboolean desktop_agnostic_vfs_file_real_load_contents (DesktopAgnosticVFSFile* self, char** contents, gsize* length, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_load_contents'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_vfs_file_load_contents (DesktopAgnosticVFSFile* self, char** contents, gsize* length, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->load_contents (self, contents, length, error);
}


/**
     * Saves a string to the specified file, replacing any content that may
     * have been in it.
     * @return %TRUE on success, %FALSE on failure.
     */
static gboolean desktop_agnostic_vfs_file_real_replace_contents (DesktopAgnosticVFSFile* self, const char* contents, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_replace_contents'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_vfs_file_replace_contents (DesktopAgnosticVFSFile* self, const char* contents, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->replace_contents (self, contents, error);
}


/**
     * Launches the specified file with the default MIME application.
     * @return %TRUE on successful launch, %FALSE on failure.
     */
static gboolean desktop_agnostic_vfs_file_real_launch (DesktopAgnosticVFSFile* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_launch'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_vfs_file_launch (DesktopAgnosticVFSFile* self, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->launch (self, error);
}


/**
     * Retrieves a list of child file objects for a given object. Only
     * guaranteed to work on directories.
     * @return a list of child file objects
     */
static GSList* desktop_agnostic_vfs_file_real_enumerate_children (DesktopAgnosticVFSFile* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_enumerate_children'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GSList* desktop_agnostic_vfs_file_enumerate_children (DesktopAgnosticVFSFile* self, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->enumerate_children (self, error);
}


/**
     * Copies a file to another URI. This is a synchronous operation. Only
     * guaranteed to work on files, not directories.
     * @param destination the destination of the copied file.
     * @param overwrite if a file exists at the destination, whether to
     * overwrite it.
     */
static gboolean desktop_agnostic_vfs_file_real_copy (DesktopAgnosticVFSFile* self, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_vfs_file_copy (DesktopAgnosticVFSFile* self, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->copy (self, destination, overwrite, error);
}


/**
     * Removes the specified file. Only works on files, not directories.
     * @return %TRUE on success, %FALSE on failure.
     */
static gboolean desktop_agnostic_vfs_file_real_remove (DesktopAgnosticVFSFile* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_vfs_file_remove (DesktopAgnosticVFSFile* self, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->remove (self, error);
}


/**
     * Checks to see if a file is native to the platform.
     * @return %TRUE if file is native, %FALSE otherwise.
     */
static gboolean desktop_agnostic_vfs_file_real_is_native (DesktopAgnosticVFSFile* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_is_native'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_vfs_file_is_native (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->is_native (self);
}


/**
     * Gets the file's mime type. (might block)
     * @return String containing file's mime type.
     */
static char* desktop_agnostic_vfs_file_real_get_mime_type (DesktopAgnosticVFSFile* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_get_mime_type'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* desktop_agnostic_vfs_file_get_mime_type (DesktopAgnosticVFSFile* self, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_mime_type (self, error);
}


/**
     * Gets list of possible icon names representing this file. (might block)
     * @return List of possible icon names.
     */
static char** desktop_agnostic_vfs_file_real_get_icon_names (DesktopAgnosticVFSFile* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_vfs_file_get_icon_names'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char** desktop_agnostic_vfs_file_get_icon_names (DesktopAgnosticVFSFile* self, int* result_length1, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_icon_names (self, result_length1, error);
}


/**
     * Get path to thumbnail representing this file. (might block)
     * @return Path to file with thumbnail or %null if thumbnail cannot be
     * found or backend doesn't support it.
     */
static char* desktop_agnostic_vfs_file_real_get_thumbnail_path (DesktopAgnosticVFSFile* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* desktop_agnostic_vfs_file_get_thumbnail_path (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_thumbnail_path (self);
}


DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_construct (GType object_type) {
	DesktopAgnosticVFSFile * self = NULL;
	self = (DesktopAgnosticVFSFile*) g_object_new (object_type, NULL);
	return self;
}


void* desktop_agnostic_vfs_file_get_implementation (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_implementation (self);
}


char* desktop_agnostic_vfs_file_get_impl_uri (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_impl_uri (self);
}


char* desktop_agnostic_vfs_file_get_uri (DesktopAgnosticVFSFile* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = desktop_agnostic_vfs_file_get_impl_uri (self);
	return result;
}


static void desktop_agnostic_vfs_file_set_uri (DesktopAgnosticVFSFile* self, const char* value) {
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		desktop_agnostic_vfs_file_init (self, value);
	}
	g_object_notify ((GObject *) self, "uri");
}


char* desktop_agnostic_vfs_file_get_impl_path (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_impl_path (self);
}


char* desktop_agnostic_vfs_file_get_path (DesktopAgnosticVFSFile* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = desktop_agnostic_vfs_file_get_impl_path (self);
	return result;
}


static void desktop_agnostic_vfs_file_set_path (DesktopAgnosticVFSFile* self, const char* value) {
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		char* _tmp0_;
		desktop_agnostic_vfs_file_init (self, _tmp0_ = g_strconcat ("file://", value, NULL));
		_g_free0 (_tmp0_);
	}
	g_object_notify ((GObject *) self, "path");
}


DesktopAgnosticVFSFileType desktop_agnostic_vfs_file_get_file_type (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_file_type (self);
}


DesktopAgnosticVFSAccessFlags desktop_agnostic_vfs_file_get_access_flags (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_access_flags (self);
}


DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_get_parent (DesktopAgnosticVFSFile* self) {
	return DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS (self)->get_parent (self);
}


static void desktop_agnostic_vfs_file_class_init (DesktopAgnosticVFSFileClass * klass) {
	desktop_agnostic_vfs_file_parent_class = g_type_class_peek_parent (klass);
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->init = desktop_agnostic_vfs_file_real_init;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->exists = desktop_agnostic_vfs_file_real_exists;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->monitor = desktop_agnostic_vfs_file_real_monitor;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->load_contents = desktop_agnostic_vfs_file_real_load_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->replace_contents = desktop_agnostic_vfs_file_real_replace_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->launch = desktop_agnostic_vfs_file_real_launch;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->enumerate_children = desktop_agnostic_vfs_file_real_enumerate_children;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->copy = desktop_agnostic_vfs_file_real_copy;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->remove = desktop_agnostic_vfs_file_real_remove;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->is_native = desktop_agnostic_vfs_file_real_is_native;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_mime_type = desktop_agnostic_vfs_file_real_get_mime_type;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_icon_names = desktop_agnostic_vfs_file_real_get_icon_names;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_thumbnail_path = desktop_agnostic_vfs_file_real_get_thumbnail_path;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_file_set_property;
	/**
	     * The pointer to the implementation used.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_IMPLEMENTATION, g_param_spec_pointer ("implementation", "implementation", "implementation", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Implementation detail. Implementing classes override this to allow the
	     * uri property to return the correct value.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_IMPL_URI, g_param_spec_string ("impl-uri", "impl-uri", "impl-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The URI that the object represents.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Implementation detail. Implementing classes override this to allow the
	     * path property to return the correct value.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_IMPL_PATH, g_param_spec_string ("impl-path", "impl-path", "impl-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The path that the object represents.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The kind of file that the object represents.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_FILE_TYPE, g_param_spec_enum ("file-type", "file-type", "file-type", DESKTOP_AGNOSTIC_VFS_TYPE_FILE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Access rights for the current user for the file.
	     * @see AccessFlags
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_ACCESS_FLAGS, g_param_spec_enum ("access-flags", "access-flags", "access-flags", DESKTOP_AGNOSTIC_VFS_TYPE_ACCESS_FLAGS, DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The parent URI. If this is the root, returns %NULL.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_PARENT, g_param_spec_object ("parent", "parent", "parent", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void desktop_agnostic_vfs_file_instance_init (DesktopAgnosticVFSFile * self) {
}


/**
   * Abstract base class for representations of files.
   */
GType desktop_agnostic_vfs_file_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_file_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSFile), 0, (GInstanceInitFunc) desktop_agnostic_vfs_file_instance_init, NULL };
		GType desktop_agnostic_vfs_file_type_id;
		desktop_agnostic_vfs_file_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&desktop_agnostic_vfs_file_type_id__volatile, desktop_agnostic_vfs_file_type_id);
	}
	return desktop_agnostic_vfs_file_type_id__volatile;
}


static void desktop_agnostic_vfs_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSFile * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_FILE_URI:
		g_value_take_string (value, desktop_agnostic_vfs_file_get_uri (self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_PATH:
		g_value_take_string (value, desktop_agnostic_vfs_file_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_file_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSFile * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_FILE_URI:
		desktop_agnostic_vfs_file_set_uri (self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_PATH:
		desktop_agnostic_vfs_file_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_new_for_path (const char* path, GError** error) {
	DesktopAgnosticVFSFile* result = NULL;
	DesktopAgnosticVFSImplementation* vfs;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	vfs = desktop_agnostic_vfs_get_default (&_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (vfs == NULL) {
		result = NULL;
		return result;
	} else {
		GObject* _tmp0_;
		result = DESKTOP_AGNOSTIC_VFS_FILE ((_tmp0_ = g_object_new (desktop_agnostic_vfs_implementation_get_file_type (vfs), "path", path, NULL), G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_));
		return result;
	}
}


DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_new_for_uri (const char* uri, GError** error) {
	DesktopAgnosticVFSFile* result = NULL;
	DesktopAgnosticVFSImplementation* vfs;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	vfs = desktop_agnostic_vfs_get_default (&_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (vfs == NULL) {
		result = NULL;
		return result;
	} else {
		GObject* _tmp0_;
		result = DESKTOP_AGNOSTIC_VFS_FILE ((_tmp0_ = g_object_new (desktop_agnostic_vfs_implementation_get_file_type (vfs), "uri", uri, NULL), G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_));
		return result;
	}
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


char** desktop_agnostic_vfs_get_icon_names_for_mime_type (const char* mime_type, int* result_length1) {
	char** result = NULL;
	gint names_length1;
	gint _names_size_;
	char** _tmp0_;
	char** names;
	char** _tmp1_;
	char** _tmp2_;
	gint _tmp2__length1;
	char** _tmp3_;
	g_return_val_if_fail (mime_type != NULL, NULL);
	names = (_tmp0_ = NULL, names_length1 = 0, _names_size_ = names_length1, _tmp0_);
	g_return_val_if_fail (_vala_strcmp0 (mime_type, "") != 0, NULL);
	_vala_array_add1 (&names, &names_length1, &_names_size_, string_replace (mime_type, "/", "-"));
	_vala_array_add2 (&names, &names_length1, &_names_size_, g_strdup_printf ("gnome-mime-%s", names[0]));
	_vala_array_add3 (&names, &names_length1, &_names_size_, g_strdup_printf ("%s-x-generic", (_tmp2_ = _tmp1_ = g_regex_split_simple ("/.*", mime_type, 0, 0), _tmp2__length1 = _vala_array_length (_tmp1_), _tmp2_)[0]));
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = (_tmp3_ = names, *result_length1 = names_length1, _tmp3_);
	return result;
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




