/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_300a(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x300a, 0x0002), ElementsDictionaryEntry("RT Plan Label", "RTPlanLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0003), ElementsDictionaryEntry("RT Plan Name", "RTPlanName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0004), ElementsDictionaryEntry("RT Plan Description", "RTPlanDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0006), ElementsDictionaryEntry("RT Plan Date", "RTPlanDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0007), ElementsDictionaryEntry("RT Plan Time", "RTPlanTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0009), ElementsDictionaryEntry("Treatment Protocols", "TreatmentProtocols",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x000a), ElementsDictionaryEntry("Plan Intent", "PlanIntent",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x000b), ElementsDictionaryEntry("Treatment Sites", "TreatmentSites",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x000c), ElementsDictionaryEntry("RT Plan Geometry", "RTPlanGeometry",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x000e), ElementsDictionaryEntry("Prescription Description", "PrescriptionDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0010), ElementsDictionaryEntry("Dose Reference Sequence", "DoseReferenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0012), ElementsDictionaryEntry("Dose Reference Number", "DoseReferenceNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0013), ElementsDictionaryEntry("Dose Reference UID", "DoseReferenceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0014), ElementsDictionaryEntry("Dose Reference Structure Type", "DoseReferenceStructureType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0015), ElementsDictionaryEntry("Nominal Beam Energy Unit", "NominalBeamEnergyUnit",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0016), ElementsDictionaryEntry("Dose Reference Description", "DoseReferenceDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0018), ElementsDictionaryEntry("Dose Reference Point Coordinates", "DoseReferencePointCoordinates",  "DS", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x001a), ElementsDictionaryEntry("Nominal Prior Dose", "NominalPriorDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0020), ElementsDictionaryEntry("Dose Reference Type", "DoseReferenceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0021), ElementsDictionaryEntry("Constraint Weight", "ConstraintWeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0022), ElementsDictionaryEntry("Delivery Warning Dose", "DeliveryWarningDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0023), ElementsDictionaryEntry("Delivery Maximum Dose", "DeliveryMaximumDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0025), ElementsDictionaryEntry("Target Minimum Dose", "TargetMinimumDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0026), ElementsDictionaryEntry("Target Prescription Dose", "TargetPrescriptionDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0027), ElementsDictionaryEntry("Target Maximum Dose", "TargetMaximumDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0028), ElementsDictionaryEntry("Target Underdose Volume Fraction", "TargetUnderdoseVolumeFraction",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x002a), ElementsDictionaryEntry("Organ at Risk Full-volume Dose", "OrganAtRiskFullVolumeDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x002b), ElementsDictionaryEntry("Organ at Risk Limit Dose", "OrganAtRiskLimitDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x002c), ElementsDictionaryEntry("Organ at Risk Maximum Dose", "OrganAtRiskMaximumDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x002d), ElementsDictionaryEntry("Organ at Risk Overdose Volume Fraction", "OrganAtRiskOverdoseVolumeFraction",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0040), ElementsDictionaryEntry("Tolerance Table Sequence", "ToleranceTableSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0042), ElementsDictionaryEntry("Tolerance Table Number", "ToleranceTableNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0043), ElementsDictionaryEntry("Tolerance Table Label", "ToleranceTableLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0044), ElementsDictionaryEntry("Gantry Angle Tolerance", "GantryAngleTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0046), ElementsDictionaryEntry("Beam Limiting Device Angle Tolerance", "BeamLimitingDeviceAngleTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0048), ElementsDictionaryEntry("Beam Limiting Device Tolerance Sequence", "BeamLimitingDeviceToleranceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x004a), ElementsDictionaryEntry("Beam Limiting Device Position Tolerance", "BeamLimitingDevicePositionTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x004b), ElementsDictionaryEntry("Snout Position Tolerance", "SnoutPositionTolerance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x004c), ElementsDictionaryEntry("Patient Support Angle Tolerance", "PatientSupportAngleTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x004e), ElementsDictionaryEntry("Table Top Eccentric Angle Tolerance", "TableTopEccentricAngleTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x004f), ElementsDictionaryEntry("Table Top Pitch Angle Tolerance", "TableTopPitchAngleTolerance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0050), ElementsDictionaryEntry("Table Top Roll Angle Tolerance", "TableTopRollAngleTolerance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0051), ElementsDictionaryEntry("Table Top Vertical Position Tolerance", "TableTopVerticalPositionTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0052), ElementsDictionaryEntry("Table Top Longitudinal Position Tolerance", "TableTopLongitudinalPositionTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0053), ElementsDictionaryEntry("Table Top Lateral Position Tolerance", "TableTopLateralPositionTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0055), ElementsDictionaryEntry("RT Plan Relationship", "RTPlanRelationship",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0070), ElementsDictionaryEntry("Fraction Group Sequence", "FractionGroupSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0071), ElementsDictionaryEntry("Fraction Group Number", "FractionGroupNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0072), ElementsDictionaryEntry("Fraction Group Description", "FractionGroupDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0078), ElementsDictionaryEntry("Number of Fractions Planned", "NumberOfFractionsPlanned",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0079), ElementsDictionaryEntry("Number of Fraction Pattern Digits Per Day", "NumberOfFractionPatternDigitsPerDay",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x007a), ElementsDictionaryEntry("Repeat Fraction Cycle Length", "RepeatFractionCycleLength",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x007b), ElementsDictionaryEntry("Fraction Pattern", "FractionPattern",  "LT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0080), ElementsDictionaryEntry("Number of Beams", "NumberOfBeams",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0082), ElementsDictionaryEntry("Beam Dose Specification Point", "BeamDoseSpecificationPoint",  "DS", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x0083), ElementsDictionaryEntry("Referenced Dose Reference UID", "ReferencedDoseReferenceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0084), ElementsDictionaryEntry("Beam Dose", "BeamDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0086), ElementsDictionaryEntry("Beam Meterset", "BeamMeterset",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0088), ElementsDictionaryEntry("Beam Dose Point Depth", "BeamDosePointDepth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0089), ElementsDictionaryEntry("Beam Dose Point Equivalent Depth", "BeamDosePointEquivalentDepth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x008a), ElementsDictionaryEntry("Beam Dose Point SSD", "BeamDosePointSSD",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x008b), ElementsDictionaryEntry("Beam Dose Meaning", "BeamDoseMeaning",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x008c), ElementsDictionaryEntry("Beam Dose Verification Control Point Sequence", "BeamDoseVerificationControlPointSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x008d), ElementsDictionaryEntry("Average Beam Dose Point Depth", "AverageBeamDosePointDepth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x008e), ElementsDictionaryEntry("Average Beam Dose Point Equivalent Depth", "AverageBeamDosePointEquivalentDepth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x008f), ElementsDictionaryEntry("Average Beam Dose Point SSD", "AverageBeamDosePointSSD",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0090), ElementsDictionaryEntry("Beam Dose Type", "BeamDoseType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0091), ElementsDictionaryEntry("Alternate Beam Dose", "AlternateBeamDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0092), ElementsDictionaryEntry("Alternate Beam Dose Type", "AlternateBeamDoseType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0093), ElementsDictionaryEntry("Depth Value Averaging Flag", "DepthValueAveragingFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0094), ElementsDictionaryEntry("Beam Dose Point Source to External Contour Distance", "BeamDosePointSourceToExternalContourDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00a0), ElementsDictionaryEntry("Number of Brachy Application Setups", "NumberOfBrachyApplicationSetups",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00a2), ElementsDictionaryEntry("Brachy Application Setup Dose Specification Point", "BrachyApplicationSetupDoseSpecificationPoint",  "DS", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x00a4), ElementsDictionaryEntry("Brachy Application Setup Dose", "BrachyApplicationSetupDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00b0), ElementsDictionaryEntry("Beam Sequence", "BeamSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00b2), ElementsDictionaryEntry("Treatment Machine Name", "TreatmentMachineName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00b3), ElementsDictionaryEntry("Primary Dosimeter Unit", "PrimaryDosimeterUnit",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00b4), ElementsDictionaryEntry("Source-Axis Distance", "SourceAxisDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00b6), ElementsDictionaryEntry("Beam Limiting Device Sequence", "BeamLimitingDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00b8), ElementsDictionaryEntry("RT Beam Limiting Device Type", "RTBeamLimitingDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00ba), ElementsDictionaryEntry("Source to Beam Limiting Device Distance", "SourceToBeamLimitingDeviceDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00bb), ElementsDictionaryEntry("Isocenter to Beam Limiting Device Distance", "IsocenterToBeamLimitingDeviceDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00bc), ElementsDictionaryEntry("Number of Leaf/Jaw Pairs", "NumberOfLeafJawPairs",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00be), ElementsDictionaryEntry("Leaf Position Boundaries", "LeafPositionBoundaries",  "DS", "3-n"));
    public_dictionary.emplace(Tag(0x300a, 0x00c0), ElementsDictionaryEntry("Beam Number", "BeamNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00c2), ElementsDictionaryEntry("Beam Name", "BeamName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00c3), ElementsDictionaryEntry("Beam Description", "BeamDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00c4), ElementsDictionaryEntry("Beam Type", "BeamType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00c5), ElementsDictionaryEntry("Beam Delivery Duration Limit", "BeamDeliveryDurationLimit",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00c6), ElementsDictionaryEntry("Radiation Type", "RadiationType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00c7), ElementsDictionaryEntry("High-Dose Technique Type", "HighDoseTechniqueType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00c8), ElementsDictionaryEntry("Reference Image Number", "ReferenceImageNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00ca), ElementsDictionaryEntry("Planned Verification Image Sequence", "PlannedVerificationImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00cc), ElementsDictionaryEntry("Imaging Device-Specific Acquisition Parameters", "ImagingDeviceSpecificAcquisitionParameters",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x00ce), ElementsDictionaryEntry("Treatment Delivery Type", "TreatmentDeliveryType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d0), ElementsDictionaryEntry("Number of Wedges", "NumberOfWedges",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d1), ElementsDictionaryEntry("Wedge Sequence", "WedgeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d2), ElementsDictionaryEntry("Wedge Number", "WedgeNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d3), ElementsDictionaryEntry("Wedge Type", "WedgeType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d4), ElementsDictionaryEntry("Wedge ID", "WedgeID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d5), ElementsDictionaryEntry("Wedge Angle", "WedgeAngle",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d6), ElementsDictionaryEntry("Wedge Factor", "WedgeFactor",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d7), ElementsDictionaryEntry("Total Wedge Tray Water-Equivalent Thickness", "TotalWedgeTrayWaterEquivalentThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d8), ElementsDictionaryEntry("Wedge Orientation", "WedgeOrientation",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00d9), ElementsDictionaryEntry("Isocenter to Wedge Tray Distance", "IsocenterToWedgeTrayDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00da), ElementsDictionaryEntry("Source to Wedge Tray Distance", "SourceToWedgeTrayDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00db), ElementsDictionaryEntry("Wedge Thin Edge Position", "WedgeThinEdgePosition",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00dc), ElementsDictionaryEntry("Bolus ID", "BolusID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00dd), ElementsDictionaryEntry("Bolus Description", "BolusDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00de), ElementsDictionaryEntry("Effective Wedge Angle", "EffectiveWedgeAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e0), ElementsDictionaryEntry("Number of Compensators", "NumberOfCompensators",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e1), ElementsDictionaryEntry("Material ID", "MaterialID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e2), ElementsDictionaryEntry("Total Compensator Tray Factor", "TotalCompensatorTrayFactor",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e3), ElementsDictionaryEntry("Compensator Sequence", "CompensatorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e4), ElementsDictionaryEntry("Compensator Number", "CompensatorNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e5), ElementsDictionaryEntry("Compensator ID", "CompensatorID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e6), ElementsDictionaryEntry("Source to Compensator Tray Distance", "SourceToCompensatorTrayDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e7), ElementsDictionaryEntry("Compensator Rows", "CompensatorRows",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e8), ElementsDictionaryEntry("Compensator Columns", "CompensatorColumns",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00e9), ElementsDictionaryEntry("Compensator Pixel Spacing", "CompensatorPixelSpacing",  "DS", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x00ea), ElementsDictionaryEntry("Compensator Position", "CompensatorPosition",  "DS", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x00eb), ElementsDictionaryEntry("Compensator Transmission Data", "CompensatorTransmissionData",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x00ec), ElementsDictionaryEntry("Compensator Thickness Data", "CompensatorThicknessData",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x00ed), ElementsDictionaryEntry("Number of Boli", "NumberOfBoli",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00ee), ElementsDictionaryEntry("Compensator Type", "CompensatorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00ef), ElementsDictionaryEntry("Compensator Tray ID", "CompensatorTrayID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f0), ElementsDictionaryEntry("Number of Blocks", "NumberOfBlocks",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f2), ElementsDictionaryEntry("Total Block Tray Factor", "TotalBlockTrayFactor",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f3), ElementsDictionaryEntry("Total Block Tray Water-Equivalent Thickness", "TotalBlockTrayWaterEquivalentThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f4), ElementsDictionaryEntry("Block Sequence", "BlockSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f5), ElementsDictionaryEntry("Block Tray ID", "BlockTrayID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f6), ElementsDictionaryEntry("Source to Block Tray Distance", "SourceToBlockTrayDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f7), ElementsDictionaryEntry("Isocenter to Block Tray Distance", "IsocenterToBlockTrayDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f8), ElementsDictionaryEntry("Block Type", "BlockType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00f9), ElementsDictionaryEntry("Accessory Code", "AccessoryCode",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00fa), ElementsDictionaryEntry("Block Divergence", "BlockDivergence",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00fb), ElementsDictionaryEntry("Block Mounting Position", "BlockMountingPosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00fc), ElementsDictionaryEntry("Block Number", "BlockNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x00fe), ElementsDictionaryEntry("Block Name", "BlockName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0100), ElementsDictionaryEntry("Block Thickness", "BlockThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0102), ElementsDictionaryEntry("Block Transmission", "BlockTransmission",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0104), ElementsDictionaryEntry("Block Number of Points", "BlockNumberOfPoints",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0106), ElementsDictionaryEntry("Block Data", "BlockData",  "DS", "2-2n"));
    public_dictionary.emplace(Tag(0x300a, 0x0107), ElementsDictionaryEntry("Applicator Sequence", "ApplicatorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0108), ElementsDictionaryEntry("Applicator ID", "ApplicatorID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0109), ElementsDictionaryEntry("Applicator Type", "ApplicatorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x010a), ElementsDictionaryEntry("Applicator Description", "ApplicatorDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x010c), ElementsDictionaryEntry("Cumulative Dose Reference Coefficient", "CumulativeDoseReferenceCoefficient",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x010e), ElementsDictionaryEntry("Final Cumulative Meterset Weight", "FinalCumulativeMetersetWeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0110), ElementsDictionaryEntry("Number of Control Points", "NumberOfControlPoints",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0111), ElementsDictionaryEntry("Control Point Sequence", "ControlPointSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0112), ElementsDictionaryEntry("Control Point Index", "ControlPointIndex",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0114), ElementsDictionaryEntry("Nominal Beam Energy", "NominalBeamEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0115), ElementsDictionaryEntry("Dose Rate Set", "DoseRateSet",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0116), ElementsDictionaryEntry("Wedge Position Sequence", "WedgePositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0118), ElementsDictionaryEntry("Wedge Position", "WedgePosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x011a), ElementsDictionaryEntry("Beam Limiting Device Position Sequence", "BeamLimitingDevicePositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x011c), ElementsDictionaryEntry("Leaf/Jaw Positions", "LeafJawPositions",  "DS", "2-2n"));
    public_dictionary.emplace(Tag(0x300a, 0x011e), ElementsDictionaryEntry("Gantry Angle", "GantryAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x011f), ElementsDictionaryEntry("Gantry Rotation Direction", "GantryRotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0120), ElementsDictionaryEntry("Beam Limiting Device Angle", "BeamLimitingDeviceAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0121), ElementsDictionaryEntry("Beam Limiting Device Rotation Direction", "BeamLimitingDeviceRotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0122), ElementsDictionaryEntry("Patient Support Angle", "PatientSupportAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0123), ElementsDictionaryEntry("Patient Support Rotation Direction", "PatientSupportRotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0124), ElementsDictionaryEntry("Table Top Eccentric Axis Distance", "TableTopEccentricAxisDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0125), ElementsDictionaryEntry("Table Top Eccentric Angle", "TableTopEccentricAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0126), ElementsDictionaryEntry("Table Top Eccentric Rotation Direction", "TableTopEccentricRotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0128), ElementsDictionaryEntry("Table Top Vertical Position", "TableTopVerticalPosition",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0129), ElementsDictionaryEntry("Table Top Longitudinal Position", "TableTopLongitudinalPosition",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x012a), ElementsDictionaryEntry("Table Top Lateral Position", "TableTopLateralPosition",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x012c), ElementsDictionaryEntry("Isocenter Position", "IsocenterPosition",  "DS", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x012e), ElementsDictionaryEntry("Surface Entry Point", "SurfaceEntryPoint",  "DS", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x0130), ElementsDictionaryEntry("Source to Surface Distance", "SourceToSurfaceDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0131), ElementsDictionaryEntry("Average Beam Dose Point Source to External Contour Distance", "AverageBeamDosePointSourceToExternalContourDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0132), ElementsDictionaryEntry("Source to External Contour Distance", "SourceToExternalContourDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0133), ElementsDictionaryEntry("External Contour Entry Point", "ExternalContourEntryPoint",  "FL", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x0134), ElementsDictionaryEntry("Cumulative Meterset Weight", "CumulativeMetersetWeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0140), ElementsDictionaryEntry("Table Top Pitch Angle", "TableTopPitchAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0142), ElementsDictionaryEntry("Table Top Pitch Rotation Direction", "TableTopPitchRotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0144), ElementsDictionaryEntry("Table Top Roll Angle", "TableTopRollAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0146), ElementsDictionaryEntry("Table Top Roll Rotation Direction", "TableTopRollRotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0148), ElementsDictionaryEntry("Head Fixation Angle", "HeadFixationAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x014a), ElementsDictionaryEntry("Gantry Pitch Angle", "GantryPitchAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x014c), ElementsDictionaryEntry("Gantry Pitch Rotation Direction", "GantryPitchRotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x014e), ElementsDictionaryEntry("Gantry Pitch Angle Tolerance", "GantryPitchAngleTolerance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0150), ElementsDictionaryEntry("Fixation Eye", "FixationEye",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0151), ElementsDictionaryEntry("Chair Head Frame Position", "ChairHeadFramePosition",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0152), ElementsDictionaryEntry("Head Fixation Angle Tolerance", "HeadFixationAngleTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0153), ElementsDictionaryEntry("Chair Head Frame Position Tolerance", "ChairHeadFramePositionTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0154), ElementsDictionaryEntry("Fixation Light Azimuthal Angle Tolerance", "FixationLightAzimuthalAngleTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0155), ElementsDictionaryEntry("Fixation Light Polar Angle Tolerance", "FixationLightPolarAngleTolerance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0180), ElementsDictionaryEntry("Patient Setup Sequence", "PatientSetupSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0182), ElementsDictionaryEntry("Patient Setup Number", "PatientSetupNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0183), ElementsDictionaryEntry("Patient Setup Label", "PatientSetupLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0184), ElementsDictionaryEntry("Patient Additional Position", "PatientAdditionalPosition",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0190), ElementsDictionaryEntry("Fixation Device Sequence", "FixationDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0192), ElementsDictionaryEntry("Fixation Device Type", "FixationDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0194), ElementsDictionaryEntry("Fixation Device Label", "FixationDeviceLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0196), ElementsDictionaryEntry("Fixation Device Description", "FixationDeviceDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0198), ElementsDictionaryEntry("Fixation Device Position", "FixationDevicePosition",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0199), ElementsDictionaryEntry("Fixation Device Pitch Angle", "FixationDevicePitchAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x019a), ElementsDictionaryEntry("Fixation Device Roll Angle", "FixationDeviceRollAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01a0), ElementsDictionaryEntry("Shielding Device Sequence", "ShieldingDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01a2), ElementsDictionaryEntry("Shielding Device Type", "ShieldingDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01a4), ElementsDictionaryEntry("Shielding Device Label", "ShieldingDeviceLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01a6), ElementsDictionaryEntry("Shielding Device Description", "ShieldingDeviceDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01a8), ElementsDictionaryEntry("Shielding Device Position", "ShieldingDevicePosition",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01b0), ElementsDictionaryEntry("Setup Technique", "SetupTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01b2), ElementsDictionaryEntry("Setup Technique Description", "SetupTechniqueDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01b4), ElementsDictionaryEntry("Setup Device Sequence", "SetupDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01b6), ElementsDictionaryEntry("Setup Device Type", "SetupDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01b8), ElementsDictionaryEntry("Setup Device Label", "SetupDeviceLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01ba), ElementsDictionaryEntry("Setup Device Description", "SetupDeviceDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01bc), ElementsDictionaryEntry("Setup Device Parameter", "SetupDeviceParameter",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01d0), ElementsDictionaryEntry("Setup Reference Description", "SetupReferenceDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01d2), ElementsDictionaryEntry("Table Top Vertical Setup Displacement", "TableTopVerticalSetupDisplacement",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01d4), ElementsDictionaryEntry("Table Top Longitudinal Setup Displacement", "TableTopLongitudinalSetupDisplacement",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x01d6), ElementsDictionaryEntry("Table Top Lateral Setup Displacement", "TableTopLateralSetupDisplacement",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0200), ElementsDictionaryEntry("Brachy Treatment Technique", "BrachyTreatmentTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0202), ElementsDictionaryEntry("Brachy Treatment Type", "BrachyTreatmentType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0206), ElementsDictionaryEntry("Treatment Machine Sequence", "TreatmentMachineSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0210), ElementsDictionaryEntry("Source Sequence", "SourceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0212), ElementsDictionaryEntry("Source Number", "SourceNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0214), ElementsDictionaryEntry("Source Type", "SourceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0216), ElementsDictionaryEntry("Source Manufacturer", "SourceManufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0218), ElementsDictionaryEntry("Active Source Diameter", "ActiveSourceDiameter",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x021a), ElementsDictionaryEntry("Active Source Length", "ActiveSourceLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x021b), ElementsDictionaryEntry("Source Model ID", "SourceModelID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x021c), ElementsDictionaryEntry("Source Description", "SourceDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0222), ElementsDictionaryEntry("Source Encapsulation Nominal Thickness", "SourceEncapsulationNominalThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0224), ElementsDictionaryEntry("Source Encapsulation Nominal Transmission", "SourceEncapsulationNominalTransmission",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0226), ElementsDictionaryEntry("Source Isotope Name", "SourceIsotopeName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0228), ElementsDictionaryEntry("Source Isotope Half Life", "SourceIsotopeHalfLife",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0229), ElementsDictionaryEntry("Source Strength Units", "SourceStrengthUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x022a), ElementsDictionaryEntry("Reference Air Kerma Rate", "ReferenceAirKermaRate",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x022b), ElementsDictionaryEntry("Source Strength", "SourceStrength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x022c), ElementsDictionaryEntry("Source Strength Reference Date", "SourceStrengthReferenceDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x022e), ElementsDictionaryEntry("Source Strength Reference Time", "SourceStrengthReferenceTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0230), ElementsDictionaryEntry("Application Setup Sequence", "ApplicationSetupSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0232), ElementsDictionaryEntry("Application Setup Type", "ApplicationSetupType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0234), ElementsDictionaryEntry("Application Setup Number", "ApplicationSetupNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0236), ElementsDictionaryEntry("Application Setup Name", "ApplicationSetupName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0238), ElementsDictionaryEntry("Application Setup Manufacturer", "ApplicationSetupManufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0240), ElementsDictionaryEntry("Template Number", "TemplateNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0242), ElementsDictionaryEntry("Template Type", "TemplateType",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0244), ElementsDictionaryEntry("Template Name", "TemplateName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0250), ElementsDictionaryEntry("Total Reference Air Kerma", "TotalReferenceAirKerma",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0260), ElementsDictionaryEntry("Brachy Accessory Device Sequence", "BrachyAccessoryDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0262), ElementsDictionaryEntry("Brachy Accessory Device Number", "BrachyAccessoryDeviceNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0263), ElementsDictionaryEntry("Brachy Accessory Device ID", "BrachyAccessoryDeviceID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0264), ElementsDictionaryEntry("Brachy Accessory Device Type", "BrachyAccessoryDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0266), ElementsDictionaryEntry("Brachy Accessory Device Name", "BrachyAccessoryDeviceName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x026a), ElementsDictionaryEntry("Brachy Accessory Device Nominal Thickness", "BrachyAccessoryDeviceNominalThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x026c), ElementsDictionaryEntry("Brachy Accessory Device Nominal Transmission", "BrachyAccessoryDeviceNominalTransmission",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0271), ElementsDictionaryEntry("Channel Effective Length", "ChannelEffectiveLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0272), ElementsDictionaryEntry("Channel Inner Length", "ChannelInnerLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0273), ElementsDictionaryEntry("Afterloader Channel ID", "AfterloaderChannelID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0274), ElementsDictionaryEntry("Source Applicator Tip Length", "SourceApplicatorTipLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0280), ElementsDictionaryEntry("Channel Sequence", "ChannelSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0282), ElementsDictionaryEntry("Channel Number", "ChannelNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0284), ElementsDictionaryEntry("Channel Length", "ChannelLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0286), ElementsDictionaryEntry("Channel Total Time", "ChannelTotalTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0288), ElementsDictionaryEntry("Source Movement Type", "SourceMovementType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x028a), ElementsDictionaryEntry("Number of Pulses", "NumberOfPulses",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x028c), ElementsDictionaryEntry("Pulse Repetition Interval", "PulseRepetitionInterval",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0290), ElementsDictionaryEntry("Source Applicator Number", "SourceApplicatorNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0291), ElementsDictionaryEntry("Source Applicator ID", "SourceApplicatorID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0292), ElementsDictionaryEntry("Source Applicator Type", "SourceApplicatorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0294), ElementsDictionaryEntry("Source Applicator Name", "SourceApplicatorName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0296), ElementsDictionaryEntry("Source Applicator Length", "SourceApplicatorLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0298), ElementsDictionaryEntry("Source Applicator Manufacturer", "SourceApplicatorManufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x029c), ElementsDictionaryEntry("Source Applicator Wall Nominal Thickness", "SourceApplicatorWallNominalThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x029e), ElementsDictionaryEntry("Source Applicator Wall Nominal Transmission", "SourceApplicatorWallNominalTransmission",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02a0), ElementsDictionaryEntry("Source Applicator Step Size", "SourceApplicatorStepSize",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02a1), ElementsDictionaryEntry("Applicator Shape Referenced ROI Number", "ApplicatorShapeReferencedROINumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02a2), ElementsDictionaryEntry("Transfer Tube Number", "TransferTubeNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02a4), ElementsDictionaryEntry("Transfer Tube Length", "TransferTubeLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02b0), ElementsDictionaryEntry("Channel Shield Sequence", "ChannelShieldSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02b2), ElementsDictionaryEntry("Channel Shield Number", "ChannelShieldNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02b3), ElementsDictionaryEntry("Channel Shield ID", "ChannelShieldID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02b4), ElementsDictionaryEntry("Channel Shield Name", "ChannelShieldName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02b8), ElementsDictionaryEntry("Channel Shield Nominal Thickness", "ChannelShieldNominalThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02ba), ElementsDictionaryEntry("Channel Shield Nominal Transmission", "ChannelShieldNominalTransmission",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02c8), ElementsDictionaryEntry("Final Cumulative Time Weight", "FinalCumulativeTimeWeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02d0), ElementsDictionaryEntry("Brachy Control Point Sequence", "BrachyControlPointSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02d2), ElementsDictionaryEntry("Control Point Relative Position", "ControlPointRelativePosition",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02d4), ElementsDictionaryEntry("Control Point 3D Position", "ControlPoint3DPosition",  "DS", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x02d6), ElementsDictionaryEntry("Cumulative Time Weight", "CumulativeTimeWeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02e0), ElementsDictionaryEntry("Compensator Divergence", "CompensatorDivergence",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02e1), ElementsDictionaryEntry("Compensator Mounting Position", "CompensatorMountingPosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02e2), ElementsDictionaryEntry("Source to Compensator Distance", "SourceToCompensatorDistance",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x02e3), ElementsDictionaryEntry("Total Compensator Tray Water-Equivalent Thickness", "TotalCompensatorTrayWaterEquivalentThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02e4), ElementsDictionaryEntry("Isocenter to Compensator Tray Distance", "IsocenterToCompensatorTrayDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02e5), ElementsDictionaryEntry("Compensator Column Offset", "CompensatorColumnOffset",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02e6), ElementsDictionaryEntry("Isocenter to Compensator Distances", "IsocenterToCompensatorDistances",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x02e7), ElementsDictionaryEntry("Compensator Relative Stopping Power Ratio", "CompensatorRelativeStoppingPowerRatio",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02e8), ElementsDictionaryEntry("Compensator Milling Tool Diameter", "CompensatorMillingToolDiameter",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02ea), ElementsDictionaryEntry("Ion Range Compensator Sequence", "IonRangeCompensatorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x02eb), ElementsDictionaryEntry("Compensator Description", "CompensatorDescription",  "LT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0302), ElementsDictionaryEntry("Radiation Mass Number", "RadiationMassNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0304), ElementsDictionaryEntry("Radiation Atomic Number", "RadiationAtomicNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0306), ElementsDictionaryEntry("Radiation Charge State", "RadiationChargeState",  "SS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0308), ElementsDictionaryEntry("Scan Mode", "ScanMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0309), ElementsDictionaryEntry("Modulated Scan Mode Type", "ModulatedScanModeType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x030a), ElementsDictionaryEntry("Virtual Source-Axis Distances", "VirtualSourceAxisDistances",  "FL", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x030c), ElementsDictionaryEntry("Snout Sequence", "SnoutSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x030d), ElementsDictionaryEntry("Snout Position", "SnoutPosition",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x030f), ElementsDictionaryEntry("Snout ID", "SnoutID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0312), ElementsDictionaryEntry("Number of Range Shifters", "NumberOfRangeShifters",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0314), ElementsDictionaryEntry("Range Shifter Sequence", "RangeShifterSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0316), ElementsDictionaryEntry("Range Shifter Number", "RangeShifterNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0318), ElementsDictionaryEntry("Range Shifter ID", "RangeShifterID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0320), ElementsDictionaryEntry("Range Shifter Type", "RangeShifterType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0322), ElementsDictionaryEntry("Range Shifter Description", "RangeShifterDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0330), ElementsDictionaryEntry("Number of Lateral Spreading Devices", "NumberOfLateralSpreadingDevices",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0332), ElementsDictionaryEntry("Lateral Spreading Device Sequence", "LateralSpreadingDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0334), ElementsDictionaryEntry("Lateral Spreading Device Number", "LateralSpreadingDeviceNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0336), ElementsDictionaryEntry("Lateral Spreading Device ID", "LateralSpreadingDeviceID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0338), ElementsDictionaryEntry("Lateral Spreading Device Type", "LateralSpreadingDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x033a), ElementsDictionaryEntry("Lateral Spreading Device Description", "LateralSpreadingDeviceDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x033c), ElementsDictionaryEntry("Lateral Spreading Device Water Equivalent Thickness", "LateralSpreadingDeviceWaterEquivalentThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0340), ElementsDictionaryEntry("Number of Range Modulators", "NumberOfRangeModulators",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0342), ElementsDictionaryEntry("Range Modulator Sequence", "RangeModulatorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0344), ElementsDictionaryEntry("Range Modulator Number", "RangeModulatorNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0346), ElementsDictionaryEntry("Range Modulator ID", "RangeModulatorID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0348), ElementsDictionaryEntry("Range Modulator Type", "RangeModulatorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x034a), ElementsDictionaryEntry("Range Modulator Description", "RangeModulatorDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x034c), ElementsDictionaryEntry("Beam Current Modulation ID", "BeamCurrentModulationID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0350), ElementsDictionaryEntry("Patient Support Type", "PatientSupportType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0352), ElementsDictionaryEntry("Patient Support ID", "PatientSupportID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0354), ElementsDictionaryEntry("Patient Support Accessory Code", "PatientSupportAccessoryCode",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0355), ElementsDictionaryEntry("Tray Accessory Code", "TrayAccessoryCode",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0356), ElementsDictionaryEntry("Fixation Light Azimuthal Angle", "FixationLightAzimuthalAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0358), ElementsDictionaryEntry("Fixation Light Polar Angle", "FixationLightPolarAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x035a), ElementsDictionaryEntry("Meterset Rate", "MetersetRate",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0360), ElementsDictionaryEntry("Range Shifter Settings Sequence", "RangeShifterSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0362), ElementsDictionaryEntry("Range Shifter Setting", "RangeShifterSetting",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0364), ElementsDictionaryEntry("Isocenter to Range Shifter Distance", "IsocenterToRangeShifterDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0366), ElementsDictionaryEntry("Range Shifter Water Equivalent Thickness", "RangeShifterWaterEquivalentThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0370), ElementsDictionaryEntry("Lateral Spreading Device Settings Sequence", "LateralSpreadingDeviceSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0372), ElementsDictionaryEntry("Lateral Spreading Device Setting", "LateralSpreadingDeviceSetting",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0374), ElementsDictionaryEntry("Isocenter to Lateral Spreading Device Distance", "IsocenterToLateralSpreadingDeviceDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0380), ElementsDictionaryEntry("Range Modulator Settings Sequence", "RangeModulatorSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0382), ElementsDictionaryEntry("Range Modulator Gating Start Value", "RangeModulatorGatingStartValue",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0384), ElementsDictionaryEntry("Range Modulator Gating Stop Value", "RangeModulatorGatingStopValue",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0386), ElementsDictionaryEntry("Range Modulator Gating Start Water Equivalent Thickness", "RangeModulatorGatingStartWaterEquivalentThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0388), ElementsDictionaryEntry("Range Modulator Gating Stop Water Equivalent Thickness", "RangeModulatorGatingStopWaterEquivalentThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x038a), ElementsDictionaryEntry("Isocenter to Range Modulator Distance", "IsocenterToRangeModulatorDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x038f), ElementsDictionaryEntry("Scan Spot Time Offset", "ScanSpotTimeOffset",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x0390), ElementsDictionaryEntry("Scan Spot Tune ID", "ScanSpotTuneID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0391), ElementsDictionaryEntry("Scan Spot Prescribed Indices", "ScanSpotPrescribedIndices",  "IS", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x0392), ElementsDictionaryEntry("Number of Scan Spot Positions", "NumberOfScanSpotPositions",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0393), ElementsDictionaryEntry("Scan Spot Reordered", "ScanSpotReordered",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0394), ElementsDictionaryEntry("Scan Spot Position Map", "ScanSpotPositionMap",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x0395), ElementsDictionaryEntry("Scan Spot Reordering Allowed", "ScanSpotReorderingAllowed",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0396), ElementsDictionaryEntry("Scan Spot Meterset Weights", "ScanSpotMetersetWeights",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x0398), ElementsDictionaryEntry("Scanning Spot Size", "ScanningSpotSize",  "FL", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x0399), ElementsDictionaryEntry("Scan Spot Sizes Delivered", "ScanSpotSizesDelivered",  "FL", "2-2n"));
    public_dictionary.emplace(Tag(0x300a, 0x039a), ElementsDictionaryEntry("Number of Paintings", "NumberOfPaintings",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x03a0), ElementsDictionaryEntry("Ion Tolerance Table Sequence", "IonToleranceTableSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x03a2), ElementsDictionaryEntry("Ion Beam Sequence", "IonBeamSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x03a4), ElementsDictionaryEntry("Ion Beam Limiting Device Sequence", "IonBeamLimitingDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x03a6), ElementsDictionaryEntry("Ion Block Sequence", "IonBlockSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x03a8), ElementsDictionaryEntry("Ion Control Point Sequence", "IonControlPointSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x03aa), ElementsDictionaryEntry("Ion Wedge Sequence", "IonWedgeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x03ac), ElementsDictionaryEntry("Ion Wedge Position Sequence", "IonWedgePositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0401), ElementsDictionaryEntry("Referenced Setup Image Sequence", "ReferencedSetupImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0402), ElementsDictionaryEntry("Setup Image Comment", "SetupImageComment",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0410), ElementsDictionaryEntry("Motion Synchronization Sequence", "MotionSynchronizationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0412), ElementsDictionaryEntry("Control Point Orientation", "ControlPointOrientation",  "FL", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x0420), ElementsDictionaryEntry("General Accessory Sequence", "GeneralAccessorySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0421), ElementsDictionaryEntry("General Accessory ID", "GeneralAccessoryID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0422), ElementsDictionaryEntry("General Accessory Description", "GeneralAccessoryDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0423), ElementsDictionaryEntry("General Accessory Type", "GeneralAccessoryType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0424), ElementsDictionaryEntry("General Accessory Number", "GeneralAccessoryNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0425), ElementsDictionaryEntry("Source to General Accessory Distance", "SourceToGeneralAccessoryDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0426), ElementsDictionaryEntry("Isocenter to General Accessory Distance", "IsocenterToGeneralAccessoryDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0431), ElementsDictionaryEntry("Applicator Geometry Sequence", "ApplicatorGeometrySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0432), ElementsDictionaryEntry("Applicator Aperture Shape", "ApplicatorApertureShape",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0433), ElementsDictionaryEntry("Applicator Opening", "ApplicatorOpening",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0434), ElementsDictionaryEntry("Applicator Opening X", "ApplicatorOpeningX",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0435), ElementsDictionaryEntry("Applicator Opening Y", "ApplicatorOpeningY",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0436), ElementsDictionaryEntry("Source to Applicator Mounting Position Distance", "SourceToApplicatorMountingPositionDistance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0440), ElementsDictionaryEntry("Number of Block Slab Items", "NumberOfBlockSlabItems",  "IS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0441), ElementsDictionaryEntry("Block Slab Sequence", "BlockSlabSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0442), ElementsDictionaryEntry("Block Slab Thickness", "BlockSlabThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0443), ElementsDictionaryEntry("Block Slab Number", "BlockSlabNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0450), ElementsDictionaryEntry("Device Motion Control Sequence", "DeviceMotionControlSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0451), ElementsDictionaryEntry("Device Motion Execution Mode", "DeviceMotionExecutionMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0452), ElementsDictionaryEntry("Device Motion Observation Mode", "DeviceMotionObservationMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0453), ElementsDictionaryEntry("Device Motion Parameter Code Sequence", "DeviceMotionParameterCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0501), ElementsDictionaryEntry("Distal Depth Fraction", "DistalDepthFraction",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0502), ElementsDictionaryEntry("Distal Depth", "DistalDepth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0503), ElementsDictionaryEntry("Nominal Range Modulation Fractions", "NominalRangeModulationFractions",  "FL", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x0504), ElementsDictionaryEntry("Nominal Range Modulated Region Depths", "NominalRangeModulatedRegionDepths",  "FL", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x0505), ElementsDictionaryEntry("Depth Dose Parameters Sequence", "DepthDoseParametersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0506), ElementsDictionaryEntry("Delivered Depth Dose Parameters Sequence", "DeliveredDepthDoseParametersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0507), ElementsDictionaryEntry("Delivered Distal Depth Fraction", "DeliveredDistalDepthFraction",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0508), ElementsDictionaryEntry("Delivered Distal Depth", "DeliveredDistalDepth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0509), ElementsDictionaryEntry("Delivered Nominal Range Modulation Fractions", "DeliveredNominalRangeModulationFractions",  "FL", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x0510), ElementsDictionaryEntry("Delivered Nominal Range Modulated Region Depths", "DeliveredNominalRangeModulatedRegionDepths",  "FL", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x0511), ElementsDictionaryEntry("Delivered Reference Dose Definition", "DeliveredReferenceDoseDefinition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0512), ElementsDictionaryEntry("Reference Dose Definition", "ReferenceDoseDefinition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0600), ElementsDictionaryEntry("RT Control Point Index", "RTControlPointIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0601), ElementsDictionaryEntry("Radiation Generation Mode Index", "RadiationGenerationModeIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0602), ElementsDictionaryEntry("Referenced Defined Device Index", "ReferencedDefinedDeviceIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0603), ElementsDictionaryEntry("Radiation Dose Identification Index", "RadiationDoseIdentificationIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0604), ElementsDictionaryEntry("Number of RT Control Points", "NumberOfRTControlPoints",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0605), ElementsDictionaryEntry("Referenced Radiation Generation Mode Index", "ReferencedRadiationGenerationModeIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0606), ElementsDictionaryEntry("Treatment Position Index", "TreatmentPositionIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0607), ElementsDictionaryEntry("Referenced Device Index", "ReferencedDeviceIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0608), ElementsDictionaryEntry("Treatment Position Group Label", "TreatmentPositionGroupLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0609), ElementsDictionaryEntry("Treatment Position Group UID", "TreatmentPositionGroupUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x060a), ElementsDictionaryEntry("Treatment Position Group Sequence", "TreatmentPositionGroupSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x060b), ElementsDictionaryEntry("Referenced Treatment Position Index", "ReferencedTreatmentPositionIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x060c), ElementsDictionaryEntry("Referenced Radiation Dose Identification Index", "ReferencedRadiationDoseIdentificationIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x060d), ElementsDictionaryEntry("RT Accessory Holder Water-Equivalent Thickness", "RTAccessoryHolderWaterEquivalentThickness",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x060e), ElementsDictionaryEntry("Referenced RT Accessory Holder Device Index", "ReferencedRTAccessoryHolderDeviceIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x060f), ElementsDictionaryEntry("RT Accessory Holder Slot Existence Flag", "RTAccessoryHolderSlotExistenceFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0610), ElementsDictionaryEntry("RT Accessory Holder Slot Sequence", "RTAccessoryHolderSlotSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0611), ElementsDictionaryEntry("RT Accessory Holder Slot ID", "RTAccessoryHolderSlotID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0612), ElementsDictionaryEntry("RT Accessory Holder Slot Distance", "RTAccessoryHolderSlotDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0613), ElementsDictionaryEntry("RT Accessory Slot Distance", "RTAccessorySlotDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0614), ElementsDictionaryEntry("RT Accessory Holder Definition Sequence", "RTAccessoryHolderDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0615), ElementsDictionaryEntry("RT Accessory Device Slot ID", "RTAccessoryDeviceSlotID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0616), ElementsDictionaryEntry("RT Radiation Sequence", "RTRadiationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0617), ElementsDictionaryEntry("Radiation Dose Sequence", "RadiationDoseSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0618), ElementsDictionaryEntry("Radiation Dose Identification Sequence", "RadiationDoseIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0619), ElementsDictionaryEntry("Radiation Dose Identification Label", "RadiationDoseIdentificationLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x061a), ElementsDictionaryEntry("Reference Dose Type", "ReferenceDoseType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x061b), ElementsDictionaryEntry("Primary Dose Value Indicator", "PrimaryDoseValueIndicator",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x061c), ElementsDictionaryEntry("Dose Values Sequence", "DoseValuesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x061d), ElementsDictionaryEntry("Dose Value Purpose", "DoseValuePurpose",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x061e), ElementsDictionaryEntry("Reference Dose Point Coordinates", "ReferenceDosePointCoordinates",  "FD", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x061f), ElementsDictionaryEntry("Radiation Dose Values Parameters Sequence", "RadiationDoseValuesParametersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0620), ElementsDictionaryEntry("Meterset to Dose Mapping Sequence", "MetersetToDoseMappingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0621), ElementsDictionaryEntry("Expected In-Vivo Measurement Values Sequence", "ExpectedInVivoMeasurementValuesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0622), ElementsDictionaryEntry("Expected In-Vivo Measurement Value Index", "ExpectedInVivoMeasurementValueIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0623), ElementsDictionaryEntry("Radiation Dose In-Vivo Measurement Label", "RadiationDoseInVivoMeasurementLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0624), ElementsDictionaryEntry("Radiation Dose Central Axis Displacement", "RadiationDoseCentralAxisDisplacement",  "FD", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x0625), ElementsDictionaryEntry("Radiation Dose Value", "RadiationDoseValue",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0626), ElementsDictionaryEntry("Radiation Dose Source to Skin Distance", "RadiationDoseSourceToSkinDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0627), ElementsDictionaryEntry("Radiation Dose Measurement Point Coordinates", "RadiationDoseMeasurementPointCoordinates",  "FD", "3"));
    public_dictionary.emplace(Tag(0x300a, 0x0628), ElementsDictionaryEntry("Radiation Dose Source to External Contour Distance", "RadiationDoseSourceToExternalContourDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0629), ElementsDictionaryEntry("RT Tolerance Set Sequence", "RTToleranceSetSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x062a), ElementsDictionaryEntry("RT Tolerance Set Label", "RTToleranceSetLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x062b), ElementsDictionaryEntry("Attribute Tolerance Values Sequence", "AttributeToleranceValuesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x062c), ElementsDictionaryEntry("Tolerance Value", "ToleranceValue",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x062d), ElementsDictionaryEntry("Patient Support Position Tolerance Sequence", "PatientSupportPositionToleranceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x062e), ElementsDictionaryEntry("Treatment Time Limit", "TreatmentTimeLimit",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x062f), ElementsDictionaryEntry("C-Arm Photon-Electron Control Point Sequence", "CArmPhotonElectronControlPointSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0630), ElementsDictionaryEntry("Referenced RT Radiation Sequence", "ReferencedRTRadiationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0631), ElementsDictionaryEntry("Referenced RT Instance Sequence", "ReferencedRTInstanceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0632), ElementsDictionaryEntry("Referenced RT Patient Setup Sequence", "ReferencedRTPatientSetupSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0634), ElementsDictionaryEntry("Source to Patient Surface Distance", "SourceToPatientSurfaceDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0635), ElementsDictionaryEntry("Treatment Machine Special Mode Code Sequence", "TreatmentMachineSpecialModeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0636), ElementsDictionaryEntry("Intended Number of Fractions", "IntendedNumberOfFractions",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0637), ElementsDictionaryEntry("RT Radiation Set Intent", "RTRadiationSetIntent",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0638), ElementsDictionaryEntry("RT Radiation Physical and Geometric Content Detail Flag", "RTRadiationPhysicalAndGeometricContentDetailFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0639), ElementsDictionaryEntry("RT Record Flag", "RTRecordFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x063a), ElementsDictionaryEntry("Treatment Device Identification Sequence", "TreatmentDeviceIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x063b), ElementsDictionaryEntry("Referenced RT Physician Intent Sequence", "ReferencedRTPhysicianIntentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x063c), ElementsDictionaryEntry("Cumulative Meterset", "CumulativeMeterset",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x063d), ElementsDictionaryEntry("Delivery Rate", "DeliveryRate",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x063e), ElementsDictionaryEntry("Delivery Rate Unit Sequence", "DeliveryRateUnitSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x063f), ElementsDictionaryEntry("Treatment Position Sequence", "TreatmentPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0640), ElementsDictionaryEntry("Radiation Source-Axis Distance", "RadiationSourceAxisDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0641), ElementsDictionaryEntry("Number of RT Beam Limiting Devices", "NumberOfRTBeamLimitingDevices",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0642), ElementsDictionaryEntry("RT Beam Limiting Device Proximal Distance", "RTBeamLimitingDeviceProximalDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0643), ElementsDictionaryEntry("RT Beam Limiting Device Distal Distance", "RTBeamLimitingDeviceDistalDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0644), ElementsDictionaryEntry("Parallel RT Beam Delimiter Device Orientation Label Code Sequence", "ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0645), ElementsDictionaryEntry("Beam Modifier Orientation Angle", "BeamModifierOrientationAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0646), ElementsDictionaryEntry("Fixed RT Beam Delimiter Device Sequence", "FixedRTBeamDelimiterDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0647), ElementsDictionaryEntry("Parallel RT Beam Delimiter Device Sequence", "ParallelRTBeamDelimiterDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0648), ElementsDictionaryEntry("Number of Parallel RT Beam Delimiters", "NumberOfParallelRTBeamDelimiters",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0649), ElementsDictionaryEntry("Parallel RT Beam Delimiter Boundaries", "ParallelRTBeamDelimiterBoundaries",  "FD", "2-n"));
    public_dictionary.emplace(Tag(0x300a, 0x064a), ElementsDictionaryEntry("Parallel RT Beam Delimiter Positions", "ParallelRTBeamDelimiterPositions",  "FD", "2-n"));
    public_dictionary.emplace(Tag(0x300a, 0x064b), ElementsDictionaryEntry("RT Beam Limiting Device Offset", "RTBeamLimitingDeviceOffset",  "FD", "2"));
    public_dictionary.emplace(Tag(0x300a, 0x064c), ElementsDictionaryEntry("RT Beam Delimiter Geometry Sequence", "RTBeamDelimiterGeometrySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x064d), ElementsDictionaryEntry("RT Beam Limiting Device Definition Sequence", "RTBeamLimitingDeviceDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x064e), ElementsDictionaryEntry("Parallel RT Beam Delimiter Opening Mode", "ParallelRTBeamDelimiterOpeningMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x064f), ElementsDictionaryEntry("Parallel RT Beam Delimiter Leaf Mounting Side", "ParallelRTBeamDelimiterLeafMountingSide",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x300a, 0x0650), ElementsDictionaryEntry("Patient Setup UID", "PatientSetupUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0651), ElementsDictionaryEntry("Wedge Definition Sequence", "WedgeDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0652), ElementsDictionaryEntry("Radiation Beam Wedge Angle", "RadiationBeamWedgeAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0653), ElementsDictionaryEntry("Radiation Beam Wedge Thin Edge Distance", "RadiationBeamWedgeThinEdgeDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0654), ElementsDictionaryEntry("Radiation Beam Effective Wedge Angle", "RadiationBeamEffectiveWedgeAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0655), ElementsDictionaryEntry("Number of Wedge Positions", "NumberOfWedgePositions",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0656), ElementsDictionaryEntry("RT Beam Limiting Device Opening Sequence", "RTBeamLimitingDeviceOpeningSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0657), ElementsDictionaryEntry("Number of RT Beam Limiting Device Openings", "NumberOfRTBeamLimitingDeviceOpenings",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0658), ElementsDictionaryEntry("Radiation Dosimeter Unit Sequence", "RadiationDosimeterUnitSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0659), ElementsDictionaryEntry("RT Device Distance Reference Location Code Sequence", "RTDeviceDistanceReferenceLocationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x065a), ElementsDictionaryEntry("Radiation Device Configuration and Commissioning Key Sequence", "RadiationDeviceConfigurationAndCommissioningKeySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x065b), ElementsDictionaryEntry("Patient Support Position Parameter Sequence", "PatientSupportPositionParameterSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x065c), ElementsDictionaryEntry("Patient Support Position Specification Method", "PatientSupportPositionSpecificationMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x065d), ElementsDictionaryEntry("Patient Support Position Device Parameter Sequence", "PatientSupportPositionDeviceParameterSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x065e), ElementsDictionaryEntry("Device Order Index", "DeviceOrderIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x065f), ElementsDictionaryEntry("Patient Support Position Parameter Order Index", "PatientSupportPositionParameterOrderIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0660), ElementsDictionaryEntry("Patient Support Position Device Tolerance Sequence", "PatientSupportPositionDeviceToleranceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0661), ElementsDictionaryEntry("Patient Support Position Tolerance Order Index", "PatientSupportPositionToleranceOrderIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0662), ElementsDictionaryEntry("Compensator Definition Sequence", "CompensatorDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0663), ElementsDictionaryEntry("Compensator Map Orientation", "CompensatorMapOrientation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0664), ElementsDictionaryEntry("Compensator Proximal Thickness Map", "CompensatorProximalThicknessMap",  "OF", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0665), ElementsDictionaryEntry("Compensator Distal Thickness Map", "CompensatorDistalThicknessMap",  "OF", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0666), ElementsDictionaryEntry("Compensator Base Plane Offset", "CompensatorBasePlaneOffset",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0667), ElementsDictionaryEntry("Compensator Shape Fabrication Code Sequence", "CompensatorShapeFabricationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0668), ElementsDictionaryEntry("Compensator Shape Sequence", "CompensatorShapeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0669), ElementsDictionaryEntry("Radiation Beam Compensator Milling Tool Diameter", "RadiationBeamCompensatorMillingToolDiameter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x066a), ElementsDictionaryEntry("Block Definition Sequence", "BlockDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x066b), ElementsDictionaryEntry("Block Edge Data", "BlockEdgeData",  "OF", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x066c), ElementsDictionaryEntry("Block Orientation", "BlockOrientation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x066d), ElementsDictionaryEntry("Radiation Beam Block Thickness", "RadiationBeamBlockThickness",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x066e), ElementsDictionaryEntry("Radiation Beam Block Slab Thickness", "RadiationBeamBlockSlabThickness",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x066f), ElementsDictionaryEntry("Block Edge Data Sequence", "BlockEdgeDataSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0670), ElementsDictionaryEntry("Number of RT Accessory Holders", "NumberOfRTAccessoryHolders",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0671), ElementsDictionaryEntry("General Accessory Definition Sequence", "GeneralAccessoryDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0672), ElementsDictionaryEntry("Number of General Accessories", "NumberOfGeneralAccessories",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0673), ElementsDictionaryEntry("Bolus Definition Sequence", "BolusDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0674), ElementsDictionaryEntry("Number of Boluses", "NumberOfBoluses",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0675), ElementsDictionaryEntry("Equipment Frame of Reference UID", "EquipmentFrameOfReferenceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0676), ElementsDictionaryEntry("Equipment Frame of Reference Description", "EquipmentFrameOfReferenceDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0677), ElementsDictionaryEntry("Equipment Reference Point Coordinates Sequence", "EquipmentReferencePointCoordinatesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0678), ElementsDictionaryEntry("Equipment Reference Point Code Sequence", "EquipmentReferencePointCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0679), ElementsDictionaryEntry("RT Beam Limiting Device Angle", "RTBeamLimitingDeviceAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x067a), ElementsDictionaryEntry("Source Roll Angle", "SourceRollAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x067b), ElementsDictionaryEntry("Radiation GenerationMode Sequence", "RadiationGenerationModeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x067c), ElementsDictionaryEntry("Radiation GenerationMode Label", "RadiationGenerationModeLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x067d), ElementsDictionaryEntry("Radiation GenerationMode Description", "RadiationGenerationModeDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x067e), ElementsDictionaryEntry("Radiation GenerationMode Machine Code Sequence", "RadiationGenerationModeMachineCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x067f), ElementsDictionaryEntry("Radiation Type Code Sequence", "RadiationTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0680), ElementsDictionaryEntry("Nominal Energy", "NominalEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0681), ElementsDictionaryEntry("Minimum Nominal Energy", "MinimumNominalEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0682), ElementsDictionaryEntry("Maximum Nominal Energy", "MaximumNominalEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0683), ElementsDictionaryEntry("Radiation Fluence Modifier Code Sequence", "RadiationFluenceModifierCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0684), ElementsDictionaryEntry("Energy Unit Code Sequence", "EnergyUnitCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0685), ElementsDictionaryEntry("Number of Radiation GenerationModes", "NumberOfRadiationGenerationModes",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0686), ElementsDictionaryEntry("Patient Support Devices Sequence", "PatientSupportDevicesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0687), ElementsDictionaryEntry("Number of Patient Support Devices", "NumberOfPatientSupportDevices",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0688), ElementsDictionaryEntry("RT Beam Modifier Definition Distance", "RTBeamModifierDefinitionDistance",  "FD", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0689), ElementsDictionaryEntry("Beam Area Limit Sequence", "BeamAreaLimitSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x068a), ElementsDictionaryEntry("Referenced RT Prescription Sequence", "ReferencedRTPrescriptionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0700), ElementsDictionaryEntry("Treatment Session UID", "TreatmentSessionUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0701), ElementsDictionaryEntry("RT Radiation Usage", "RTRadiationUsage",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0702), ElementsDictionaryEntry("Referenced RT Radiation Set Sequence", "ReferencedRTRadiationSetSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0703), ElementsDictionaryEntry("Referenced RT Radiation Record Sequence", "ReferencedRTRadiationRecordSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0704), ElementsDictionaryEntry("RT Radiation Set Delivery Number", "RTRadiationSetDeliveryNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0705), ElementsDictionaryEntry("Clinical Fraction Number", "ClinicalFractionNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0706), ElementsDictionaryEntry("RT Treatment Fraction Completion Status", "RTTreatmentFractionCompletionStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0707), ElementsDictionaryEntry("RT Radiation Set Usage", "RTRadiationSetUsage",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0708), ElementsDictionaryEntry("Treatment Delivery Continuation Flag", "TreatmentDeliveryContinuationFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0709), ElementsDictionaryEntry("Treatment Record Content Origin", "TreatmentRecordContentOrigin",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0714), ElementsDictionaryEntry("RT Treatment Termination Status", "RTTreatmentTerminationStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0715), ElementsDictionaryEntry("RT Treatment Termination Reason Code Sequence", "RTTreatmentTerminationReasonCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0716), ElementsDictionaryEntry("Machine-Specific Treatment Termination Code Sequence", "MachineSpecificTreatmentTerminationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0722), ElementsDictionaryEntry("RT Radiation Salvage Record Control Point Sequence", "RTRadiationSalvageRecordControlPointSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0723), ElementsDictionaryEntry("Starting Meterset Value Known Flag", "StartingMetersetValueKnownFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0730), ElementsDictionaryEntry("Treatment Termination Description", "TreatmentTerminationDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0731), ElementsDictionaryEntry("Treatment Tolerance Violation Sequence", "TreatmentToleranceViolationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0732), ElementsDictionaryEntry("Treatment Tolerance Violation Category", "TreatmentToleranceViolationCategory",  "CS", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0733), ElementsDictionaryEntry("Treatment Tolerance Violation Attribute Sequence", "TreatmentToleranceViolationAttributeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0734), ElementsDictionaryEntry("Treatment Tolerance Violation Description", "TreatmentToleranceViolationDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0735), ElementsDictionaryEntry("Treatment Tolerance Violation Identification", "TreatmentToleranceViolationIdentification",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0736), ElementsDictionaryEntry("Treatment Tolerance Violation DateTime", "TreatmentToleranceViolationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x073a), ElementsDictionaryEntry("Recorded RT Control Point DateTime", "RecordedRTControlPointDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x073b), ElementsDictionaryEntry("Referenced Radiation RT Control Point Index", "ReferencedRadiationRTControlPointIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x073e), ElementsDictionaryEntry("Alternate Value Sequence", "AlternateValueSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x073f), ElementsDictionaryEntry("Confirmation Sequence", "ConfirmationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0740), ElementsDictionaryEntry("Interlock Sequence", "InterlockSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0741), ElementsDictionaryEntry("Interlock DateTime", "InterlockDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0742), ElementsDictionaryEntry("Interlock Description", "InterlockDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0743), ElementsDictionaryEntry("Interlock Originating Device Sequence", "InterlockOriginatingDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0744), ElementsDictionaryEntry("Interlock Code Sequence", "InterlockCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0745), ElementsDictionaryEntry("Interlock Resolution Code Sequence", "InterlockResolutionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0746), ElementsDictionaryEntry("Interlock Resolution User Sequence", "InterlockResolutionUserSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0760), ElementsDictionaryEntry("Override DateTime", "OverrideDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0761), ElementsDictionaryEntry("Treatment Tolerance Violation Type Code Sequence", "TreatmentToleranceViolationTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0762), ElementsDictionaryEntry("Treatment Tolerance Violation Cause Code Sequence", "TreatmentToleranceViolationCauseCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0772), ElementsDictionaryEntry("Measured Meterset to Dose Mapping Sequence", "MeasuredMetersetToDoseMappingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0773), ElementsDictionaryEntry("Referenced Expected In-Vivo Measurement Value Index", "ReferencedExpectedInVivoMeasurementValueIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0774), ElementsDictionaryEntry("Dose Measurement Device Code Sequence", "DoseMeasurementDeviceCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0780), ElementsDictionaryEntry("Additional Parameter Recording Instance Sequence", "AdditionalParameterRecordingInstanceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0783), ElementsDictionaryEntry("Interlock Origin Description", "InterlockOriginDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0784), ElementsDictionaryEntry("RT Patient Position Scope Sequence", "RTPatientPositionScopeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0785), ElementsDictionaryEntry("Referenced Treatment Position Group UID", "ReferencedTreatmentPositionGroupUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0786), ElementsDictionaryEntry("Radiation Order Index", "RadiationOrderIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0787), ElementsDictionaryEntry("Omitted Radiation Sequence", "OmittedRadiationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0788), ElementsDictionaryEntry("Reason for Omission Code Sequence", "ReasonForOmissionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0789), ElementsDictionaryEntry("RT Delivery Start Patient Position Sequence", "RTDeliveryStartPatientPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x078a), ElementsDictionaryEntry("RT Treatment Preparation Patient Position Sequence", "RTTreatmentPreparationPatientPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x078b), ElementsDictionaryEntry("Referenced RT Treatment Preparation Sequence", "ReferencedRTTreatmentPreparationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x078c), ElementsDictionaryEntry("Referenced Patient Setup Photo Sequence", "ReferencedPatientSetupPhotoSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x078d), ElementsDictionaryEntry("Patient Treatment Preparation Method Code Sequence", "PatientTreatmentPreparationMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x078e), ElementsDictionaryEntry("Patient Treatment Preparation Procedure Parameter Description", "PatientTreatmentPreparationProcedureParameterDescription",  "LT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x078f), ElementsDictionaryEntry("Patient Treatment Preparation Device Sequence", "PatientTreatmentPreparationDeviceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0790), ElementsDictionaryEntry("Patient Treatment Preparation Procedure Sequence", "PatientTreatmentPreparationProcedureSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0791), ElementsDictionaryEntry("Patient Treatment Preparation Procedure Code Sequence", "PatientTreatmentPreparationProcedureCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0792), ElementsDictionaryEntry("Patient Treatment Preparation Method Description", "PatientTreatmentPreparationMethodDescription",  "LT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0793), ElementsDictionaryEntry("Patient Treatment Preparation Procedure Parameter Sequence", "PatientTreatmentPreparationProcedureParameterSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0794), ElementsDictionaryEntry("Patient Setup Photo Description", "PatientSetupPhotoDescription",  "LT", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0795), ElementsDictionaryEntry("Patient Treatment Preparation Procedure Index", "PatientTreatmentPreparationProcedureIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0796), ElementsDictionaryEntry("Referenced Patient Setup Procedure Index", "ReferencedPatientSetupProcedureIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0797), ElementsDictionaryEntry("RT Radiation Task Sequence", "RTRadiationTaskSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0798), ElementsDictionaryEntry("RT Patient Position Displacement Sequence", "RTPatientPositionDisplacementSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x0799), ElementsDictionaryEntry("RT Patient Position Sequence", "RTPatientPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x079a), ElementsDictionaryEntry("Displacement Reference Label", "DisplacementReferenceLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x079b), ElementsDictionaryEntry("Displacement Matrix", "DisplacementMatrix",  "FD", "16"));
    public_dictionary.emplace(Tag(0x300a, 0x079c), ElementsDictionaryEntry("Patient Support Displacement Sequence", "PatientSupportDisplacementSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x079d), ElementsDictionaryEntry("Displacement Reference Location Code Sequence", "DisplacementReferenceLocationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x300a, 0x079e), ElementsDictionaryEntry("RT Radiation Set Delivery Usage", "RTRadiationSetDeliveryUsage",  "CS", "1"));

    public_tags.emplace("RTPlanLabel", Tag(0x300a, 0x0002));
    public_tags.emplace("RTPlanName", Tag(0x300a, 0x0003));
    public_tags.emplace("RTPlanDescription", Tag(0x300a, 0x0004));
    public_tags.emplace("RTPlanDate", Tag(0x300a, 0x0006));
    public_tags.emplace("RTPlanTime", Tag(0x300a, 0x0007));
    public_tags.emplace("TreatmentProtocols", Tag(0x300a, 0x0009));
    public_tags.emplace("PlanIntent", Tag(0x300a, 0x000a));
    public_tags.emplace("TreatmentSites", Tag(0x300a, 0x000b));
    public_tags.emplace("RTPlanGeometry", Tag(0x300a, 0x000c));
    public_tags.emplace("PrescriptionDescription", Tag(0x300a, 0x000e));
    public_tags.emplace("DoseReferenceSequence", Tag(0x300a, 0x0010));
    public_tags.emplace("DoseReferenceNumber", Tag(0x300a, 0x0012));
    public_tags.emplace("DoseReferenceUID", Tag(0x300a, 0x0013));
    public_tags.emplace("DoseReferenceStructureType", Tag(0x300a, 0x0014));
    public_tags.emplace("NominalBeamEnergyUnit", Tag(0x300a, 0x0015));
    public_tags.emplace("DoseReferenceDescription", Tag(0x300a, 0x0016));
    public_tags.emplace("DoseReferencePointCoordinates", Tag(0x300a, 0x0018));
    public_tags.emplace("NominalPriorDose", Tag(0x300a, 0x001a));
    public_tags.emplace("DoseReferenceType", Tag(0x300a, 0x0020));
    public_tags.emplace("ConstraintWeight", Tag(0x300a, 0x0021));
    public_tags.emplace("DeliveryWarningDose", Tag(0x300a, 0x0022));
    public_tags.emplace("DeliveryMaximumDose", Tag(0x300a, 0x0023));
    public_tags.emplace("TargetMinimumDose", Tag(0x300a, 0x0025));
    public_tags.emplace("TargetPrescriptionDose", Tag(0x300a, 0x0026));
    public_tags.emplace("TargetMaximumDose", Tag(0x300a, 0x0027));
    public_tags.emplace("TargetUnderdoseVolumeFraction", Tag(0x300a, 0x0028));
    public_tags.emplace("OrganAtRiskFullVolumeDose", Tag(0x300a, 0x002a));
    public_tags.emplace("OrganAtRiskLimitDose", Tag(0x300a, 0x002b));
    public_tags.emplace("OrganAtRiskMaximumDose", Tag(0x300a, 0x002c));
    public_tags.emplace("OrganAtRiskOverdoseVolumeFraction", Tag(0x300a, 0x002d));
    public_tags.emplace("ToleranceTableSequence", Tag(0x300a, 0x0040));
    public_tags.emplace("ToleranceTableNumber", Tag(0x300a, 0x0042));
    public_tags.emplace("ToleranceTableLabel", Tag(0x300a, 0x0043));
    public_tags.emplace("GantryAngleTolerance", Tag(0x300a, 0x0044));
    public_tags.emplace("BeamLimitingDeviceAngleTolerance", Tag(0x300a, 0x0046));
    public_tags.emplace("BeamLimitingDeviceToleranceSequence", Tag(0x300a, 0x0048));
    public_tags.emplace("BeamLimitingDevicePositionTolerance", Tag(0x300a, 0x004a));
    public_tags.emplace("SnoutPositionTolerance", Tag(0x300a, 0x004b));
    public_tags.emplace("PatientSupportAngleTolerance", Tag(0x300a, 0x004c));
    public_tags.emplace("TableTopEccentricAngleTolerance", Tag(0x300a, 0x004e));
    public_tags.emplace("TableTopPitchAngleTolerance", Tag(0x300a, 0x004f));
    public_tags.emplace("TableTopRollAngleTolerance", Tag(0x300a, 0x0050));
    public_tags.emplace("TableTopVerticalPositionTolerance", Tag(0x300a, 0x0051));
    public_tags.emplace("TableTopLongitudinalPositionTolerance", Tag(0x300a, 0x0052));
    public_tags.emplace("TableTopLateralPositionTolerance", Tag(0x300a, 0x0053));
    public_tags.emplace("RTPlanRelationship", Tag(0x300a, 0x0055));
    public_tags.emplace("FractionGroupSequence", Tag(0x300a, 0x0070));
    public_tags.emplace("FractionGroupNumber", Tag(0x300a, 0x0071));
    public_tags.emplace("FractionGroupDescription", Tag(0x300a, 0x0072));
    public_tags.emplace("NumberOfFractionsPlanned", Tag(0x300a, 0x0078));
    public_tags.emplace("NumberOfFractionPatternDigitsPerDay", Tag(0x300a, 0x0079));
    public_tags.emplace("RepeatFractionCycleLength", Tag(0x300a, 0x007a));
    public_tags.emplace("FractionPattern", Tag(0x300a, 0x007b));
    public_tags.emplace("NumberOfBeams", Tag(0x300a, 0x0080));
    public_tags.emplace("BeamDoseSpecificationPoint", Tag(0x300a, 0x0082));
    public_tags.emplace("ReferencedDoseReferenceUID", Tag(0x300a, 0x0083));
    public_tags.emplace("BeamDose", Tag(0x300a, 0x0084));
    public_tags.emplace("BeamMeterset", Tag(0x300a, 0x0086));
    public_tags.emplace("BeamDosePointDepth", Tag(0x300a, 0x0088));
    public_tags.emplace("BeamDosePointEquivalentDepth", Tag(0x300a, 0x0089));
    public_tags.emplace("BeamDosePointSSD", Tag(0x300a, 0x008a));
    public_tags.emplace("BeamDoseMeaning", Tag(0x300a, 0x008b));
    public_tags.emplace("BeamDoseVerificationControlPointSequence", Tag(0x300a, 0x008c));
    public_tags.emplace("AverageBeamDosePointDepth", Tag(0x300a, 0x008d));
    public_tags.emplace("AverageBeamDosePointEquivalentDepth", Tag(0x300a, 0x008e));
    public_tags.emplace("AverageBeamDosePointSSD", Tag(0x300a, 0x008f));
    public_tags.emplace("BeamDoseType", Tag(0x300a, 0x0090));
    public_tags.emplace("AlternateBeamDose", Tag(0x300a, 0x0091));
    public_tags.emplace("AlternateBeamDoseType", Tag(0x300a, 0x0092));
    public_tags.emplace("DepthValueAveragingFlag", Tag(0x300a, 0x0093));
    public_tags.emplace("BeamDosePointSourceToExternalContourDistance", Tag(0x300a, 0x0094));
    public_tags.emplace("NumberOfBrachyApplicationSetups", Tag(0x300a, 0x00a0));
    public_tags.emplace("BrachyApplicationSetupDoseSpecificationPoint", Tag(0x300a, 0x00a2));
    public_tags.emplace("BrachyApplicationSetupDose", Tag(0x300a, 0x00a4));
    public_tags.emplace("BeamSequence", Tag(0x300a, 0x00b0));
    public_tags.emplace("TreatmentMachineName", Tag(0x300a, 0x00b2));
    public_tags.emplace("PrimaryDosimeterUnit", Tag(0x300a, 0x00b3));
    public_tags.emplace("SourceAxisDistance", Tag(0x300a, 0x00b4));
    public_tags.emplace("BeamLimitingDeviceSequence", Tag(0x300a, 0x00b6));
    public_tags.emplace("RTBeamLimitingDeviceType", Tag(0x300a, 0x00b8));
    public_tags.emplace("SourceToBeamLimitingDeviceDistance", Tag(0x300a, 0x00ba));
    public_tags.emplace("IsocenterToBeamLimitingDeviceDistance", Tag(0x300a, 0x00bb));
    public_tags.emplace("NumberOfLeafJawPairs", Tag(0x300a, 0x00bc));
    public_tags.emplace("LeafPositionBoundaries", Tag(0x300a, 0x00be));
    public_tags.emplace("BeamNumber", Tag(0x300a, 0x00c0));
    public_tags.emplace("BeamName", Tag(0x300a, 0x00c2));
    public_tags.emplace("BeamDescription", Tag(0x300a, 0x00c3));
    public_tags.emplace("BeamType", Tag(0x300a, 0x00c4));
    public_tags.emplace("BeamDeliveryDurationLimit", Tag(0x300a, 0x00c5));
    public_tags.emplace("RadiationType", Tag(0x300a, 0x00c6));
    public_tags.emplace("HighDoseTechniqueType", Tag(0x300a, 0x00c7));
    public_tags.emplace("ReferenceImageNumber", Tag(0x300a, 0x00c8));
    public_tags.emplace("PlannedVerificationImageSequence", Tag(0x300a, 0x00ca));
    public_tags.emplace("ImagingDeviceSpecificAcquisitionParameters", Tag(0x300a, 0x00cc));
    public_tags.emplace("TreatmentDeliveryType", Tag(0x300a, 0x00ce));
    public_tags.emplace("NumberOfWedges", Tag(0x300a, 0x00d0));
    public_tags.emplace("WedgeSequence", Tag(0x300a, 0x00d1));
    public_tags.emplace("WedgeNumber", Tag(0x300a, 0x00d2));
    public_tags.emplace("WedgeType", Tag(0x300a, 0x00d3));
    public_tags.emplace("WedgeID", Tag(0x300a, 0x00d4));
    public_tags.emplace("WedgeAngle", Tag(0x300a, 0x00d5));
    public_tags.emplace("WedgeFactor", Tag(0x300a, 0x00d6));
    public_tags.emplace("TotalWedgeTrayWaterEquivalentThickness", Tag(0x300a, 0x00d7));
    public_tags.emplace("WedgeOrientation", Tag(0x300a, 0x00d8));
    public_tags.emplace("IsocenterToWedgeTrayDistance", Tag(0x300a, 0x00d9));
    public_tags.emplace("SourceToWedgeTrayDistance", Tag(0x300a, 0x00da));
    public_tags.emplace("WedgeThinEdgePosition", Tag(0x300a, 0x00db));
    public_tags.emplace("BolusID", Tag(0x300a, 0x00dc));
    public_tags.emplace("BolusDescription", Tag(0x300a, 0x00dd));
    public_tags.emplace("EffectiveWedgeAngle", Tag(0x300a, 0x00de));
    public_tags.emplace("NumberOfCompensators", Tag(0x300a, 0x00e0));
    public_tags.emplace("MaterialID", Tag(0x300a, 0x00e1));
    public_tags.emplace("TotalCompensatorTrayFactor", Tag(0x300a, 0x00e2));
    public_tags.emplace("CompensatorSequence", Tag(0x300a, 0x00e3));
    public_tags.emplace("CompensatorNumber", Tag(0x300a, 0x00e4));
    public_tags.emplace("CompensatorID", Tag(0x300a, 0x00e5));
    public_tags.emplace("SourceToCompensatorTrayDistance", Tag(0x300a, 0x00e6));
    public_tags.emplace("CompensatorRows", Tag(0x300a, 0x00e7));
    public_tags.emplace("CompensatorColumns", Tag(0x300a, 0x00e8));
    public_tags.emplace("CompensatorPixelSpacing", Tag(0x300a, 0x00e9));
    public_tags.emplace("CompensatorPosition", Tag(0x300a, 0x00ea));
    public_tags.emplace("CompensatorTransmissionData", Tag(0x300a, 0x00eb));
    public_tags.emplace("CompensatorThicknessData", Tag(0x300a, 0x00ec));
    public_tags.emplace("NumberOfBoli", Tag(0x300a, 0x00ed));
    public_tags.emplace("CompensatorType", Tag(0x300a, 0x00ee));
    public_tags.emplace("CompensatorTrayID", Tag(0x300a, 0x00ef));
    public_tags.emplace("NumberOfBlocks", Tag(0x300a, 0x00f0));
    public_tags.emplace("TotalBlockTrayFactor", Tag(0x300a, 0x00f2));
    public_tags.emplace("TotalBlockTrayWaterEquivalentThickness", Tag(0x300a, 0x00f3));
    public_tags.emplace("BlockSequence", Tag(0x300a, 0x00f4));
    public_tags.emplace("BlockTrayID", Tag(0x300a, 0x00f5));
    public_tags.emplace("SourceToBlockTrayDistance", Tag(0x300a, 0x00f6));
    public_tags.emplace("IsocenterToBlockTrayDistance", Tag(0x300a, 0x00f7));
    public_tags.emplace("BlockType", Tag(0x300a, 0x00f8));
    public_tags.emplace("AccessoryCode", Tag(0x300a, 0x00f9));
    public_tags.emplace("BlockDivergence", Tag(0x300a, 0x00fa));
    public_tags.emplace("BlockMountingPosition", Tag(0x300a, 0x00fb));
    public_tags.emplace("BlockNumber", Tag(0x300a, 0x00fc));
    public_tags.emplace("BlockName", Tag(0x300a, 0x00fe));
    public_tags.emplace("BlockThickness", Tag(0x300a, 0x0100));
    public_tags.emplace("BlockTransmission", Tag(0x300a, 0x0102));
    public_tags.emplace("BlockNumberOfPoints", Tag(0x300a, 0x0104));
    public_tags.emplace("BlockData", Tag(0x300a, 0x0106));
    public_tags.emplace("ApplicatorSequence", Tag(0x300a, 0x0107));
    public_tags.emplace("ApplicatorID", Tag(0x300a, 0x0108));
    public_tags.emplace("ApplicatorType", Tag(0x300a, 0x0109));
    public_tags.emplace("ApplicatorDescription", Tag(0x300a, 0x010a));
    public_tags.emplace("CumulativeDoseReferenceCoefficient", Tag(0x300a, 0x010c));
    public_tags.emplace("FinalCumulativeMetersetWeight", Tag(0x300a, 0x010e));
    public_tags.emplace("NumberOfControlPoints", Tag(0x300a, 0x0110));
    public_tags.emplace("ControlPointSequence", Tag(0x300a, 0x0111));
    public_tags.emplace("ControlPointIndex", Tag(0x300a, 0x0112));
    public_tags.emplace("NominalBeamEnergy", Tag(0x300a, 0x0114));
    public_tags.emplace("DoseRateSet", Tag(0x300a, 0x0115));
    public_tags.emplace("WedgePositionSequence", Tag(0x300a, 0x0116));
    public_tags.emplace("WedgePosition", Tag(0x300a, 0x0118));
    public_tags.emplace("BeamLimitingDevicePositionSequence", Tag(0x300a, 0x011a));
    public_tags.emplace("LeafJawPositions", Tag(0x300a, 0x011c));
    public_tags.emplace("GantryAngle", Tag(0x300a, 0x011e));
    public_tags.emplace("GantryRotationDirection", Tag(0x300a, 0x011f));
    public_tags.emplace("BeamLimitingDeviceAngle", Tag(0x300a, 0x0120));
    public_tags.emplace("BeamLimitingDeviceRotationDirection", Tag(0x300a, 0x0121));
    public_tags.emplace("PatientSupportAngle", Tag(0x300a, 0x0122));
    public_tags.emplace("PatientSupportRotationDirection", Tag(0x300a, 0x0123));
    public_tags.emplace("TableTopEccentricAxisDistance", Tag(0x300a, 0x0124));
    public_tags.emplace("TableTopEccentricAngle", Tag(0x300a, 0x0125));
    public_tags.emplace("TableTopEccentricRotationDirection", Tag(0x300a, 0x0126));
    public_tags.emplace("TableTopVerticalPosition", Tag(0x300a, 0x0128));
    public_tags.emplace("TableTopLongitudinalPosition", Tag(0x300a, 0x0129));
    public_tags.emplace("TableTopLateralPosition", Tag(0x300a, 0x012a));
    public_tags.emplace("IsocenterPosition", Tag(0x300a, 0x012c));
    public_tags.emplace("SurfaceEntryPoint", Tag(0x300a, 0x012e));
    public_tags.emplace("SourceToSurfaceDistance", Tag(0x300a, 0x0130));
    public_tags.emplace("AverageBeamDosePointSourceToExternalContourDistance", Tag(0x300a, 0x0131));
    public_tags.emplace("SourceToExternalContourDistance", Tag(0x300a, 0x0132));
    public_tags.emplace("ExternalContourEntryPoint", Tag(0x300a, 0x0133));
    public_tags.emplace("CumulativeMetersetWeight", Tag(0x300a, 0x0134));
    public_tags.emplace("TableTopPitchAngle", Tag(0x300a, 0x0140));
    public_tags.emplace("TableTopPitchRotationDirection", Tag(0x300a, 0x0142));
    public_tags.emplace("TableTopRollAngle", Tag(0x300a, 0x0144));
    public_tags.emplace("TableTopRollRotationDirection", Tag(0x300a, 0x0146));
    public_tags.emplace("HeadFixationAngle", Tag(0x300a, 0x0148));
    public_tags.emplace("GantryPitchAngle", Tag(0x300a, 0x014a));
    public_tags.emplace("GantryPitchRotationDirection", Tag(0x300a, 0x014c));
    public_tags.emplace("GantryPitchAngleTolerance", Tag(0x300a, 0x014e));
    public_tags.emplace("FixationEye", Tag(0x300a, 0x0150));
    public_tags.emplace("ChairHeadFramePosition", Tag(0x300a, 0x0151));
    public_tags.emplace("HeadFixationAngleTolerance", Tag(0x300a, 0x0152));
    public_tags.emplace("ChairHeadFramePositionTolerance", Tag(0x300a, 0x0153));
    public_tags.emplace("FixationLightAzimuthalAngleTolerance", Tag(0x300a, 0x0154));
    public_tags.emplace("FixationLightPolarAngleTolerance", Tag(0x300a, 0x0155));
    public_tags.emplace("PatientSetupSequence", Tag(0x300a, 0x0180));
    public_tags.emplace("PatientSetupNumber", Tag(0x300a, 0x0182));
    public_tags.emplace("PatientSetupLabel", Tag(0x300a, 0x0183));
    public_tags.emplace("PatientAdditionalPosition", Tag(0x300a, 0x0184));
    public_tags.emplace("FixationDeviceSequence", Tag(0x300a, 0x0190));
    public_tags.emplace("FixationDeviceType", Tag(0x300a, 0x0192));
    public_tags.emplace("FixationDeviceLabel", Tag(0x300a, 0x0194));
    public_tags.emplace("FixationDeviceDescription", Tag(0x300a, 0x0196));
    public_tags.emplace("FixationDevicePosition", Tag(0x300a, 0x0198));
    public_tags.emplace("FixationDevicePitchAngle", Tag(0x300a, 0x0199));
    public_tags.emplace("FixationDeviceRollAngle", Tag(0x300a, 0x019a));
    public_tags.emplace("ShieldingDeviceSequence", Tag(0x300a, 0x01a0));
    public_tags.emplace("ShieldingDeviceType", Tag(0x300a, 0x01a2));
    public_tags.emplace("ShieldingDeviceLabel", Tag(0x300a, 0x01a4));
    public_tags.emplace("ShieldingDeviceDescription", Tag(0x300a, 0x01a6));
    public_tags.emplace("ShieldingDevicePosition", Tag(0x300a, 0x01a8));
    public_tags.emplace("SetupTechnique", Tag(0x300a, 0x01b0));
    public_tags.emplace("SetupTechniqueDescription", Tag(0x300a, 0x01b2));
    public_tags.emplace("SetupDeviceSequence", Tag(0x300a, 0x01b4));
    public_tags.emplace("SetupDeviceType", Tag(0x300a, 0x01b6));
    public_tags.emplace("SetupDeviceLabel", Tag(0x300a, 0x01b8));
    public_tags.emplace("SetupDeviceDescription", Tag(0x300a, 0x01ba));
    public_tags.emplace("SetupDeviceParameter", Tag(0x300a, 0x01bc));
    public_tags.emplace("SetupReferenceDescription", Tag(0x300a, 0x01d0));
    public_tags.emplace("TableTopVerticalSetupDisplacement", Tag(0x300a, 0x01d2));
    public_tags.emplace("TableTopLongitudinalSetupDisplacement", Tag(0x300a, 0x01d4));
    public_tags.emplace("TableTopLateralSetupDisplacement", Tag(0x300a, 0x01d6));
    public_tags.emplace("BrachyTreatmentTechnique", Tag(0x300a, 0x0200));
    public_tags.emplace("BrachyTreatmentType", Tag(0x300a, 0x0202));
    public_tags.emplace("TreatmentMachineSequence", Tag(0x300a, 0x0206));
    public_tags.emplace("SourceSequence", Tag(0x300a, 0x0210));
    public_tags.emplace("SourceNumber", Tag(0x300a, 0x0212));
    public_tags.emplace("SourceType", Tag(0x300a, 0x0214));
    public_tags.emplace("SourceManufacturer", Tag(0x300a, 0x0216));
    public_tags.emplace("ActiveSourceDiameter", Tag(0x300a, 0x0218));
    public_tags.emplace("ActiveSourceLength", Tag(0x300a, 0x021a));
    public_tags.emplace("SourceModelID", Tag(0x300a, 0x021b));
    public_tags.emplace("SourceDescription", Tag(0x300a, 0x021c));
    public_tags.emplace("SourceEncapsulationNominalThickness", Tag(0x300a, 0x0222));
    public_tags.emplace("SourceEncapsulationNominalTransmission", Tag(0x300a, 0x0224));
    public_tags.emplace("SourceIsotopeName", Tag(0x300a, 0x0226));
    public_tags.emplace("SourceIsotopeHalfLife", Tag(0x300a, 0x0228));
    public_tags.emplace("SourceStrengthUnits", Tag(0x300a, 0x0229));
    public_tags.emplace("ReferenceAirKermaRate", Tag(0x300a, 0x022a));
    public_tags.emplace("SourceStrength", Tag(0x300a, 0x022b));
    public_tags.emplace("SourceStrengthReferenceDate", Tag(0x300a, 0x022c));
    public_tags.emplace("SourceStrengthReferenceTime", Tag(0x300a, 0x022e));
    public_tags.emplace("ApplicationSetupSequence", Tag(0x300a, 0x0230));
    public_tags.emplace("ApplicationSetupType", Tag(0x300a, 0x0232));
    public_tags.emplace("ApplicationSetupNumber", Tag(0x300a, 0x0234));
    public_tags.emplace("ApplicationSetupName", Tag(0x300a, 0x0236));
    public_tags.emplace("ApplicationSetupManufacturer", Tag(0x300a, 0x0238));
    public_tags.emplace("TemplateNumber", Tag(0x300a, 0x0240));
    public_tags.emplace("TemplateType", Tag(0x300a, 0x0242));
    public_tags.emplace("TemplateName", Tag(0x300a, 0x0244));
    public_tags.emplace("TotalReferenceAirKerma", Tag(0x300a, 0x0250));
    public_tags.emplace("BrachyAccessoryDeviceSequence", Tag(0x300a, 0x0260));
    public_tags.emplace("BrachyAccessoryDeviceNumber", Tag(0x300a, 0x0262));
    public_tags.emplace("BrachyAccessoryDeviceID", Tag(0x300a, 0x0263));
    public_tags.emplace("BrachyAccessoryDeviceType", Tag(0x300a, 0x0264));
    public_tags.emplace("BrachyAccessoryDeviceName", Tag(0x300a, 0x0266));
    public_tags.emplace("BrachyAccessoryDeviceNominalThickness", Tag(0x300a, 0x026a));
    public_tags.emplace("BrachyAccessoryDeviceNominalTransmission", Tag(0x300a, 0x026c));
    public_tags.emplace("ChannelEffectiveLength", Tag(0x300a, 0x0271));
    public_tags.emplace("ChannelInnerLength", Tag(0x300a, 0x0272));
    public_tags.emplace("AfterloaderChannelID", Tag(0x300a, 0x0273));
    public_tags.emplace("SourceApplicatorTipLength", Tag(0x300a, 0x0274));
    public_tags.emplace("ChannelSequence", Tag(0x300a, 0x0280));
    public_tags.emplace("ChannelNumber", Tag(0x300a, 0x0282));
    public_tags.emplace("ChannelLength", Tag(0x300a, 0x0284));
    public_tags.emplace("ChannelTotalTime", Tag(0x300a, 0x0286));
    public_tags.emplace("SourceMovementType", Tag(0x300a, 0x0288));
    public_tags.emplace("NumberOfPulses", Tag(0x300a, 0x028a));
    public_tags.emplace("PulseRepetitionInterval", Tag(0x300a, 0x028c));
    public_tags.emplace("SourceApplicatorNumber", Tag(0x300a, 0x0290));
    public_tags.emplace("SourceApplicatorID", Tag(0x300a, 0x0291));
    public_tags.emplace("SourceApplicatorType", Tag(0x300a, 0x0292));
    public_tags.emplace("SourceApplicatorName", Tag(0x300a, 0x0294));
    public_tags.emplace("SourceApplicatorLength", Tag(0x300a, 0x0296));
    public_tags.emplace("SourceApplicatorManufacturer", Tag(0x300a, 0x0298));
    public_tags.emplace("SourceApplicatorWallNominalThickness", Tag(0x300a, 0x029c));
    public_tags.emplace("SourceApplicatorWallNominalTransmission", Tag(0x300a, 0x029e));
    public_tags.emplace("SourceApplicatorStepSize", Tag(0x300a, 0x02a0));
    public_tags.emplace("ApplicatorShapeReferencedROINumber", Tag(0x300a, 0x02a1));
    public_tags.emplace("TransferTubeNumber", Tag(0x300a, 0x02a2));
    public_tags.emplace("TransferTubeLength", Tag(0x300a, 0x02a4));
    public_tags.emplace("ChannelShieldSequence", Tag(0x300a, 0x02b0));
    public_tags.emplace("ChannelShieldNumber", Tag(0x300a, 0x02b2));
    public_tags.emplace("ChannelShieldID", Tag(0x300a, 0x02b3));
    public_tags.emplace("ChannelShieldName", Tag(0x300a, 0x02b4));
    public_tags.emplace("ChannelShieldNominalThickness", Tag(0x300a, 0x02b8));
    public_tags.emplace("ChannelShieldNominalTransmission", Tag(0x300a, 0x02ba));
    public_tags.emplace("FinalCumulativeTimeWeight", Tag(0x300a, 0x02c8));
    public_tags.emplace("BrachyControlPointSequence", Tag(0x300a, 0x02d0));
    public_tags.emplace("ControlPointRelativePosition", Tag(0x300a, 0x02d2));
    public_tags.emplace("ControlPoint3DPosition", Tag(0x300a, 0x02d4));
    public_tags.emplace("CumulativeTimeWeight", Tag(0x300a, 0x02d6));
    public_tags.emplace("CompensatorDivergence", Tag(0x300a, 0x02e0));
    public_tags.emplace("CompensatorMountingPosition", Tag(0x300a, 0x02e1));
    public_tags.emplace("SourceToCompensatorDistance", Tag(0x300a, 0x02e2));
    public_tags.emplace("TotalCompensatorTrayWaterEquivalentThickness", Tag(0x300a, 0x02e3));
    public_tags.emplace("IsocenterToCompensatorTrayDistance", Tag(0x300a, 0x02e4));
    public_tags.emplace("CompensatorColumnOffset", Tag(0x300a, 0x02e5));
    public_tags.emplace("IsocenterToCompensatorDistances", Tag(0x300a, 0x02e6));
    public_tags.emplace("CompensatorRelativeStoppingPowerRatio", Tag(0x300a, 0x02e7));
    public_tags.emplace("CompensatorMillingToolDiameter", Tag(0x300a, 0x02e8));
    public_tags.emplace("IonRangeCompensatorSequence", Tag(0x300a, 0x02ea));
    public_tags.emplace("CompensatorDescription", Tag(0x300a, 0x02eb));
    public_tags.emplace("RadiationMassNumber", Tag(0x300a, 0x0302));
    public_tags.emplace("RadiationAtomicNumber", Tag(0x300a, 0x0304));
    public_tags.emplace("RadiationChargeState", Tag(0x300a, 0x0306));
    public_tags.emplace("ScanMode", Tag(0x300a, 0x0308));
    public_tags.emplace("ModulatedScanModeType", Tag(0x300a, 0x0309));
    public_tags.emplace("VirtualSourceAxisDistances", Tag(0x300a, 0x030a));
    public_tags.emplace("SnoutSequence", Tag(0x300a, 0x030c));
    public_tags.emplace("SnoutPosition", Tag(0x300a, 0x030d));
    public_tags.emplace("SnoutID", Tag(0x300a, 0x030f));
    public_tags.emplace("NumberOfRangeShifters", Tag(0x300a, 0x0312));
    public_tags.emplace("RangeShifterSequence", Tag(0x300a, 0x0314));
    public_tags.emplace("RangeShifterNumber", Tag(0x300a, 0x0316));
    public_tags.emplace("RangeShifterID", Tag(0x300a, 0x0318));
    public_tags.emplace("RangeShifterType", Tag(0x300a, 0x0320));
    public_tags.emplace("RangeShifterDescription", Tag(0x300a, 0x0322));
    public_tags.emplace("NumberOfLateralSpreadingDevices", Tag(0x300a, 0x0330));
    public_tags.emplace("LateralSpreadingDeviceSequence", Tag(0x300a, 0x0332));
    public_tags.emplace("LateralSpreadingDeviceNumber", Tag(0x300a, 0x0334));
    public_tags.emplace("LateralSpreadingDeviceID", Tag(0x300a, 0x0336));
    public_tags.emplace("LateralSpreadingDeviceType", Tag(0x300a, 0x0338));
    public_tags.emplace("LateralSpreadingDeviceDescription", Tag(0x300a, 0x033a));
    public_tags.emplace("LateralSpreadingDeviceWaterEquivalentThickness", Tag(0x300a, 0x033c));
    public_tags.emplace("NumberOfRangeModulators", Tag(0x300a, 0x0340));
    public_tags.emplace("RangeModulatorSequence", Tag(0x300a, 0x0342));
    public_tags.emplace("RangeModulatorNumber", Tag(0x300a, 0x0344));
    public_tags.emplace("RangeModulatorID", Tag(0x300a, 0x0346));
    public_tags.emplace("RangeModulatorType", Tag(0x300a, 0x0348));
    public_tags.emplace("RangeModulatorDescription", Tag(0x300a, 0x034a));
    public_tags.emplace("BeamCurrentModulationID", Tag(0x300a, 0x034c));
    public_tags.emplace("PatientSupportType", Tag(0x300a, 0x0350));
    public_tags.emplace("PatientSupportID", Tag(0x300a, 0x0352));
    public_tags.emplace("PatientSupportAccessoryCode", Tag(0x300a, 0x0354));
    public_tags.emplace("TrayAccessoryCode", Tag(0x300a, 0x0355));
    public_tags.emplace("FixationLightAzimuthalAngle", Tag(0x300a, 0x0356));
    public_tags.emplace("FixationLightPolarAngle", Tag(0x300a, 0x0358));
    public_tags.emplace("MetersetRate", Tag(0x300a, 0x035a));
    public_tags.emplace("RangeShifterSettingsSequence", Tag(0x300a, 0x0360));
    public_tags.emplace("RangeShifterSetting", Tag(0x300a, 0x0362));
    public_tags.emplace("IsocenterToRangeShifterDistance", Tag(0x300a, 0x0364));
    public_tags.emplace("RangeShifterWaterEquivalentThickness", Tag(0x300a, 0x0366));
    public_tags.emplace("LateralSpreadingDeviceSettingsSequence", Tag(0x300a, 0x0370));
    public_tags.emplace("LateralSpreadingDeviceSetting", Tag(0x300a, 0x0372));
    public_tags.emplace("IsocenterToLateralSpreadingDeviceDistance", Tag(0x300a, 0x0374));
    public_tags.emplace("RangeModulatorSettingsSequence", Tag(0x300a, 0x0380));
    public_tags.emplace("RangeModulatorGatingStartValue", Tag(0x300a, 0x0382));
    public_tags.emplace("RangeModulatorGatingStopValue", Tag(0x300a, 0x0384));
    public_tags.emplace("RangeModulatorGatingStartWaterEquivalentThickness", Tag(0x300a, 0x0386));
    public_tags.emplace("RangeModulatorGatingStopWaterEquivalentThickness", Tag(0x300a, 0x0388));
    public_tags.emplace("IsocenterToRangeModulatorDistance", Tag(0x300a, 0x038a));
    public_tags.emplace("ScanSpotTimeOffset", Tag(0x300a, 0x038f));
    public_tags.emplace("ScanSpotTuneID", Tag(0x300a, 0x0390));
    public_tags.emplace("ScanSpotPrescribedIndices", Tag(0x300a, 0x0391));
    public_tags.emplace("NumberOfScanSpotPositions", Tag(0x300a, 0x0392));
    public_tags.emplace("ScanSpotReordered", Tag(0x300a, 0x0393));
    public_tags.emplace("ScanSpotPositionMap", Tag(0x300a, 0x0394));
    public_tags.emplace("ScanSpotReorderingAllowed", Tag(0x300a, 0x0395));
    public_tags.emplace("ScanSpotMetersetWeights", Tag(0x300a, 0x0396));
    public_tags.emplace("ScanningSpotSize", Tag(0x300a, 0x0398));
    public_tags.emplace("ScanSpotSizesDelivered", Tag(0x300a, 0x0399));
    public_tags.emplace("NumberOfPaintings", Tag(0x300a, 0x039a));
    public_tags.emplace("IonToleranceTableSequence", Tag(0x300a, 0x03a0));
    public_tags.emplace("IonBeamSequence", Tag(0x300a, 0x03a2));
    public_tags.emplace("IonBeamLimitingDeviceSequence", Tag(0x300a, 0x03a4));
    public_tags.emplace("IonBlockSequence", Tag(0x300a, 0x03a6));
    public_tags.emplace("IonControlPointSequence", Tag(0x300a, 0x03a8));
    public_tags.emplace("IonWedgeSequence", Tag(0x300a, 0x03aa));
    public_tags.emplace("IonWedgePositionSequence", Tag(0x300a, 0x03ac));
    public_tags.emplace("ReferencedSetupImageSequence", Tag(0x300a, 0x0401));
    public_tags.emplace("SetupImageComment", Tag(0x300a, 0x0402));
    public_tags.emplace("MotionSynchronizationSequence", Tag(0x300a, 0x0410));
    public_tags.emplace("ControlPointOrientation", Tag(0x300a, 0x0412));
    public_tags.emplace("GeneralAccessorySequence", Tag(0x300a, 0x0420));
    public_tags.emplace("GeneralAccessoryID", Tag(0x300a, 0x0421));
    public_tags.emplace("GeneralAccessoryDescription", Tag(0x300a, 0x0422));
    public_tags.emplace("GeneralAccessoryType", Tag(0x300a, 0x0423));
    public_tags.emplace("GeneralAccessoryNumber", Tag(0x300a, 0x0424));
    public_tags.emplace("SourceToGeneralAccessoryDistance", Tag(0x300a, 0x0425));
    public_tags.emplace("IsocenterToGeneralAccessoryDistance", Tag(0x300a, 0x0426));
    public_tags.emplace("ApplicatorGeometrySequence", Tag(0x300a, 0x0431));
    public_tags.emplace("ApplicatorApertureShape", Tag(0x300a, 0x0432));
    public_tags.emplace("ApplicatorOpening", Tag(0x300a, 0x0433));
    public_tags.emplace("ApplicatorOpeningX", Tag(0x300a, 0x0434));
    public_tags.emplace("ApplicatorOpeningY", Tag(0x300a, 0x0435));
    public_tags.emplace("SourceToApplicatorMountingPositionDistance", Tag(0x300a, 0x0436));
    public_tags.emplace("NumberOfBlockSlabItems", Tag(0x300a, 0x0440));
    public_tags.emplace("BlockSlabSequence", Tag(0x300a, 0x0441));
    public_tags.emplace("BlockSlabThickness", Tag(0x300a, 0x0442));
    public_tags.emplace("BlockSlabNumber", Tag(0x300a, 0x0443));
    public_tags.emplace("DeviceMotionControlSequence", Tag(0x300a, 0x0450));
    public_tags.emplace("DeviceMotionExecutionMode", Tag(0x300a, 0x0451));
    public_tags.emplace("DeviceMotionObservationMode", Tag(0x300a, 0x0452));
    public_tags.emplace("DeviceMotionParameterCodeSequence", Tag(0x300a, 0x0453));
    public_tags.emplace("DistalDepthFraction", Tag(0x300a, 0x0501));
    public_tags.emplace("DistalDepth", Tag(0x300a, 0x0502));
    public_tags.emplace("NominalRangeModulationFractions", Tag(0x300a, 0x0503));
    public_tags.emplace("NominalRangeModulatedRegionDepths", Tag(0x300a, 0x0504));
    public_tags.emplace("DepthDoseParametersSequence", Tag(0x300a, 0x0505));
    public_tags.emplace("DeliveredDepthDoseParametersSequence", Tag(0x300a, 0x0506));
    public_tags.emplace("DeliveredDistalDepthFraction", Tag(0x300a, 0x0507));
    public_tags.emplace("DeliveredDistalDepth", Tag(0x300a, 0x0508));
    public_tags.emplace("DeliveredNominalRangeModulationFractions", Tag(0x300a, 0x0509));
    public_tags.emplace("DeliveredNominalRangeModulatedRegionDepths", Tag(0x300a, 0x0510));
    public_tags.emplace("DeliveredReferenceDoseDefinition", Tag(0x300a, 0x0511));
    public_tags.emplace("ReferenceDoseDefinition", Tag(0x300a, 0x0512));
    public_tags.emplace("RTControlPointIndex", Tag(0x300a, 0x0600));
    public_tags.emplace("RadiationGenerationModeIndex", Tag(0x300a, 0x0601));
    public_tags.emplace("ReferencedDefinedDeviceIndex", Tag(0x300a, 0x0602));
    public_tags.emplace("RadiationDoseIdentificationIndex", Tag(0x300a, 0x0603));
    public_tags.emplace("NumberOfRTControlPoints", Tag(0x300a, 0x0604));
    public_tags.emplace("ReferencedRadiationGenerationModeIndex", Tag(0x300a, 0x0605));
    public_tags.emplace("TreatmentPositionIndex", Tag(0x300a, 0x0606));
    public_tags.emplace("ReferencedDeviceIndex", Tag(0x300a, 0x0607));
    public_tags.emplace("TreatmentPositionGroupLabel", Tag(0x300a, 0x0608));
    public_tags.emplace("TreatmentPositionGroupUID", Tag(0x300a, 0x0609));
    public_tags.emplace("TreatmentPositionGroupSequence", Tag(0x300a, 0x060a));
    public_tags.emplace("ReferencedTreatmentPositionIndex", Tag(0x300a, 0x060b));
    public_tags.emplace("ReferencedRadiationDoseIdentificationIndex", Tag(0x300a, 0x060c));
    public_tags.emplace("RTAccessoryHolderWaterEquivalentThickness", Tag(0x300a, 0x060d));
    public_tags.emplace("ReferencedRTAccessoryHolderDeviceIndex", Tag(0x300a, 0x060e));
    public_tags.emplace("RTAccessoryHolderSlotExistenceFlag", Tag(0x300a, 0x060f));
    public_tags.emplace("RTAccessoryHolderSlotSequence", Tag(0x300a, 0x0610));
    public_tags.emplace("RTAccessoryHolderSlotID", Tag(0x300a, 0x0611));
    public_tags.emplace("RTAccessoryHolderSlotDistance", Tag(0x300a, 0x0612));
    public_tags.emplace("RTAccessorySlotDistance", Tag(0x300a, 0x0613));
    public_tags.emplace("RTAccessoryHolderDefinitionSequence", Tag(0x300a, 0x0614));
    public_tags.emplace("RTAccessoryDeviceSlotID", Tag(0x300a, 0x0615));
    public_tags.emplace("RTRadiationSequence", Tag(0x300a, 0x0616));
    public_tags.emplace("RadiationDoseSequence", Tag(0x300a, 0x0617));
    public_tags.emplace("RadiationDoseIdentificationSequence", Tag(0x300a, 0x0618));
    public_tags.emplace("RadiationDoseIdentificationLabel", Tag(0x300a, 0x0619));
    public_tags.emplace("ReferenceDoseType", Tag(0x300a, 0x061a));
    public_tags.emplace("PrimaryDoseValueIndicator", Tag(0x300a, 0x061b));
    public_tags.emplace("DoseValuesSequence", Tag(0x300a, 0x061c));
    public_tags.emplace("DoseValuePurpose", Tag(0x300a, 0x061d));
    public_tags.emplace("ReferenceDosePointCoordinates", Tag(0x300a, 0x061e));
    public_tags.emplace("RadiationDoseValuesParametersSequence", Tag(0x300a, 0x061f));
    public_tags.emplace("MetersetToDoseMappingSequence", Tag(0x300a, 0x0620));
    public_tags.emplace("ExpectedInVivoMeasurementValuesSequence", Tag(0x300a, 0x0621));
    public_tags.emplace("ExpectedInVivoMeasurementValueIndex", Tag(0x300a, 0x0622));
    public_tags.emplace("RadiationDoseInVivoMeasurementLabel", Tag(0x300a, 0x0623));
    public_tags.emplace("RadiationDoseCentralAxisDisplacement", Tag(0x300a, 0x0624));
    public_tags.emplace("RadiationDoseValue", Tag(0x300a, 0x0625));
    public_tags.emplace("RadiationDoseSourceToSkinDistance", Tag(0x300a, 0x0626));
    public_tags.emplace("RadiationDoseMeasurementPointCoordinates", Tag(0x300a, 0x0627));
    public_tags.emplace("RadiationDoseSourceToExternalContourDistance", Tag(0x300a, 0x0628));
    public_tags.emplace("RTToleranceSetSequence", Tag(0x300a, 0x0629));
    public_tags.emplace("RTToleranceSetLabel", Tag(0x300a, 0x062a));
    public_tags.emplace("AttributeToleranceValuesSequence", Tag(0x300a, 0x062b));
    public_tags.emplace("ToleranceValue", Tag(0x300a, 0x062c));
    public_tags.emplace("PatientSupportPositionToleranceSequence", Tag(0x300a, 0x062d));
    public_tags.emplace("TreatmentTimeLimit", Tag(0x300a, 0x062e));
    public_tags.emplace("CArmPhotonElectronControlPointSequence", Tag(0x300a, 0x062f));
    public_tags.emplace("ReferencedRTRadiationSequence", Tag(0x300a, 0x0630));
    public_tags.emplace("ReferencedRTInstanceSequence", Tag(0x300a, 0x0631));
    public_tags.emplace("ReferencedRTPatientSetupSequence", Tag(0x300a, 0x0632));
    public_tags.emplace("SourceToPatientSurfaceDistance", Tag(0x300a, 0x0634));
    public_tags.emplace("TreatmentMachineSpecialModeCodeSequence", Tag(0x300a, 0x0635));
    public_tags.emplace("IntendedNumberOfFractions", Tag(0x300a, 0x0636));
    public_tags.emplace("RTRadiationSetIntent", Tag(0x300a, 0x0637));
    public_tags.emplace("RTRadiationPhysicalAndGeometricContentDetailFlag", Tag(0x300a, 0x0638));
    public_tags.emplace("RTRecordFlag", Tag(0x300a, 0x0639));
    public_tags.emplace("TreatmentDeviceIdentificationSequence", Tag(0x300a, 0x063a));
    public_tags.emplace("ReferencedRTPhysicianIntentSequence", Tag(0x300a, 0x063b));
    public_tags.emplace("CumulativeMeterset", Tag(0x300a, 0x063c));
    public_tags.emplace("DeliveryRate", Tag(0x300a, 0x063d));
    public_tags.emplace("DeliveryRateUnitSequence", Tag(0x300a, 0x063e));
    public_tags.emplace("TreatmentPositionSequence", Tag(0x300a, 0x063f));
    public_tags.emplace("RadiationSourceAxisDistance", Tag(0x300a, 0x0640));
    public_tags.emplace("NumberOfRTBeamLimitingDevices", Tag(0x300a, 0x0641));
    public_tags.emplace("RTBeamLimitingDeviceProximalDistance", Tag(0x300a, 0x0642));
    public_tags.emplace("RTBeamLimitingDeviceDistalDistance", Tag(0x300a, 0x0643));
    public_tags.emplace("ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence", Tag(0x300a, 0x0644));
    public_tags.emplace("BeamModifierOrientationAngle", Tag(0x300a, 0x0645));
    public_tags.emplace("FixedRTBeamDelimiterDeviceSequence", Tag(0x300a, 0x0646));
    public_tags.emplace("ParallelRTBeamDelimiterDeviceSequence", Tag(0x300a, 0x0647));
    public_tags.emplace("NumberOfParallelRTBeamDelimiters", Tag(0x300a, 0x0648));
    public_tags.emplace("ParallelRTBeamDelimiterBoundaries", Tag(0x300a, 0x0649));
    public_tags.emplace("ParallelRTBeamDelimiterPositions", Tag(0x300a, 0x064a));
    public_tags.emplace("RTBeamLimitingDeviceOffset", Tag(0x300a, 0x064b));
    public_tags.emplace("RTBeamDelimiterGeometrySequence", Tag(0x300a, 0x064c));
    public_tags.emplace("RTBeamLimitingDeviceDefinitionSequence", Tag(0x300a, 0x064d));
    public_tags.emplace("ParallelRTBeamDelimiterOpeningMode", Tag(0x300a, 0x064e));
    public_tags.emplace("ParallelRTBeamDelimiterLeafMountingSide", Tag(0x300a, 0x064f));
    public_tags.emplace("PatientSetupUID", Tag(0x300a, 0x0650));
    public_tags.emplace("WedgeDefinitionSequence", Tag(0x300a, 0x0651));
    public_tags.emplace("RadiationBeamWedgeAngle", Tag(0x300a, 0x0652));
    public_tags.emplace("RadiationBeamWedgeThinEdgeDistance", Tag(0x300a, 0x0653));
    public_tags.emplace("RadiationBeamEffectiveWedgeAngle", Tag(0x300a, 0x0654));
    public_tags.emplace("NumberOfWedgePositions", Tag(0x300a, 0x0655));
    public_tags.emplace("RTBeamLimitingDeviceOpeningSequence", Tag(0x300a, 0x0656));
    public_tags.emplace("NumberOfRTBeamLimitingDeviceOpenings", Tag(0x300a, 0x0657));
    public_tags.emplace("RadiationDosimeterUnitSequence", Tag(0x300a, 0x0658));
    public_tags.emplace("RTDeviceDistanceReferenceLocationCodeSequence", Tag(0x300a, 0x0659));
    public_tags.emplace("RadiationDeviceConfigurationAndCommissioningKeySequence", Tag(0x300a, 0x065a));
    public_tags.emplace("PatientSupportPositionParameterSequence", Tag(0x300a, 0x065b));
    public_tags.emplace("PatientSupportPositionSpecificationMethod", Tag(0x300a, 0x065c));
    public_tags.emplace("PatientSupportPositionDeviceParameterSequence", Tag(0x300a, 0x065d));
    public_tags.emplace("DeviceOrderIndex", Tag(0x300a, 0x065e));
    public_tags.emplace("PatientSupportPositionParameterOrderIndex", Tag(0x300a, 0x065f));
    public_tags.emplace("PatientSupportPositionDeviceToleranceSequence", Tag(0x300a, 0x0660));
    public_tags.emplace("PatientSupportPositionToleranceOrderIndex", Tag(0x300a, 0x0661));
    public_tags.emplace("CompensatorDefinitionSequence", Tag(0x300a, 0x0662));
    public_tags.emplace("CompensatorMapOrientation", Tag(0x300a, 0x0663));
    public_tags.emplace("CompensatorProximalThicknessMap", Tag(0x300a, 0x0664));
    public_tags.emplace("CompensatorDistalThicknessMap", Tag(0x300a, 0x0665));
    public_tags.emplace("CompensatorBasePlaneOffset", Tag(0x300a, 0x0666));
    public_tags.emplace("CompensatorShapeFabricationCodeSequence", Tag(0x300a, 0x0667));
    public_tags.emplace("CompensatorShapeSequence", Tag(0x300a, 0x0668));
    public_tags.emplace("RadiationBeamCompensatorMillingToolDiameter", Tag(0x300a, 0x0669));
    public_tags.emplace("BlockDefinitionSequence", Tag(0x300a, 0x066a));
    public_tags.emplace("BlockEdgeData", Tag(0x300a, 0x066b));
    public_tags.emplace("BlockOrientation", Tag(0x300a, 0x066c));
    public_tags.emplace("RadiationBeamBlockThickness", Tag(0x300a, 0x066d));
    public_tags.emplace("RadiationBeamBlockSlabThickness", Tag(0x300a, 0x066e));
    public_tags.emplace("BlockEdgeDataSequence", Tag(0x300a, 0x066f));
    public_tags.emplace("NumberOfRTAccessoryHolders", Tag(0x300a, 0x0670));
    public_tags.emplace("GeneralAccessoryDefinitionSequence", Tag(0x300a, 0x0671));
    public_tags.emplace("NumberOfGeneralAccessories", Tag(0x300a, 0x0672));
    public_tags.emplace("BolusDefinitionSequence", Tag(0x300a, 0x0673));
    public_tags.emplace("NumberOfBoluses", Tag(0x300a, 0x0674));
    public_tags.emplace("EquipmentFrameOfReferenceUID", Tag(0x300a, 0x0675));
    public_tags.emplace("EquipmentFrameOfReferenceDescription", Tag(0x300a, 0x0676));
    public_tags.emplace("EquipmentReferencePointCoordinatesSequence", Tag(0x300a, 0x0677));
    public_tags.emplace("EquipmentReferencePointCodeSequence", Tag(0x300a, 0x0678));
    public_tags.emplace("RTBeamLimitingDeviceAngle", Tag(0x300a, 0x0679));
    public_tags.emplace("SourceRollAngle", Tag(0x300a, 0x067a));
    public_tags.emplace("RadiationGenerationModeSequence", Tag(0x300a, 0x067b));
    public_tags.emplace("RadiationGenerationModeLabel", Tag(0x300a, 0x067c));
    public_tags.emplace("RadiationGenerationModeDescription", Tag(0x300a, 0x067d));
    public_tags.emplace("RadiationGenerationModeMachineCodeSequence", Tag(0x300a, 0x067e));
    public_tags.emplace("RadiationTypeCodeSequence", Tag(0x300a, 0x067f));
    public_tags.emplace("NominalEnergy", Tag(0x300a, 0x0680));
    public_tags.emplace("MinimumNominalEnergy", Tag(0x300a, 0x0681));
    public_tags.emplace("MaximumNominalEnergy", Tag(0x300a, 0x0682));
    public_tags.emplace("RadiationFluenceModifierCodeSequence", Tag(0x300a, 0x0683));
    public_tags.emplace("EnergyUnitCodeSequence", Tag(0x300a, 0x0684));
    public_tags.emplace("NumberOfRadiationGenerationModes", Tag(0x300a, 0x0685));
    public_tags.emplace("PatientSupportDevicesSequence", Tag(0x300a, 0x0686));
    public_tags.emplace("NumberOfPatientSupportDevices", Tag(0x300a, 0x0687));
    public_tags.emplace("RTBeamModifierDefinitionDistance", Tag(0x300a, 0x0688));
    public_tags.emplace("BeamAreaLimitSequence", Tag(0x300a, 0x0689));
    public_tags.emplace("ReferencedRTPrescriptionSequence", Tag(0x300a, 0x068a));
    public_tags.emplace("TreatmentSessionUID", Tag(0x300a, 0x0700));
    public_tags.emplace("RTRadiationUsage", Tag(0x300a, 0x0701));
    public_tags.emplace("ReferencedRTRadiationSetSequence", Tag(0x300a, 0x0702));
    public_tags.emplace("ReferencedRTRadiationRecordSequence", Tag(0x300a, 0x0703));
    public_tags.emplace("RTRadiationSetDeliveryNumber", Tag(0x300a, 0x0704));
    public_tags.emplace("ClinicalFractionNumber", Tag(0x300a, 0x0705));
    public_tags.emplace("RTTreatmentFractionCompletionStatus", Tag(0x300a, 0x0706));
    public_tags.emplace("RTRadiationSetUsage", Tag(0x300a, 0x0707));
    public_tags.emplace("TreatmentDeliveryContinuationFlag", Tag(0x300a, 0x0708));
    public_tags.emplace("TreatmentRecordContentOrigin", Tag(0x300a, 0x0709));
    public_tags.emplace("RTTreatmentTerminationStatus", Tag(0x300a, 0x0714));
    public_tags.emplace("RTTreatmentTerminationReasonCodeSequence", Tag(0x300a, 0x0715));
    public_tags.emplace("MachineSpecificTreatmentTerminationCodeSequence", Tag(0x300a, 0x0716));
    public_tags.emplace("RTRadiationSalvageRecordControlPointSequence", Tag(0x300a, 0x0722));
    public_tags.emplace("StartingMetersetValueKnownFlag", Tag(0x300a, 0x0723));
    public_tags.emplace("TreatmentTerminationDescription", Tag(0x300a, 0x0730));
    public_tags.emplace("TreatmentToleranceViolationSequence", Tag(0x300a, 0x0731));
    public_tags.emplace("TreatmentToleranceViolationCategory", Tag(0x300a, 0x0732));
    public_tags.emplace("TreatmentToleranceViolationAttributeSequence", Tag(0x300a, 0x0733));
    public_tags.emplace("TreatmentToleranceViolationDescription", Tag(0x300a, 0x0734));
    public_tags.emplace("TreatmentToleranceViolationIdentification", Tag(0x300a, 0x0735));
    public_tags.emplace("TreatmentToleranceViolationDateTime", Tag(0x300a, 0x0736));
    public_tags.emplace("RecordedRTControlPointDateTime", Tag(0x300a, 0x073a));
    public_tags.emplace("ReferencedRadiationRTControlPointIndex", Tag(0x300a, 0x073b));
    public_tags.emplace("AlternateValueSequence", Tag(0x300a, 0x073e));
    public_tags.emplace("ConfirmationSequence", Tag(0x300a, 0x073f));
    public_tags.emplace("InterlockSequence", Tag(0x300a, 0x0740));
    public_tags.emplace("InterlockDateTime", Tag(0x300a, 0x0741));
    public_tags.emplace("InterlockDescription", Tag(0x300a, 0x0742));
    public_tags.emplace("InterlockOriginatingDeviceSequence", Tag(0x300a, 0x0743));
    public_tags.emplace("InterlockCodeSequence", Tag(0x300a, 0x0744));
    public_tags.emplace("InterlockResolutionCodeSequence", Tag(0x300a, 0x0745));
    public_tags.emplace("InterlockResolutionUserSequence", Tag(0x300a, 0x0746));
    public_tags.emplace("OverrideDateTime", Tag(0x300a, 0x0760));
    public_tags.emplace("TreatmentToleranceViolationTypeCodeSequence", Tag(0x300a, 0x0761));
    public_tags.emplace("TreatmentToleranceViolationCauseCodeSequence", Tag(0x300a, 0x0762));
    public_tags.emplace("MeasuredMetersetToDoseMappingSequence", Tag(0x300a, 0x0772));
    public_tags.emplace("ReferencedExpectedInVivoMeasurementValueIndex", Tag(0x300a, 0x0773));
    public_tags.emplace("DoseMeasurementDeviceCodeSequence", Tag(0x300a, 0x0774));
    public_tags.emplace("AdditionalParameterRecordingInstanceSequence", Tag(0x300a, 0x0780));
    public_tags.emplace("InterlockOriginDescription", Tag(0x300a, 0x0783));
    public_tags.emplace("RTPatientPositionScopeSequence", Tag(0x300a, 0x0784));
    public_tags.emplace("ReferencedTreatmentPositionGroupUID", Tag(0x300a, 0x0785));
    public_tags.emplace("RadiationOrderIndex", Tag(0x300a, 0x0786));
    public_tags.emplace("OmittedRadiationSequence", Tag(0x300a, 0x0787));
    public_tags.emplace("ReasonForOmissionCodeSequence", Tag(0x300a, 0x0788));
    public_tags.emplace("RTDeliveryStartPatientPositionSequence", Tag(0x300a, 0x0789));
    public_tags.emplace("RTTreatmentPreparationPatientPositionSequence", Tag(0x300a, 0x078a));
    public_tags.emplace("ReferencedRTTreatmentPreparationSequence", Tag(0x300a, 0x078b));
    public_tags.emplace("ReferencedPatientSetupPhotoSequence", Tag(0x300a, 0x078c));
    public_tags.emplace("PatientTreatmentPreparationMethodCodeSequence", Tag(0x300a, 0x078d));
    public_tags.emplace("PatientTreatmentPreparationProcedureParameterDescription", Tag(0x300a, 0x078e));
    public_tags.emplace("PatientTreatmentPreparationDeviceSequence", Tag(0x300a, 0x078f));
    public_tags.emplace("PatientTreatmentPreparationProcedureSequence", Tag(0x300a, 0x0790));
    public_tags.emplace("PatientTreatmentPreparationProcedureCodeSequence", Tag(0x300a, 0x0791));
    public_tags.emplace("PatientTreatmentPreparationMethodDescription", Tag(0x300a, 0x0792));
    public_tags.emplace("PatientTreatmentPreparationProcedureParameterSequence", Tag(0x300a, 0x0793));
    public_tags.emplace("PatientSetupPhotoDescription", Tag(0x300a, 0x0794));
    public_tags.emplace("PatientTreatmentPreparationProcedureIndex", Tag(0x300a, 0x0795));
    public_tags.emplace("ReferencedPatientSetupProcedureIndex", Tag(0x300a, 0x0796));
    public_tags.emplace("RTRadiationTaskSequence", Tag(0x300a, 0x0797));
    public_tags.emplace("RTPatientPositionDisplacementSequence", Tag(0x300a, 0x0798));
    public_tags.emplace("RTPatientPositionSequence", Tag(0x300a, 0x0799));
    public_tags.emplace("DisplacementReferenceLabel", Tag(0x300a, 0x079a));
    public_tags.emplace("DisplacementMatrix", Tag(0x300a, 0x079b));
    public_tags.emplace("PatientSupportDisplacementSequence", Tag(0x300a, 0x079c));
    public_tags.emplace("DisplacementReferenceLocationCodeSequence", Tag(0x300a, 0x079d));
    public_tags.emplace("RTRadiationSetDeliveryUsage", Tag(0x300a, 0x079e));
}

}

}